/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator;

import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;

public class JigsawData
implements INBTSerializable<CompoundTag> {
    private final PartialTile tile;
    private final FrontAndTop orientation;
    private final Direction facing;
    private final Direction side;
    private ResourceLocation name;
    private ResourceLocation target;
    private ResourceLocation pool;
    private BlockState finalState;
    private JigsawBlockEntity.JointType joint;

    public JigsawData(PartialTile tile) {
        this.tile = tile;
        this.orientation = (FrontAndTop)tile.getState().get(JigsawBlock.f_54222_);
        this.facing = this.orientation.m_122625_();
        this.side = this.orientation.m_122629_();
        this.deserializeNBT(tile.getEntity().asWhole().orElseGet(CompoundTag::new));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("name")) {
            this.name = new ResourceLocation(nbt.m_128461_("name"));
        }
        if (nbt.m_128441_("target")) {
            this.target = new ResourceLocation(nbt.m_128461_("target"));
        }
        if (nbt.m_128441_("pool")) {
            this.pool = new ResourceLocation(nbt.m_128461_("pool"));
        }
        if (nbt.m_128441_("final_state")) {
            this.finalState = PartialTile.parse(nbt.m_128461_("final_state"), true).map(PartialTile::getState).flatMap(PartialBlockState::asWhole).orElse(ModBlocks.ERROR_BLOCK.m_49966_());
        }
        if (nbt.m_128441_("joint")) {
            this.joint = JigsawBlockEntity.JointType.m_59457_((String)nbt.m_128461_("joint")).orElseGet(() -> ((FrontAndTop)this.tile.getState().get(JigsawBlock.f_54222_)).m_122625_().m_122434_().m_122479_() ? JigsawBlockEntity.JointType.ALIGNED : JigsawBlockEntity.JointType.ROLLABLE);
        }
    }

    public FrontAndTop getOrientation() {
        return this.orientation;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public Direction getSide() {
        return this.side;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public ResourceLocation getTarget() {
        return this.target;
    }

    public ResourceLocation getPool() {
        return this.pool;
    }

    public BlockState getFinalState() {
        return this.finalState;
    }

    public JigsawBlockEntity.JointType getJoint() {
        return this.joint;
    }

    public BlockPos getPos() {
        return this.tile.getPos();
    }
}

