/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class OverflowExecutor {
    private static final long BURST_WINDOW_NANOS = 500000000L;
    private static final int BURST_THRESHOLD = 3;

    private OverflowExecutor() {
    }

    public static ExecutorService create(int coreThreads, int overflowThreads, int queueCapacity, ThreadFactory factory) {
        ThreadPoolExecutor overflowPool = new ThreadPoolExecutor(overflowThreads, overflowThreads, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread t = factory.newThread(runnable);
            t.setDaemon(true);
            t.setName("Vault-Overflow-" + t.getName());
            return t;
        });
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(queueCapacity);
        AtomicBoolean draining = new AtomicBoolean(false);
        AtomicInteger burstSeq = new AtomicInteger(0);
        AtomicLong lastOverflowStamp = new AtomicLong(System.nanoTime());
        RejectedExecutionHandler rejection = (task, executor) -> {
            long now;
            overflowPool.execute(task);
            if (draining.compareAndSet(false, true)) {
                try {
                    Runnable r;
                    while ((r = (Runnable)workQueue.poll()) != null) {
                        overflowPool.execute(r);
                    }
                }
                finally {
                    draining.set(false);
                }
            }
            if ((now = System.nanoTime()) - lastOverflowStamp.get() < 500000000L) {
                if (burstSeq.incrementAndGet() > 3 && executor.getMaximumPoolSize() < coreThreads) {
                    executor.setMaximumPoolSize(executor.getMaximumPoolSize() + 1);
                    burstSeq.set(0);
                }
            } else {
                burstSeq.set(0);
            }
            lastOverflowStamp.set(now);
        };
        return new ThreadPoolExecutor(1, coreThreads, 10L, TimeUnit.MINUTES, workQueue, factory, rejection);
    }
}

