/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.cache;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.template.EmptyTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.configured.ChunkedTemplate;
import iskallia.vault.core.world.template.configured.ConfiguredTemplate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public final class ConcurrentGridCache {
    private final int capacity;
    private final ConcurrentMap<RegionPos, ConfiguredTemplate> cache = new ConcurrentHashMap<RegionPos, ConfiguredTemplate>();
    private final ConcurrentMap<RegionPos, Object> regionLocks = new ConcurrentHashMap<RegionPos, Object>();
    private final ConcurrentLinkedQueue<RegionPos> insertionOrder = new ConcurrentLinkedQueue();

    public ConcurrentGridCache(int capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfiguredTemplate getOrCreate(RegionPos region, GridLayout layout, Vault vault, ChunkRandom random) {
        Object regionLock;
        ConfiguredTemplate existing = (ConfiguredTemplate)this.cache.get((Object)region);
        if (existing != null) {
            return existing;
        }
        Object object = regionLock = this.regionLocks.computeIfAbsent(region, k -> new Object());
        synchronized (object) {
            existing = (ConfiguredTemplate)this.cache.get((Object)region);
            if (existing != null) {
                return existing;
            }
            PlacementSettings settings = new PlacementSettings(new ProcessorContext(vault, random)).setFlags(3);
            CommonEvents.TEMPLATE_CONFIGURATION.invoke(settings, vault, random, region);
            ChunkedTemplate created = layout.getAt(vault, region, random, settings).configure(ChunkedTemplate::new, settings);
            if (created.getParent() == EmptyTemplate.INSTANCE) {
                return created;
            }
            this.cache.put(region, created);
            this.insertionOrder.offer(region);
            this.evictIfNecessary();
            return created;
        }
    }

    private void evictIfNecessary() {
        while (this.cache.size() > this.capacity) {
            RegionPos oldest = this.insertionOrder.poll();
            if (oldest == null) continue;
            this.cache.remove((Object)oldest);
            this.regionLocks.remove((Object)oldest);
        }
    }

    public void clear() {
        this.cache.clear();
        this.regionLocks.clear();
        this.insertionOrder.clear();
    }
}

