/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.layout;

import com.google.gson.JsonObject;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataList;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.generator.layout.ArchitectVaultLayout;
import iskallia.vault.core.world.generator.layout.ClassicVaultLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class ArchitectRoomEntry
extends DataObject<ArchitectRoomEntry>
implements INBTSerializable<CompoundTag> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Type> TYPE = (FieldKey)FieldKey.of("type", Type.class).with(Version.v1_0, Adapters.ofEnum(Type.class, EnumAdapter.Mode.ORDINAL), DISK.all()).register(FIELDS);
    public static final FieldKey<ResourceLocation> POOL = (FieldKey)FieldKey.of("pool", ResourceLocation.class).with(Version.v1_0, Adapters.IDENTIFIER, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of("count", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_7, DISK.all()).register(FIELDS);
    public static final FieldKey<Integer> COLOR = (FieldKey)FieldKey.of("color", Integer.class).with(Version.v1_0, Adapters.INT, DISK.all()).register(FIELDS);

    private ArchitectRoomEntry() {
    }

    public static ArchitectRoomEntry ofType(Type type, int count) {
        return (ArchitectRoomEntry)((ArchitectRoomEntry)new ArchitectRoomEntry().set(TYPE, type)).set(COUNT, count);
    }

    public static ArchitectRoomEntry ofPool(ResourceLocation pool, int count) {
        return (ArchitectRoomEntry)((ArchitectRoomEntry)new ArchitectRoomEntry().set(POOL, pool)).set(COUNT, count);
    }

    public static ArchitectRoomEntry fromNBT(CompoundTag nbt) {
        ArchitectRoomEntry entry = new ArchitectRoomEntry();
        entry.deserializeNBT(nbt);
        return entry;
    }

    public static ArchitectRoomEntry fromJson(JsonObject object) {
        ArchitectRoomEntry entry = new ArchitectRoomEntry();
        entry.deserializeJson(object);
        return entry;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public Component getName() {
        TemplatePoolKey pool;
        ResourceLocation poolLocation;
        String name = this.has(TYPE) ? this.get(TYPE).getName() : ((poolLocation = this.get(POOL)) != null && poolLocation.m_135815_().toLowerCase().contains("common") ? "Common" : ((pool = VaultRegistry.TEMPLATE_POOL.getKey(poolLocation)) == null ? "Unknown" : pool.getName()));
        return new TextComponent(name).m_130948_(Style.f_131099_.m_178520_(this.getOr(COLOR, 0xFFFFFF).intValue()));
    }

    public void mergeWith(ArchitectRoomEntry other) {
        if (this.has(TYPE) && other.has(TYPE) && this.get(TYPE) == other.get(TYPE)) {
            this.modify(COUNT, i -> i + other.get(COUNT));
            other.set(COUNT, 0);
        } else if (this.has(POOL) && other.has(POOL) && this.get(POOL).equals((Object)other.get(POOL))) {
            this.modify(COUNT, i -> i + other.get(COUNT));
            other.set(COUNT, 0);
        }
    }

    public TemplatePoolKey getPool(VaultGridLayout layout) {
        if (this.has(TYPE)) {
            if (layout instanceof ArchitectVaultLayout) {
                return switch (this.get(TYPE)) {
                    default -> throw new IncompatibleClassChangeError();
                    case Type.COMMON -> layout.get(ArchitectVaultLayout.COMMON_ROOM_POOL);
                    case Type.CHALLENGE -> layout.get(ArchitectVaultLayout.CHALLENGE_ROOM_POOL);
                    case Type.OMEGA -> layout.get(ArchitectVaultLayout.OMEGA_ROOM_POOL);
                };
            }
            if (layout instanceof ClassicVaultLayout) {
                switch (this.get(TYPE)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case COMMON: 
                    case CHALLENGE: 
                    case OMEGA: 
                }
                return layout.get(ClassicVaultLayout.ROOM_POOL);
            }
        }
        return VaultRegistry.TEMPLATE_POOL.getKey(this.get(POOL));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.has(TYPE)) {
            nbt.m_128359_("type", this.get(TYPE).name());
        }
        if (this.has(POOL)) {
            nbt.m_128359_("pool", this.get(POOL).toString());
        }
        nbt.m_128405_("count", this.get(COUNT).intValue());
        if (this.has(COLOR)) {
            nbt.m_128405_("color", this.get(COLOR).intValue());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("type")) {
            this.set(TYPE, Enum.valueOf(Type.class, nbt.m_128461_("type")));
        }
        if (nbt.m_128441_("pool")) {
            this.set(POOL, new ResourceLocation(nbt.m_128461_("pool")));
        }
        this.set(COUNT, nbt.m_128451_("count"));
        if (nbt.m_128425_("color", 3)) {
            this.set(COLOR, nbt.m_128451_("color"));
        }
    }

    public JsonObject serializeJson() {
        JsonObject object = new JsonObject();
        if (this.has(TYPE)) {
            object.addProperty("type", this.get(TYPE).name());
        }
        if (this.has(POOL)) {
            object.addProperty("pool", this.get(POOL).toString());
        }
        object.addProperty("count", (Number)this.get(COUNT));
        if (this.has(COLOR)) {
            object.addProperty("color", (Number)this.getOr(COLOR, 0xFFFFFF));
        }
        return object;
    }

    public void deserializeJson(JsonObject object) {
        if (object.has("type")) {
            this.set(TYPE, Enum.valueOf(Type.class, object.get("type").getAsString()));
        }
        if (object.has("pool")) {
            this.set(POOL, new ResourceLocation(object.get("pool").getAsString()));
        }
        this.set(COUNT, object.get("count").getAsInt());
        if (object.has("color")) {
            this.set(COLOR, object.get("color").getAsInt());
        }
    }

    public static enum Type {
        COMMON,
        CHALLENGE,
        OMEGA;


        public String getName() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case COMMON -> "Common";
                case CHALLENGE -> "Challenge";
                case OMEGA -> "Omega";
            };
        }
    }

    public static class List
    extends DataList<List, ArchitectRoomEntry> {
        public List() {
            super(new ArrayList(), CompoundAdapter.of(ArchitectRoomEntry::new));
        }

        public java.util.List<TemplatePoolKey> flatten(VaultGridLayout layout) {
            ArrayList<TemplatePoolKey> result = new ArrayList<TemplatePoolKey>();
            for (ArchitectRoomEntry entry : this) {
                TemplatePoolKey pool = entry.getPool(layout);
                if (pool == null) continue;
                for (int i = 0; i < entry.get(COUNT); ++i) {
                    result.add(pool);
                }
            }
            return result;
        }

        public int getTotalCount() {
            int total = 0;
            for (ArchitectRoomEntry entry : this) {
                total += entry.get(COUNT).intValue();
            }
            return total;
        }
    }
}

