/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.layout;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.ObjectiveTemplateEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.BedrockFill;
import iskallia.vault.core.world.generator.GeneratorThreading;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.entity.EntityProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.EmptyTemplate;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.core.world.template.data.TemplateEntry;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.core.world.template.tasks.BlocksToProtoSectionTask;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;

public abstract class VaultGridLayout
extends GridLayout {
    public static final FieldRegistry FIELDS = GridLayout.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<Void> FILL_AIR = (FieldKey)FieldKey.of("fill_stone", Void.class).with(Version.v1_19, Adapters.ofVoid(), DISK.all()).register(FIELDS);

    @Override
    public void initServer(VirtualWorld world, Vault vault, GridGenerator generator) {
        CommonEvents.NOISE_GENERATION.in(world).register(this, data -> {
            if (this.has(FILL_AIR)) {
                return;
            }
            List tasks = Stream.of(0, 1, 2, 3).map(section -> GeneratorThreading.getGeneratorExecutor().submit(() -> {
                BlockPos sectionOffset = data.getChunk().m_7697_().m_45615_().m_175288_(16 * section - data.getGenRegion().m_141937_());
                new BlocksToProtoSectionTask(data.getChunk()).setBlocks((int)section, BedrockFill.blocksToFill(sectionOffset, vault), true);
            })).collect(Collectors.toList());
            for (Future task : tasks) {
                try {
                    task.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Error filling bedrock", e);
                }
            }
            data.getChunk().m_6890_().forEach(entry -> {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        ((Heightmap)entry.getValue()).m_64249_(x, 63, z, ModBlocks.VAULT_BEDROCK.m_49966_());
                    }
                }
            });
        });
    }

    @Override
    public void releaseServer() {
        CommonEvents.NOISE_GENERATION.release(this);
    }

    @Override
    public Template getAt(Vault vault, RegionPos region, RandomSource random, PlacementSettings settings) {
        VaultLayout.PieceType type = this.getType(vault, region);
        Template template = CommonEvents.LAYOUT_TEMPLATE_GENERATION.invoke(this, vault, region, random, settings, type, null).getTemplate();
        if (template == null) {
            template = this.getTemplate(type, vault, region, random, settings);
        }
        if (template instanceof JigsawTemplate) {
            JigsawTemplate jigsaw = (JigsawTemplate)template;
            this.processAllObjectivePieces(jigsaw, vault, random);
            for (JigsawTemplate child : jigsaw.getChildren()) {
                if (!child.hasTag(VaultMod.id("portal_piece"))) continue;
                ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
                if (region.m_123341_() == 0 && region.m_123343_() == 0) {
                    tags.add(ClassicPortalLogic.ENTRANCE);
                }
                tags.add(ClassicPortalLogic.EXIT);
                vault.get(Vault.WORLD).get(WorldManager.PORTAL_LOGIC).addPortal(child, settings, tags);
            }
        }
        return template;
    }

    private void processAllObjectivePieces(JigsawTemplate jigsaw, Vault vault, RandomSource random) {
        LinkedHashMap<JigsawTemplate, JigsawTemplate> pieceToParentMap = new LinkedHashMap<JigsawTemplate, JigsawTemplate>();
        this.collectObjectivePieces(jigsaw, pieceToParentMap);
        if (pieceToParentMap.isEmpty()) {
            return;
        }
        ArrayList entries = new ArrayList(pieceToParentMap.entrySet());
        Collections.shuffle(entries, new Random(random.nextLong()));
        for (Map.Entry entry : entries) {
            JigsawTemplate piece = (JigsawTemplate)entry.getKey();
            JigsawTemplate parent = (JigsawTemplate)entry.getValue();
            if (parent == null || !((double)random.nextFloat() < CommonEvents.OBJECTIVE_PIECE_GENERATION.invoke(vault, 1.0).getProbability())) continue;
            ObjectiveTemplateEvent.Data data = new ObjectiveTemplateEvent.Data(piece, vault, random);
            ObjectiveTemplateEvent.getInstance().invoke(data);
            parent.getChildren().add(data.getTemplate());
            break;
        }
    }

    private void collectObjectivePieces(JigsawTemplate jigsaw, Map<JigsawTemplate, JigsawTemplate> pieceToParentMap) {
        List<JigsawTemplate> children = jigsaw.getChildren();
        Iterator<JigsawTemplate> iterator = children.iterator();
        while (iterator.hasNext()) {
            JigsawTemplate child = iterator.next();
            if (child.hasTag(VaultMod.id("objective_piece"))) {
                pieceToParentMap.put(child, jigsaw);
                iterator.remove();
                continue;
            }
            if (!(child instanceof JigsawTemplate)) continue;
            this.collectObjectivePieces(child, pieceToParentMap);
        }
    }

    public abstract Template getTemplate(VaultLayout.PieceType var1, Vault var2, RegionPos var3, RandomSource var4, PlacementSettings var5);

    public abstract VaultLayout.PieceType getType(Vault var1, RegionPos var2);

    public Template getStart(TemplatePool pool, Version version, RegionPos region, RandomSource random, Direction facing, PlacementSettings settings) {
        if (pool == null) {
            return EmptyTemplate.INSTANCE;
        }
        TemplateEntry entry = pool.getRandomFlat(version, random).orElse(null);
        if (entry == null) {
            return EmptyTemplate.INSTANCE;
        }
        Mirror mirror = random.nextBoolean() ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rotation = switch (facing) {
            case Direction.NORTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.WEST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.NONE;
            default -> throw new UnsupportedOperationException("Cannot place start facing " + String.valueOf(facing));
        };
        BlockPos offset = new BlockPos(13, 0, 26);
        BlockPos pos = region.toBlockPos().m_6630_(22);
        settings.addProcessors(new Processor[]{TileProcessor.translate((Vec3i)offset), TileProcessor.mirror(mirror, 23, 23, true), TileProcessor.rotate(rotation, 23, 23, true), TileProcessor.translate((Vec3i)pos), EntityProcessor.translate((Vec3i)offset), EntityProcessor.mirror(mirror, 23, 23, true), EntityProcessor.rotate(rotation, 23, 23, true), EntityProcessor.translate((Vec3i)pos)});
        return JigsawTemplate.of(version, entry, 10, random);
    }

    public Template getRoom(TemplatePool pool, Vault vault, Version version, RegionPos region, RandomSource random, PlacementSettings settings) {
        if (pool == null) {
            return EmptyTemplate.INSTANCE;
        }
        TemplateEntry entry = pool.getRandomFlat(version, random).orElse(null);
        int level = vault.get(Vault.LEVEL).get();
        for (int attempts = 0; entry != null && !ModConfigs.ROOM_LEVEL_LOCK.isAllowed(entry.getTemplate().getId(), level) && attempts < 10; ++attempts) {
            entry = pool.getRandomFlat(version, random).orElse(null);
        }
        if (entry == null) {
            return EmptyTemplate.INSTANCE;
        }
        Mirror mirror = random.nextBoolean() ? Mirror.NONE : Mirror.FRONT_BACK;
        Rotation rotation = (new Rotation[]{Rotation.NONE, Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_180})[random.nextInt(4)];
        BlockPos pos = region.toBlockPos().m_6630_(region.getSizeX() > 47 ? 0 : 9);
        int offsetX = region.getSizeX() / 2;
        int offsetZ = region.getSizeZ() / 2;
        settings.addProcessors(new Processor[]{TileProcessor.mirror(mirror, offsetX, offsetZ, true), TileProcessor.rotate(rotation, offsetX, offsetZ, true), TileProcessor.translate((Vec3i)pos), EntityProcessor.mirror(mirror, offsetX, offsetZ, true), EntityProcessor.rotate(rotation, offsetX, offsetZ, true), EntityProcessor.translate((Vec3i)pos)});
        return JigsawTemplate.of(version, entry, 10, random);
    }

    public Template getTunnel(TemplatePool pool, Version version, RegionPos region, RandomSource random, Direction.Axis axis, PlacementSettings settings) {
        Rotation rotation;
        if (pool == null) {
            return EmptyTemplate.INSTANCE;
        }
        TemplateEntry entry = pool.getRandomFlat(version, random).orElse(null);
        if (entry == null) {
            return EmptyTemplate.INSTANCE;
        }
        int index = random.nextInt(4);
        Mirror mirror = (new Mirror[]{Mirror.NONE, Mirror.FRONT_BACK, Mirror.LEFT_RIGHT, Mirror.NONE})[index];
        Rotation rotation2 = rotation = index == 3 ? Rotation.CLOCKWISE_180 : Rotation.NONE;
        if (axis == Direction.Axis.X) {
            rotation = rotation.m_55952_(Rotation.CLOCKWISE_90);
        }
        BlockPos offset = new BlockPos(18, 0, 0);
        BlockPos pos = region.toBlockPos().m_6630_(27);
        settings.addProcessors(new Processor[]{TileProcessor.translate((Vec3i)offset), TileProcessor.mirror(mirror, 23, 23, true), TileProcessor.rotate(rotation, 23, 23, true), TileProcessor.translate((Vec3i)pos), EntityProcessor.translate((Vec3i)offset), EntityProcessor.mirror(mirror, 23, 23, true), EntityProcessor.rotate(rotation, 23, 23, true), EntityProcessor.translate((Vec3i)pos)});
        return JigsawTemplate.of(version, entry, 10, random);
    }

    @Override
    public Iterator<VaultLayout.LayoutEntry> expandingIterator(Vault vault, int maxDistance) {
        if (maxDistance < 0) {
            return Collections.emptyIterator();
        }
        VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (!(generator instanceof GridGenerator)) {
            return Collections.emptyIterator();
        }
        GridGenerator gridGenerator = (GridGenerator)generator;
        int cellWidthX = gridGenerator.get(GridGenerator.CELL_X);
        int cellWidthZ = gridGenerator.get(GridGenerator.CELL_Z);
        return new LayoutIterator(vault, maxDistance, cellWidthX, cellWidthZ);
    }

    public class LayoutIterator
    implements Iterator<VaultLayout.LayoutEntry> {
        private final Vault vault;
        private final int maxLayer;
        private final int cellWidthX;
        private final int cellWidthZ;
        private Deque<VaultLayout.LayoutEntry> collectedEntries = new ArrayDeque<VaultLayout.LayoutEntry>(1);
        private int layer = 0;

        public LayoutIterator(Vault vault, int maxCellDistance, int cellWidthX, int cellWidthZ) {
            this.vault = vault;
            this.maxLayer = maxCellDistance;
            this.cellWidthX = cellWidthX;
            this.cellWidthZ = cellWidthZ;
            this.appendEntry(0, 0);
        }

        @Override
        public boolean hasNext() {
            return !this.collectedEntries.isEmpty() || this.layer < this.maxLayer;
        }

        @Override
        public VaultLayout.LayoutEntry next() {
            if (!this.collectedEntries.isEmpty()) {
                return this.collectedEntries.poll();
            }
            if (this.layer >= this.maxLayer) {
                throw new NoSuchElementException();
            }
            ++this.layer;
            this.populateLayer();
            return this.next();
        }

        private void populateLayer() {
            this.collectedEntries = new ArrayDeque<VaultLayout.LayoutEntry>(this.layer * 8);
            int minX = -this.layer;
            int minZ = -this.layer;
            int maxX = this.layer;
            int maxZ = this.layer;
            for (int x = minX; x <= maxX; ++x) {
                this.appendEntry(x, minZ);
                this.appendEntry(x, maxZ);
            }
            for (int z = minZ + 1; z <= maxZ - 1; ++z) {
                this.appendEntry(minX, z);
                this.appendEntry(maxX, z);
            }
        }

        private void appendEntry(int cellX, int cellZ) {
            RegionPos region = RegionPos.of(cellX, cellZ, this.cellWidthX, this.cellWidthZ);
            ChunkRandom rand = ChunkRandom.any();
            rand.setRegionSeed(this.vault.get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
            PlacementSettings settings = new PlacementSettings(new ProcessorContext(this.vault, rand)).setFlags(272);
            VaultLayout.PieceType type = VaultGridLayout.this.getType(this.vault, region);
            Template tpl = VaultGridLayout.this.getAt(this.vault, region, rand, settings);
            this.collectedEntries.add(new VaultLayout.LayoutEntry(type, tpl));
        }
    }
}

