/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.layout;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.template.Template;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;

public interface VaultLayout {
    public Iterator<LayoutEntry> expandingIterator(Vault var1, int var2);

    public static enum PieceType {
        NONE,
        START,
        START_NORTH,
        START_SOUTH,
        START_WEST,
        START_EAST,
        ROOM,
        TUNNEL_X,
        TUNNEL_Z;


        public boolean isStart() {
            return this == START || this == START_NORTH || this == START_SOUTH || this == START_WEST || this == START_EAST;
        }

        public boolean isTunnel() {
            return this == TUNNEL_X || this == TUNNEL_Z;
        }

        public boolean connectsToTunnel() {
            return this.isStart() || this == ROOM;
        }

        public PieceType rotate(Rotation rotation) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> NONE;
                case START -> START;
                case START_NORTH -> PieceType.ofStart(rotation.m_55954_(Direction.NORTH));
                case START_SOUTH -> PieceType.ofStart(rotation.m_55954_(Direction.SOUTH));
                case START_WEST -> PieceType.ofStart(rotation.m_55954_(Direction.WEST));
                case START_EAST -> PieceType.ofStart(rotation.m_55954_(Direction.EAST));
                case ROOM -> ROOM;
                case TUNNEL_X -> PieceType.ofTunnel(rotation.m_55954_(Direction.WEST));
                case TUNNEL_Z -> PieceType.ofTunnel(rotation.m_55954_(Direction.NORTH));
            };
        }

        public static PieceType ofStart(Direction facing) {
            return switch (facing) {
                case Direction.NORTH -> START_NORTH;
                case Direction.SOUTH -> START_SOUTH;
                case Direction.WEST -> START_WEST;
                case Direction.EAST -> START_EAST;
                default -> throw new UnsupportedOperationException("Start cannot face " + String.valueOf(facing));
            };
        }

        public static PieceType ofTunnel(Direction direction) {
            return PieceType.ofTunnel(direction.m_122434_());
        }

        public static PieceType ofTunnel(Direction.Axis axis) {
            return switch (axis) {
                case Direction.Axis.X -> TUNNEL_X;
                case Direction.Axis.Z -> TUNNEL_Z;
                default -> throw new UnsupportedOperationException("Tunnel cannot be aligned on " + String.valueOf(axis));
            };
        }
    }

    public record LayoutEntry(PieceType type, Template template) {
    }
}

