/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.generator.theme;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import iskallia.vault.config.adapter.ThemeAdapter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public abstract class Theme {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory(ThemeAdapter.FACTORY).setPrettyPrinting().create();
    protected String path;
    protected float ambientLight;
    protected int fogColor;
    protected int grassColor;
    protected int foliageColor;
    protected int waterColor;
    protected int waterFogColor;
    protected String particle;
    protected float particleProbability;
    protected int time;
    protected ResourceLocation effects;
    protected List<AmbientSound> ambientSounds;

    public Theme(float ambientLight, int fogColor, int grassColor, int foliageColor, int waterColor, int waterFogColor, String particle, float particleProbability, int time, ResourceLocation effects, List<AmbientSound> ambientSounds) {
        this.ambientLight = ambientLight;
        this.fogColor = fogColor;
        this.grassColor = grassColor;
        this.foliageColor = foliageColor;
        this.waterColor = waterColor;
        this.waterFogColor = waterFogColor;
        this.particle = particle;
        this.particleProbability = particleProbability;
        this.time = time;
        this.effects = effects;
        this.ambientSounds = ambientSounds == null ? Collections.emptyList() : List.copyOf(ambientSounds);
    }

    public float getAmbientLight() {
        return this.ambientLight;
    }

    public int getFogColor() {
        return this.fogColor;
    }

    public int getGrassColor() {
        return this.grassColor;
    }

    public int getFoliageColor() {
        return this.foliageColor;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public int getWaterFogColor() {
        return this.waterFogColor;
    }

    public String getParticle() {
        return this.particle;
    }

    public float getParticleProbability() {
        return this.particleProbability;
    }

    public int getTime() {
        return this.time;
    }

    public ResourceLocation getEffects() {
        return this.effects;
    }

    public List<AmbientSound> getAmbientSounds() {
        return this.ambientSounds;
    }

    public static Theme fromPath(String path) {
        Theme theme;
        try {
            theme = (Theme)GSON.fromJson((Reader)new FileReader(path), Theme.class);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        theme.path = path;
        return theme;
    }

    public String getPath() {
        return this.path;
    }

    public record AmbientSound(ResourceLocation sound, int minRate, int maxRate) {
        public AmbientSound(ResourceLocation sound, int minRate, int maxRate) {
            this.sound = sound;
            this.minRate = Math.max(0, minRate);
            this.maxRate = Math.max(this.minRate, maxRate);
        }
    }
}

