/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.world.loot.LootPool;
import iskallia.vault.core.world.roll.IntRoll;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class LootTable
implements ISerializable<CompoundTag, JsonObject> {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(LootTable.class, Adapters.LOOT_TABLE).setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    protected List<Entry> entries = new ArrayList<Entry>();
    protected String path;

    public LootTable() {
    }

    public LootTable(List<Entry> entries) {
        this.entries = entries;
    }

    public static LootTable fromPath(String path) {
        LootTable lootTable;
        try {
            lootTable = (LootTable)GSON.fromJson((Reader)new FileReader(path), LootTable.class);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        lootTable.path = path;
        return lootTable;
    }

    public String getPath() {
        return this.path;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public LootTable add(IntRoll roll, LootPool pool) {
        this.entries.add(new Entry(roll, pool));
        return this;
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (Entry entry : this.entries) {
            entry.writeNbt().ifPresent(arg_0 -> list.add(arg_0));
        }
        nbt.m_128365_("entries", (Tag)list);
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.entries.clear();
        for (Tag tag : nbt.m_128437_("entries", 10)) {
            Entry entry = new Entry();
            entry.readNbt((CompoundTag)tag);
            this.entries.add(entry);
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        JsonArray list = new JsonArray();
        for (Entry entry : this.entries) {
            entry.writeJson().ifPresent(arg_0 -> ((JsonArray)list).add(arg_0));
        }
        json.add("entries", (JsonElement)list);
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.entries.clear();
        for (JsonElement element : json.get("entries").getAsJsonArray()) {
            Entry entry = new Entry();
            entry.readJson(element.getAsJsonObject());
            this.entries.add(entry);
        }
    }

    public static class Entry
    implements ISerializable<CompoundTag, JsonObject> {
        protected IntRoll roll;
        protected LootPool pool;

        public Entry() {
        }

        public Entry(IntRoll roll, LootPool pool) {
            this.roll = roll;
            this.pool = pool;
        }

        public IntRoll getRoll() {
            return this.roll;
        }

        public LootPool getPool() {
            return this.pool;
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT_ROLL.writeNbt(this.roll).ifPresent(roll -> nbt.m_128365_("roll", roll));
            Adapters.LOOT_POOL.writeNbt(this.pool).ifPresent(pool -> nbt.m_128365_("pool", (Tag)pool));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.roll = Adapters.INT_ROLL.readNbt(nbt.m_128423_("roll")).orElse(IntRoll.ofConstant(1));
            this.pool = Adapters.LOOT_POOL.readNbt((ListTag)nbt.m_128423_("pool")).orElse(new LootPool());
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT_ROLL.writeJson(this.roll).ifPresent(roll -> json.add("roll", roll));
            Adapters.LOOT_POOL.writeJson(this.pool).ifPresent(pool -> json.add("pool", (JsonElement)pool));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            this.roll = Adapters.INT_ROLL.readJson(json.get("roll")).orElse(IntRoll.ofConstant(1));
            this.pool = Adapters.LOOT_POOL.readJson(json.getAsJsonArray("pool")).orElse(new LootPool());
        }
    }
}

