/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.loot.entry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.VaultMod;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.loot.entry.LootEntry;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemLootEntry
implements LootEntry {
    protected Item item;
    protected CompoundTag nbt;
    protected IntRoll count;

    public ItemLootEntry() {
        this(Items.f_41852_, null, IntRoll.ofConstant(1));
    }

    public ItemLootEntry(Item item, CompoundTag nbt, IntRoll count) {
        this.item = item;
        this.nbt = nbt;
        this.count = count;
    }

    public ItemLootEntry(Tag nbt) {
        this();
        this.readNbt(nbt);
    }

    public Item getItem() {
        return this.item;
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public IntRoll getCount() {
        return this.count;
    }

    @Override
    public List<ItemStack> getStack(RandomSource random) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int count = this.count.get(random);
        ItemStack stack = new ItemStack((ItemLike)this.item);
        if (this.nbt != null) {
            stack.m_41751_(this.nbt.m_6426_());
        }
        for (int i = 0; i < count; i += stack.m_41741_()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(Math.min(count - i, stack.m_41741_()));
            items.add(copy);
        }
        return items;
    }

    @Override
    public OverSizedItemStack getOverStack(RandomSource random) {
        int count = this.count.get(random);
        ItemStack stack = new ItemStack((ItemLike)this.item);
        stack.m_41764_(count);
        if (this.nbt != null) {
            stack.m_41751_(this.nbt.m_6426_());
        }
        return OverSizedItemStack.of(stack).copyAmount(count);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.ITEM.asNullable().writeBits(this.item, buffer);
        Adapters.COMPOUND_NBT.asNullable().writeBits(this.nbt, buffer);
        Adapters.INT_ROLL.writeBits(this.count, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.item = Adapters.ITEM.asNullable().readBits(buffer).orElse(null);
        this.nbt = Adapters.COMPOUND_NBT.asNullable().readBits(buffer).orElse(null);
        this.count = Adapters.INT_ROLL.readBits(buffer).orElse(null);
    }

    @Override
    public Optional<Tag> writeNbt() {
        IntRoll.Constant constant;
        IntRoll intRoll;
        if (this.nbt == null && (intRoll = this.count) instanceof IntRoll.Constant && (constant = (IntRoll.Constant)intRoll).getCount() == 1) {
            return Adapters.ITEM.writeNbt(this.item);
        }
        CompoundTag nbt = new CompoundTag();
        Adapters.ITEM.writeNbt(this.item).ifPresent(element -> nbt.m_128365_("id", element));
        Adapters.COMPOUND_NBT.writeNbt(this.nbt).ifPresent(element -> nbt.m_128365_("nbt", element));
        Adapters.INT_ROLL.writeNbt(this.count).ifPresent(element -> nbt.m_128365_("count", element));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(Tag nbt) {
        if (nbt instanceof StringTag) {
            StringTag primitive = (StringTag)nbt;
            Adapters.ITEM.readNbt((Tag)primitive).ifPresentOrElse(value -> {
                this.item = value;
            }, () -> {
                VaultMod.LOGGER.error("Unknown item " + String.valueOf(primitive));
                this.item = ModItems.ERROR_ITEM;
                if (this.nbt == null) {
                    this.nbt = new CompoundTag();
                }
                this.nbt.m_128359_("id", primitive.m_7916_());
            });
        } else if (nbt instanceof CompoundTag) {
            CompoundTag object = (CompoundTag)nbt;
            Adapters.COMPOUND_NBT.readNbt(object.m_128423_("nbt")).ifPresent(value -> {
                this.nbt = value;
            });
            Adapters.ITEM.readNbt(object.m_128423_("id")).ifPresentOrElse(value -> {
                this.item = value;
            }, () -> {
                VaultMod.LOGGER.error("Unknown item " + String.valueOf(object.m_128423_("id")));
                this.item = ModItems.ERROR_ITEM;
                if (this.nbt == null) {
                    this.nbt = new CompoundTag();
                }
                if (object.m_128441_("id")) {
                    this.nbt.m_128365_("id", object.m_128423_("id"));
                }
            });
            Adapters.INT_ROLL.readNbt(object.m_128423_("count")).ifPresent(count -> {
                this.count = count;
            });
        } else {
            throw new UnsupportedOperationException(String.valueOf(nbt) + " cannot be read as an ItemLootEntry");
        }
    }

    @Override
    public Optional<JsonElement> writeJson() {
        IntRoll.Constant constant;
        IntRoll intRoll;
        if (this.nbt == null && (intRoll = this.count) instanceof IntRoll.Constant && (constant = (IntRoll.Constant)intRoll).getCount() == 1) {
            return Adapters.ITEM.writeJson(this.item);
        }
        JsonObject json = new JsonObject();
        Adapters.ITEM.writeJson(this.item).ifPresent(element -> json.add("id", element));
        Adapters.COMPOUND_NBT.writeJson(this.nbt).ifPresent(element -> json.add("nbt", element));
        Adapters.INT_ROLL.writeJson(this.count).ifPresent(element -> json.add("count", element));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            Adapters.ITEM.readJson((JsonElement)primitive).ifPresentOrElse(value -> {
                this.item = value;
            }, () -> {
                VaultMod.LOGGER.error("Unknown item " + String.valueOf(primitive));
                this.item = ModItems.ERROR_ITEM;
                if (this.nbt == null) {
                    this.nbt = new CompoundTag();
                }
                this.nbt.m_128359_("id", primitive.getAsString());
            });
        } else if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            Adapters.COMPOUND_NBT.readJson(object.get("nbt")).ifPresent(value -> {
                this.nbt = value;
            });
            Adapters.ITEM.readJson(object.get("id")).ifPresentOrElse(value -> {
                this.item = value;
            }, () -> {
                VaultMod.LOGGER.error("Unknown item " + String.valueOf(object.get("id")));
                this.item = ModItems.ERROR_ITEM;
                if (this.nbt == null) {
                    this.nbt = new CompoundTag();
                }
                this.nbt.m_128359_("id", object.get("id").getAsString());
            });
            Adapters.INT_ROLL.readJson(object.get("count")).ifPresent(count -> {
                this.count = count;
            });
        } else {
            throw new UnsupportedOperationException(String.valueOf(json) + " cannot be read as an ItemLootEntry");
        }
    }

    @Override
    public LootEntry flatten(Version version, RandomSource random) {
        return this;
    }

    @Override
    public boolean validate() {
        return true;
    }
}

