/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor;

import iskallia.vault.core.Version;
import iskallia.vault.core.util.IndexedValue;
import iskallia.vault.core.world.data.IndexedBlock;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.OrTilePredicate;
import iskallia.vault.core.world.data.tile.PartialBlock;
import iskallia.vault.core.world.data.tile.PartialBlockGroup;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialBlockTag;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.BernoulliWeightedTileProcessor;
import iskallia.vault.core.world.processor.tile.JigsawTileProcessor;
import iskallia.vault.core.world.processor.tile.LeveledTileProcessor;
import iskallia.vault.core.world.processor.tile.MirrorTileProcessor;
import iskallia.vault.core.world.processor.tile.ReferenceTileProcessor;
import iskallia.vault.core.world.processor.tile.RotateTileProcessor;
import iskallia.vault.core.world.processor.tile.SpawnerElementTileProcessor;
import iskallia.vault.core.world.processor.tile.StructureVoidTileProcessor;
import iskallia.vault.core.world.processor.tile.TargetTileProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.processor.tile.TransformTileProcessor;
import iskallia.vault.core.world.processor.tile.TranslateTileProcessor;
import iskallia.vault.core.world.processor.tile.VaultLootTileProcessor;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class TileMapper {
    private final List<IndexedValue<TileProcessor>> universalProcessor = new ArrayList<IndexedValue<TileProcessor>>();
    private TransformTileProcessor transformProcessor = TransformTileProcessor.identity();
    private int headIndex = 0;
    private int tailIndex = 0;
    private final List<IndexedValue<TileProcessor>>[][] conditionalProcessorsTiered = new List[(FixatedBlockIDs.BLOCKS.m_183450_() >>> 8) + 1][];

    public PartialTile mapBlock(PartialTile tile, ProcessorContext context) {
        return this.mapBlock(tile, context, Integer.MIN_VALUE);
    }

    public PartialTile mapBlock(PartialTile initialTile, ProcessorContext context, int startIndex) {
        PartialTile currentTile;
        if (initialTile == null) {
            return null;
        }
        PartialTile partialTile = currentTile = startIndex == Integer.MIN_VALUE ? this.transformProcessor.process(initialTile, context) : initialTile;
        if (currentTile == null) {
            return null;
        }
        int originalBlockId = currentTile.getState().getBlock().getRegistryIndex();
        if (originalBlockId < 0) {
            return this.runUnconditional(currentTile, context, startIndex, originalBlockId);
        }
        List<IndexedValue<TileProcessor>> conditionalBlock = this.getConditionalList(originalBlockId);
        List<IndexedValue<TileProcessor>> universalList = this.universalProcessor;
        int universalPointer = this.findStartIndex(universalList, startIndex);
        int conditionalPointer = this.findStartIndex(conditionalBlock, startIndex);
        while (universalPointer < universalList.size() && conditionalPointer < conditionalBlock.size()) {
            IndexedValue<TileProcessor> nextEntry = universalList.get((int)universalPointer).index < conditionalBlock.get((int)conditionalPointer).index ? universalList.get(universalPointer++) : conditionalBlock.get(conditionalPointer++);
            if ((currentTile = ((TileProcessor)nextEntry.value).process(currentTile, context)) == null) {
                return null;
            }
            int updatedBlockID = currentTile.getState().getBlock().getRegistryIndex();
            if (updatedBlockID == originalBlockId) continue;
            return this.mapBlock(currentTile, context, nextEntry.index);
        }
        if (this.finishProcessingList(conditionalBlock, conditionalPointer, originalBlockId, currentTile, context)) {
            return null;
        }
        if (this.finishProcessingList(universalList, universalPointer, originalBlockId, currentTile, context)) {
            return null;
        }
        return currentTile;
    }

    public void addProcessor(TileProcessor processor) {
        this.addProcessor(processor, false);
    }

    public void addProcessorAtBeginning(TileProcessor processor) {
        this.addProcessor(processor, true);
    }

    public void addProcessor(TileProcessor processor, boolean pushFront) {
        if (processor == null) {
            return;
        }
        if (processor instanceof TranslateTileProcessor) {
            TranslateTileProcessor t = (TranslateTileProcessor)processor;
            this.mergeTransform(TransformTileProcessor.from(t), pushFront);
            return;
        }
        if (processor instanceof MirrorTileProcessor) {
            MirrorTileProcessor m = (MirrorTileProcessor)processor;
            this.mergeTransform(TransformTileProcessor.from(m), pushFront);
            return;
        }
        if (processor instanceof RotateTileProcessor) {
            RotateTileProcessor r = (RotateTileProcessor)processor;
            this.mergeTransform(TransformTileProcessor.from(r), pushFront);
            return;
        }
        try {
            if (processor instanceof BernoulliWeightedTileProcessor) {
                BernoulliWeightedTileProcessor bw = (BernoulliWeightedTileProcessor)processor;
                this.addProcessor(bw.target, processor, pushFront);
            } else if (processor instanceof VaultLootTileProcessor) {
                this.addProcessor(PartialBlock.of(ModBlocks.PLACEHOLDER), processor, pushFront);
            } else if (processor instanceof SpawnerElementTileProcessor) {
                this.addProcessor(PartialBlock.of((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ispawner", "spawner"))), processor, pushFront);
            } else if (processor instanceof JigsawTileProcessor) {
                this.addProcessor(PartialBlock.of(Blocks.f_50678_), processor, pushFront);
            } else if (processor instanceof StructureVoidTileProcessor) {
                this.addProcessor(PartialBlock.of(Blocks.f_50454_), processor, pushFront);
            } else if (processor instanceof TargetTileProcessor) {
                TargetTileProcessor tp = (TargetTileProcessor)processor;
                this.addProcessor(tp.getPredicate(), processor, pushFront);
            } else if (processor instanceof LeveledTileProcessor) {
                LeveledTileProcessor lv = (LeveledTileProcessor)processor;
                this.addProcessor(new LeveledPredicate(lv), processor, pushFront);
            } else if (processor instanceof ReferenceTileProcessor) {
                ReferenceTileProcessor ref = (ReferenceTileProcessor)processor;
                this.flattenReference(ref, pushFront);
            } else {
                this.addUniversalProcessor(processor, pushFront);
            }
        }
        catch (UnconditionalPredicate error) {
            this.addUniversalProcessor(processor, pushFront);
        }
    }

    private List<IndexedValue<TileProcessor>> getConditionalList(int blockID) {
        int high = blockID >>> 8;
        int low = blockID & 0xFF;
        if (high >= this.conditionalProcessorsTiered.length) {
            return List.of();
        }
        List<IndexedValue<TileProcessor>>[] bucket = this.conditionalProcessorsTiered[high];
        return bucket == null ? List.of() : bucket[low];
    }

    private int findStartIndex(List<IndexedValue<TileProcessor>> list, int index) {
        int i;
        for (i = 0; i < list.size() && list.get((int)i).index < index; ++i) {
        }
        return i;
    }

    private boolean finishProcessingList(List<IndexedValue<TileProcessor>> list, int from, int id, PartialTile currentTile, ProcessorContext context) {
        for (int i = from; i < list.size(); ++i) {
            if ((currentTile = ((TileProcessor)list.get((int)i).value).process(currentTile, context)) == null) {
                return true;
            }
            int updatedBlockID = currentTile.getState().getBlock().getRegistryIndex();
            if (updatedBlockID == id) continue;
            return this.mapBlock(currentTile, context, list.get((int)i).index) == null;
        }
        return false;
    }

    private void mergeTransform(TransformTileProcessor otherTransform, boolean pushFront) {
        this.transformProcessor = pushFront ? TransformTileProcessor.merge(otherTransform, this.transformProcessor) : TransformTileProcessor.merge(this.transformProcessor, otherTransform);
    }

    private void flattenReference(ReferenceTileProcessor reference, boolean pushFront) {
        if (reference.getPool().size() == 0) {
            return;
        }
        if (reference.getPool().size() == 1) {
            List<TileProcessor> list = reference.getCachedPaletteForVersion(Version.latest()).getTileProcessors();
            (pushFront ? TileMapper.reverseList(list) : list).forEach(tp -> this.addProcessor((TileProcessor)tp, pushFront));
        } else {
            this.addUniversalProcessor(reference, pushFront);
        }
    }

    private void addUniversalProcessor(TileProcessor p, boolean pushFront) {
        if (pushFront) {
            this.universalProcessor.add(0, new IndexedValue<TileProcessor>(--this.headIndex, p));
        } else {
            this.universalProcessor.add(new IndexedValue<TileProcessor>(this.tailIndex++, p));
        }
    }

    private void addProcessor(TilePredicate predicate, TileProcessor processor, boolean pushFront) throws UnconditionalPredicate {
        int[] blockIds = TileMapper.getPredicateIndices(predicate).distinct().toArray();
        if (Arrays.stream(blockIds).anyMatch(i -> i < 0)) {
            this.addUniversalProcessor(processor, pushFront);
            return;
        }
        for (int id : blockIds) {
            List<IndexedValue<TileProcessor>>[] bucket;
            int high = id >>> 8;
            int low = id & 0xFF;
            if (high >= this.conditionalProcessorsTiered.length || (bucket = this.getOrCreateTier(high)).length == 0) continue;
            List<IndexedValue<TileProcessor>> list = bucket[low];
            if (pushFront) {
                list.add(0, new IndexedValue<TileProcessor>(--this.headIndex, processor));
                continue;
            }
            list.add(new IndexedValue<TileProcessor>(this.tailIndex++, processor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IndexedValue<TileProcessor>>[] getOrCreateTier(int high) {
        if (high >= this.conditionalProcessorsTiered.length) {
            return new List[0];
        }
        List<IndexedValue<TileProcessor>>[] bucket = this.conditionalProcessorsTiered[high];
        if (bucket == null) {
            TileMapper tileMapper = this;
            synchronized (tileMapper) {
                bucket = this.conditionalProcessorsTiered[high];
                if (bucket == null) {
                    bucket = new List[256];
                    for (int i = 0; i < 256; ++i) {
                        bucket[i] = new ArrayList<IndexedValue<TileProcessor>>();
                    }
                    this.conditionalProcessorsTiered[high] = bucket;
                }
            }
        }
        return bucket;
    }

    private static <T> Iterable<T> reverseList(final List<T> list) {
        return () -> new Iterator<T>(){
            int i;
            {
                this.i = list.size();
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public T next() {
                return list.get(--this.i);
            }
        };
    }

    private static IntStream getPredicateIndices(TilePredicate predicate) throws UnconditionalPredicate {
        if (predicate instanceof PartialBlockTag) {
            PartialBlockTag tag = (PartialBlockTag)predicate;
            TagKey key = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tag.getId());
            return StreamSupport.stream(ForgeRegistries.BLOCKS.tags().getTag(key).spliterator(), false).mapToInt(b -> ((IndexedBlock)b).getRegistryIndex());
        }
        if (predicate instanceof PartialBlockGroup) {
            PartialBlockGroup group = (PartialBlockGroup)predicate;
            Set<TilePredicate> seq = ModConfigs.TILE_GROUPS.getGroups().get(group.getId());
            return seq == null ? IntStream.empty() : seq.stream().flatMapToInt(TileMapper::getPredicateIndices);
        }
        if (predicate instanceof PartialTile) {
            PartialTile tile = (PartialTile)predicate;
            return IntStream.of(tile.getState().getBlock().getRegistryIndex());
        }
        if (predicate instanceof PartialBlockState) {
            PartialBlockState state = (PartialBlockState)predicate;
            return IntStream.of(state.getBlock().getRegistryIndex());
        }
        if (predicate instanceof PartialBlock) {
            PartialBlock block = (PartialBlock)predicate;
            return IntStream.of(block.getRegistryIndex());
        }
        if (predicate instanceof OrTilePredicate) {
            OrTilePredicate or = (OrTilePredicate)predicate;
            return Arrays.stream(or.getChildren()).flatMapToInt(TileMapper::getPredicateIndices);
        }
        if (predicate instanceof LeveledPredicate) {
            LeveledPredicate leveled = (LeveledPredicate)predicate;
            return leveled.processor.getLevels().values().stream().flatMapToInt(tp -> {
                if (tp instanceof TargetTileProcessor) {
                    TargetTileProcessor tgt = (TargetTileProcessor)tp;
                    return TileMapper.getPredicateIndices(tgt.getPredicate());
                }
                if (tp instanceof BernoulliWeightedTileProcessor) {
                    BernoulliWeightedTileProcessor bw = (BernoulliWeightedTileProcessor)tp;
                    return TileMapper.getPredicateIndices(bw.target);
                }
                if (tp instanceof VaultLootTileProcessor) {
                    return IntStream.of(((IndexedBlock)((Object)ModBlocks.PLACEHOLDER)).getRegistryIndex());
                }
                if (tp instanceof LeveledTileProcessor) {
                    LeveledTileProcessor lvl = (LeveledTileProcessor)tp;
                    return TileMapper.getPredicateIndices(new LeveledPredicate(lvl));
                }
                throw new UnconditionalPredicate();
            });
        }
        throw new UnconditionalPredicate();
    }

    private PartialTile runUnconditional(PartialTile tile, ProcessorContext context, int startIndex, int sentinel) {
        for (int i = this.findStartIndex(this.universalProcessor, startIndex); i < this.universalProcessor.size(); ++i) {
            if ((tile = ((TileProcessor)this.universalProcessor.get((int)i).value).process(tile, context)) == null) {
                return null;
            }
            int newId = tile.getState().getBlock().getRegistryIndex();
            if (newId == sentinel) continue;
            return this.mapBlock(tile, context, this.universalProcessor.get((int)i).index);
        }
        return tile;
    }

    static final class FixatedBlockIDs {
        static final IdMapper<Block> BLOCKS;

        private FixatedBlockIDs() {
        }

        static {
            IForgeRegistry registry = ForgeRegistries.BLOCKS;
            BLOCKS = new IdMapper(registry.getValues().size());
            AtomicInteger ai = new AtomicInteger();
            registry.forEach(b -> BLOCKS.m_122664_(b, ai.getAndIncrement()));
        }
    }

    private static final class LeveledPredicate
    implements TilePredicate {
        private final LeveledTileProcessor processor;

        private LeveledPredicate(LeveledTileProcessor processor) {
            this.processor = processor;
        }

        @Override
        public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
            return true;
        }
    }

    private static final class UnconditionalPredicate
    extends RuntimeException {
        private UnconditionalPredicate() {
        }
    }
}

