/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.entity;

import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.processor.entity.BoundedEntityProcessor;
import iskallia.vault.core.world.processor.entity.MirrorEntityProcessor;
import iskallia.vault.core.world.processor.entity.RotateEntityProcessor;
import iskallia.vault.core.world.processor.entity.TranslateEntityProcessor;
import iskallia.vault.core.world.processor.entity.WeightedEntityProcessor;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public abstract class EntityProcessor
implements Processor<PartialEntity> {
    public static WeightedEntityProcessor ofWeighted() {
        return new WeightedEntityProcessor();
    }

    public static MirrorEntityProcessor mirror(Mirror mirror, int plane, boolean centered) {
        return new MirrorEntityProcessor(mirror, plane, centered);
    }

    public static MirrorEntityProcessor mirror(Mirror mirror, int planeX, int planeZ, boolean centered) {
        int plane = switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.FRONT_BACK -> planeX;
            case Mirror.LEFT_RIGHT -> planeZ;
            case Mirror.NONE -> 0;
        };
        return EntityProcessor.mirror(mirror, plane, centered);
    }

    public static MirrorEntityProcessor mirror(Mirror mirror, Vec3i planes, boolean centered) {
        return EntityProcessor.mirror(mirror, planes.m_123341_(), planes.m_123343_(), centered);
    }

    public static MirrorEntityProcessor mirrorRandomly(RandomSource random, int plane, boolean centered) {
        Mirror mirror = Mirror.values()[random.nextInt(Mirror.values().length)];
        return EntityProcessor.mirror(mirror, plane, centered);
    }

    public static MirrorEntityProcessor mirrorRandomly(RandomSource random, int planeX, int planeZ, boolean centered) {
        Mirror mirror = Mirror.values()[random.nextInt(Mirror.values().length)];
        return EntityProcessor.mirror(mirror, planeX, planeZ, centered);
    }

    public static MirrorEntityProcessor mirrorRandomly(RandomSource random, Vec3i planes, boolean centered) {
        return EntityProcessor.mirrorRandomly(random, planes.m_123341_(), planes.m_123343_(), centered);
    }

    public static RotateEntityProcessor rotate(Rotation rotation, int pivotX, int pivotZ, boolean centered) {
        return new RotateEntityProcessor(rotation, pivotX, pivotZ, centered);
    }

    public static RotateEntityProcessor rotate(Rotation rotation, Vec3i pivot, boolean centered) {
        return EntityProcessor.rotate(rotation, pivot.m_123341_(), pivot.m_123343_(), centered);
    }

    public static RotateEntityProcessor rotateRandomly(RandomSource random, int pivotX, int pivotZ, boolean centered) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        return EntityProcessor.rotate(rotation, pivotX, pivotZ, centered);
    }

    public static RotateEntityProcessor rotateRandomly(RandomSource random, Vec3i pivot, boolean centered) {
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        return EntityProcessor.rotate(rotation, pivot.m_123341_(), pivot.m_123343_(), centered);
    }

    public static TranslateEntityProcessor translate(int offsetX, int offsetY, int offsetZ) {
        return new TranslateEntityProcessor(offsetX, offsetY, offsetZ);
    }

    public static TranslateEntityProcessor translate(Vec3i offset) {
        return new TranslateEntityProcessor(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
    }

    public static BoundedEntityProcessor bound(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new BoundedEntityProcessor(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static BoundedEntityProcessor bound(BoundingBox box) {
        return EntityProcessor.bound(box.m_162395_(), box.m_162396_(), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_());
    }
}

