/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.init.ModConfigs;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LeveledTileProcessor
extends TileProcessor {
    public Map<Integer, TileProcessor> levels = new LinkedHashMap<Integer, TileProcessor>();
    private volatile TileProcessor[] levelTable;
    private int cachedLevel = -1;
    private WeakReference<Vault> cachedVault = new WeakReference<Object>(null);

    public Map<Integer, TileProcessor> getLevels() {
        return this.levels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TileProcessor[] getLevelTable() {
        TileProcessor[] table = this.levelTable;
        if (table == null) {
            LeveledTileProcessor leveledTileProcessor = this;
            synchronized (leveledTileProcessor) {
                table = this.levelTable;
                if (table == null) {
                    this.initLevelTable();
                    table = this.levelTable;
                }
            }
        }
        return table;
    }

    private void initLevelTable() {
        TreeMap<Integer, TileProcessor> sortedMap = new TreeMap<Integer, TileProcessor>(this.levels);
        TileProcessor[] table = new TileProcessor[ModConfigs.LEVELS_META.getMaxLevel() + 1];
        for (int i = 0; i < table.length; ++i) {
            NavigableMap<Integer, TileProcessor> headMap = sortedMap.headMap(i + 1, true);
            if (headMap.isEmpty()) continue;
            table[i] = (TileProcessor)headMap.get(headMap.lastKey());
        }
        this.levelTable = table;
    }

    private int getCachedLevel(ProcessorContext context) {
        if (this.cachedLevel >= 0 && context.getVault() != null && this.cachedVault.get() == context.getVault()) {
            return this.cachedLevel;
        }
        if (context.getVault() == null) {
            this.cachedLevel = -1;
        } else {
            this.cachedLevel = context.getVault().get(Vault.LEVEL).get();
            this.cachedVault = new WeakReference<Vault>(context.getVault());
        }
        return this.cachedLevel;
    }

    @Override
    public PartialTile process(PartialTile tile, ProcessorContext context) {
        TileProcessor processor;
        TileProcessor[] table;
        int level = this.getCachedLevel(context);
        if (level < 0) {
            level = 0;
        }
        if (level >= (table = this.getLevelTable()).length) {
            level = table.length - 1;
        }
        return (processor = table[level]) == null ? tile : processor.process(tile, context);
    }
}

