/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Mirror;

public class MirrorTileProcessor
extends TileProcessor {
    public final Mirror mirror;
    public final int plane;
    public final boolean centered;
    private final int term;

    public int getPlane() {
        return this.plane;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public MirrorTileProcessor(Mirror mirror, int plane, boolean centered) {
        this.mirror = mirror;
        this.plane = plane;
        this.centered = centered;
        this.term = this.plane + this.plane - (this.centered ? 0 : 1);
    }

    public BlockPos transform(BlockPos pos) {
        return switch (this.mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.FRONT_BACK -> new BlockPos(this.term - pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            case Mirror.LEFT_RIGHT -> new BlockPos(pos.m_123341_(), pos.m_123342_(), this.term - pos.m_123343_());
            case Mirror.NONE -> pos;
        };
    }

    @Override
    public PartialTile process(PartialTile tile, ProcessorContext context) {
        tile.setPos(this.transform(tile.getPos()));
        tile.getState().mirror(this.mirror);
        return tile;
    }
}

