/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.Version;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.CachedPaletteContainer;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import java.lang.ref.PhantomReference;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ReferenceTileProcessor
extends TileProcessor
implements CachedPaletteContainer {
    private final WeightedList<ResourceLocation> pool;
    private Palette cachedPalette;
    private Version cachedVersion;
    private PhantomReference<Vault> lastVault = new PhantomReference<Object>(null, null);

    public ReferenceTileProcessor(WeightedList<ResourceLocation> pool) {
        this.pool = pool;
    }

    public WeightedList<ResourceLocation> getPool() {
        return this.pool;
    }

    @Override
    public Palette getCachedPalette(ProcessorContext context) {
        Palette palette = this.cachedPalette;
        if (this.cachedVersion == null || this.cachedPalette == null || !this.lastVault.refersTo(context.getVault())) {
            Version version;
            this.lastVault = new PhantomReference<Vault>(context.getVault(), null);
            Version version2 = version = context.getVault() == null ? Version.latest() : context.getVault().get(Vault.VERSION);
            if (version != this.cachedVersion || palette == null) {
                this.cachedVersion = version;
                this.cachedPalette = palette = (Palette)VaultRegistry.PALETTE.getKey((ResourceLocation)this.pool.entrySet().toArray(new Map.Entry[0])[0].getKey()).get(version);
            }
        }
        return palette;
    }

    @Override
    public Palette getCachedPaletteForVersion(Version version) {
        if (this.cachedPalette == null) {
            this.cachedPalette = (Palette)VaultRegistry.PALETTE.getKey((ResourceLocation)this.pool.entrySet().toArray(new Map.Entry[0])[0].getKey()).get(version);
        }
        return this.cachedPalette;
    }

    @Override
    public PartialTile process(PartialTile value, ProcessorContext context) {
        TileProcessor child;
        if (this.pool.isEmpty()) {
            return value;
        }
        if (this.pool.size() == 1) {
            Palette palette = this.getCachedPalette(context);
            for (TileProcessor child2 : palette.getTileProcessors()) {
                value = child2.process(value, context);
                if (value != null) continue;
                return null;
            }
            return value;
        }
        Version version = context.getVault() == null ? Version.latest() : context.getVault().get(Vault.VERSION);
        ResourceLocation reference = this.pool.getRandom(context.getRandom(value.getPos())).orElse(null);
        Palette palette = (Palette)VaultRegistry.PALETTE.getKey(reference).get(version);
        Iterator<TileProcessor> iterator = palette.getTileProcessors().iterator();
        while (iterator.hasNext() && (value = (child = iterator.next()).process(value, context)) != null) {
        }
        return value;
    }
}

