/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Rotation;

public class RotateTileProcessor
extends TileProcessor {
    public final Rotation rotation;
    public final int pivotX;
    public final int pivotZ;
    public final boolean centered;
    private final int termX;
    private final int termZ;

    public Rotation getRotation() {
        return this.rotation;
    }

    public int getPivotX() {
        return this.pivotX;
    }

    public int getPivotZ() {
        return this.pivotZ;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public RotateTileProcessor(Rotation rotation, int pivotX, int pivotZ, boolean centered) {
        this.rotation = rotation;
        this.pivotX = pivotX;
        this.pivotZ = pivotZ;
        this.centered = centered;
        switch (this.rotation) {
            case COUNTERCLOCKWISE_90: {
                this.termX = this.pivotX - this.pivotZ - (this.centered ? 0 : 1);
                this.termZ = this.pivotX + this.pivotZ;
                break;
            }
            case CLOCKWISE_90: {
                this.termX = this.pivotX + this.pivotZ;
                this.termZ = this.pivotZ - this.pivotX - (this.centered ? 0 : 1);
                break;
            }
            case CLOCKWISE_180: {
                this.termX = this.pivotX + this.pivotX - (this.centered ? 0 : 1);
                this.termZ = this.pivotZ + this.pivotZ - (this.centered ? 0 : 1);
                break;
            }
            default: {
                this.termX = 0;
                this.termZ = 0;
            }
        }
    }

    public BlockPos transform(BlockPos pos) {
        return switch (this.rotation) {
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(this.termX + pos.m_123343_(), pos.m_123342_(), this.termZ - pos.m_123341_());
            case Rotation.CLOCKWISE_90 -> new BlockPos(this.termX - pos.m_123343_(), pos.m_123342_(), this.termZ + pos.m_123341_());
            case Rotation.CLOCKWISE_180 -> new BlockPos(this.termX - pos.m_123341_(), pos.m_123342_(), this.termZ - pos.m_123343_());
            default -> pos;
        };
    }

    @Override
    public PartialTile process(PartialTile tile, ProcessorContext context) {
        tile.setPos(this.transform(tile.getPos()));
        tile.getState().rotate(this.rotation);
        return tile;
    }
}

