/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TargetTileProcessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class SpawnerTileProcessor
extends TargetTileProcessor<SpawnerTileProcessor> {
    protected final WeightedList<WeightedList<PartialEntity>> output = new WeightedList();

    public WeightedList<WeightedList<PartialEntity>> getOutput() {
        return this.output;
    }

    public SpawnerTileProcessor into(WeightedList<PartialEntity> output, int weight) {
        this.output.put(output, weight);
        return this;
    }

    @Override
    public PartialTile process(PartialTile tile, ProcessorContext context) {
        if (this.predicate.test(tile)) {
            CompoundTag nbt = new CompoundTag();
            CompoundTag inventory = new CompoundTag();
            ListTag stacks = new ListTag();
            this.output.getRandom(context.getRandom(tile.getPos())).ifPresent(result -> {
                result.forEach((entity, weight) -> {
                    CompoundTag entry = new CompoundTag();
                    entry.m_128359_("id", "ispawner:spawn_egg");
                    entry.m_128405_("Count", weight.intValue());
                    entity.getNbt().asWhole().ifPresent(tag -> {
                        CompoundTag wrapped = new CompoundTag();
                        wrapped.m_128365_("EntityTag", (Tag)tag);
                        entry.m_128365_("tag", (Tag)wrapped);
                    });
                    stacks.add((Object)entry);
                });
                inventory.m_128365_("Stacks", (Tag)stacks);
                nbt.m_128365_("Inventory", (Tag)inventory);
                PartialCompoundNbt.of(nbt).fillInto(tile.getEntity());
            });
        }
        return tile;
    }
}

