/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.util.Mat4i;
import iskallia.vault.core.util.RotNorm;
import iskallia.vault.core.util.RotateMirror;
import iskallia.vault.core.util.Vec4i;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.MirrorTileProcessor;
import iskallia.vault.core.world.processor.tile.RotateTileProcessor;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.processor.tile.TranslateTileProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;

public class TransformTileProcessor
extends TileProcessor {
    private final RotateMirror rotateMirror;
    private final Mat4i positionTransform;

    public TransformTileProcessor(RotateMirror rotateMirror, Mat4i positionTransform) {
        this.rotateMirror = rotateMirror;
        this.positionTransform = positionTransform;
    }

    @Override
    public PartialTile process(PartialTile tile, ProcessorContext ctx) {
        if (tile == null) {
            return null;
        }
        if (this.rotateMirror.mirror() == Mirror.NONE && this.rotateMirror.rotation() == Rotation.NONE) {
            BlockPos p = tile.getPos();
            tile.setPos(new BlockPos(p.m_123341_() + this.positionTransform.d().x(), p.m_123342_() + this.positionTransform.d().y(), p.m_123343_() + this.positionTransform.d().z()));
            return tile;
        }
        PartialBlockState state = tile.getState();
        if (this.rotateMirror.rotation() != Rotation.NONE) {
            state.rotate(this.rotateMirror.rotation());
        }
        if (this.rotateMirror.mirror() != Mirror.NONE) {
            state.mirror(this.rotateMirror.mirror());
        }
        tile.setState(state);
        Vec4i pos = new Vec4i(tile.getPos().m_123341_(), tile.getPos().m_123342_(), tile.getPos().m_123343_(), 1);
        Vec4i out = pos.mul(this.positionTransform);
        tile.setPos(new BlockPos(out.x(), out.y(), out.z()));
        return tile;
    }

    public static TransformTileProcessor identity() {
        return new TransformTileProcessor(new RotateMirror(Rotation.NONE, Mirror.NONE), Mat4i.identity());
    }

    public static TransformTileProcessor merge(TransformTileProcessor a, TransformTileProcessor b) {
        RotateMirror merged = RotNorm.from(a.rotateMirror).plus(RotNorm.from(b.rotateMirror)).toRotateMirror();
        return new TransformTileProcessor(merged, b.positionTransform.mul(a.positionTransform));
    }

    public static TransformTileProcessor from(TranslateTileProcessor p) {
        return new TransformTileProcessor(new RotateMirror(Rotation.NONE, Mirror.NONE), new Mat4i(new Vec4i(1, 0, 0, 0), new Vec4i(0, 1, 0, 0), new Vec4i(0, 0, 1, 0), new Vec4i(p.offsetX, p.offsetY, p.offsetZ, 1)));
    }

    private static int mirrorTerm(MirrorTileProcessor p) {
        return 2 * p.plane - (p.centered ? 0 : 1);
    }

    public static TransformTileProcessor from(MirrorTileProcessor p) {
        return switch (p.mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.NONE -> TransformTileProcessor.identity();
            case Mirror.LEFT_RIGHT -> new TransformTileProcessor(new RotateMirror(Rotation.NONE, Mirror.LEFT_RIGHT), new Mat4i(new Vec4i(1, 0, 0, 0), new Vec4i(0, 1, 0, 0), new Vec4i(0, 0, -1, 0), new Vec4i(0, 0, TransformTileProcessor.mirrorTerm(p), 1)));
            case Mirror.FRONT_BACK -> new TransformTileProcessor(new RotateMirror(Rotation.NONE, Mirror.FRONT_BACK), new Mat4i(new Vec4i(-1, 0, 0, 0), new Vec4i(0, 1, 0, 0), new Vec4i(0, 0, 1, 0), new Vec4i(TransformTileProcessor.mirrorTerm(p), 0, 0, 1)));
        };
    }

    public static TransformTileProcessor from(RotateTileProcessor p) {
        return switch (p.rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> TransformTileProcessor.identity();
            case Rotation.CLOCKWISE_90 -> {
                int tx = p.pivotX + p.pivotZ;
                int tz = p.pivotZ - p.pivotX - (p.centered ? 0 : 1);
                yield new TransformTileProcessor(new RotateMirror(Rotation.CLOCKWISE_90, Mirror.NONE), new Mat4i(new Vec4i(0, 0, 1, 0), new Vec4i(0, 1, 0, 0), new Vec4i(-1, 0, 0, 0), new Vec4i(tx, 0, tz, 1)));
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                int tx = p.pivotX - p.pivotZ - (p.centered ? 0 : 1);
                int tz = p.pivotX + p.pivotZ;
                yield new TransformTileProcessor(new RotateMirror(Rotation.COUNTERCLOCKWISE_90, Mirror.NONE), new Mat4i(new Vec4i(0, 0, -1, 0), new Vec4i(0, 1, 0, 0), new Vec4i(1, 0, 0, 0), new Vec4i(tx, 0, tz, 1)));
            }
            case Rotation.CLOCKWISE_180 -> {
                int tx = 2 * p.pivotX - (p.centered ? 0 : 1);
                int tz = 2 * p.pivotZ - (p.centered ? 0 : 1);
                yield new TransformTileProcessor(new RotateMirror(Rotation.CLOCKWISE_180, Mirror.NONE), new Mat4i(new Vec4i(-1, 0, 0, 0), new Vec4i(0, 1, 0, 0), new Vec4i(0, 0, -1, 0), new Vec4i(tx, 0, tz, 1)));
            }
        };
    }
}

