/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.processor.tile;

import iskallia.vault.core.util.FastWeightedList;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TargetTileProcessor;

public class WeightedTileProcessor
extends TargetTileProcessor<WeightedTileProcessor> {
    protected final WeightedList<PartialTile> output = new WeightedList();
    private volatile transient FastWeightedList<PartialTile> cache;

    public WeightedList<PartialTile> getOutput() {
        return this.output;
    }

    public WeightedTileProcessor into(String target, int weight) {
        PartialTile tile = PartialTile.parse(target, true).orElse(PartialTile.ERROR);
        return this.into(tile, weight);
    }

    public WeightedTileProcessor into(PartialTile tile, int weight) {
        this.output.put(tile, weight);
        this.cache = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialTile process(PartialTile tile, ProcessorContext context) {
        if (this.predicate.test(tile)) {
            FastWeightedList<PartialTile> list = this.cache;
            if (list == null) {
                WeightedTileProcessor weightedTileProcessor = this;
                synchronized (weightedTileProcessor) {
                    list = this.cache;
                    if (list == null) {
                        this.cache = list = new FastWeightedList<PartialTile>(this.output);
                    }
                }
            }
            list.getRandom(context.getRandom(tile.getPos())).ifPresent(out -> out.fillInto(tile));
        }
        return tile;
    }
}

