/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.roll;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public interface DoubleRoll
extends ISerializable<CompoundTag, JsonObject> {
    public double getMin();

    public double getMax();

    public double get(RandomSource var1);

    default public boolean contains(double value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    public static Constant ofConstant(double count) {
        return new Constant(count);
    }

    public static Uniform ofUniform(double min, double max) {
        return new Uniform(min, max);
    }

    public static double getMin(DoubleRoll roll) {
        if (roll instanceof Constant) {
            Constant constant = (Constant)roll;
            return constant.getCount();
        }
        if (roll instanceof Uniform) {
            Uniform uniform = (Uniform)roll;
            return uniform.getMin();
        }
        throw new UnsupportedOperationException();
    }

    public static double getMax(DoubleRoll roll) {
        if (roll instanceof Constant) {
            Constant constant = (Constant)roll;
            return constant.getCount();
        }
        if (roll instanceof Uniform) {
            Uniform uniform = (Uniform)roll;
            return uniform.getMax();
        }
        throw new UnsupportedOperationException();
    }

    public static class Constant
    implements DoubleRoll {
        private double count;

        protected Constant() {
        }

        protected Constant(double count) {
            this.count = count;
        }

        public double getCount() {
            return this.count;
        }

        @Override
        public double getMin() {
            return this.getCount();
        }

        @Override
        public double getMax() {
            return this.getCount();
        }

        @Override
        public double get(RandomSource random) {
            return this.count;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.DOUBLE.writeBits(this.count, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.DOUBLE.readBits(buffer).ifPresent(value -> {
                this.count = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.DOUBLE.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.DOUBLE.readNbt(nbt.m_128423_("count")).ifPresent(value -> {
                this.count = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.DOUBLE.writeJson(this.count).ifPresent(tag -> json.add("count", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.DOUBLE.readJson(json.get("count")).ifPresent(value -> {
                this.count = value;
            });
        }
    }

    public static class Uniform
    implements DoubleRoll {
        private double min;
        private double max;

        protected Uniform() {
        }

        protected Uniform(double min, double max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.min + (this.max - this.min);
        }

        @Override
        public double get(RandomSource random) {
            return random.nextDouble() * (this.max - this.min) + this.min;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.DOUBLE.writeBits(this.min, buffer);
            Adapters.DOUBLE.writeBits(this.max, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.DOUBLE.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.DOUBLE.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.DOUBLE.writeNbt(this.min).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.DOUBLE.writeNbt(this.max).ifPresent(tag -> nbt.m_128365_("max", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.DOUBLE.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.DOUBLE.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.DOUBLE.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.DOUBLE.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.DOUBLE.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.DOUBLE.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<DoubleRoll> {
        public Adapter() {
            super("type", true);
            this.register("constant", Constant.class, Constant::new);
            this.register("uniform", Uniform.class, Uniform::new);
            this.register("uniformed_step", UniformedStep.class, UniformedStep::new);
        }

        @Override
        @Nullable
        protected DoubleRoll readSuppliedNbt(Tag nbt) {
            Optional result;
            if ((nbt instanceof NumericTag || nbt instanceof StringTag) && (result = Adapters.DOUBLE.readNbt(nbt)).isPresent()) {
                return DoubleRoll.ofConstant((Double)result.get());
            }
            return (DoubleRoll)super.readSuppliedNbt(nbt);
        }

        @Override
        @Nullable
        protected DoubleRoll readSuppliedJson(JsonElement json) {
            Optional result;
            JsonPrimitive primitive;
            if (json instanceof JsonPrimitive && ((primitive = (JsonPrimitive)json).isNumber() || primitive.isString()) && (result = Adapters.DOUBLE.readJson(json)).isPresent()) {
                return DoubleRoll.ofConstant((Double)result.get());
            }
            return (DoubleRoll)super.readSuppliedJson(json);
        }
    }

    public static class UniformedStep
    implements DoubleRoll {
        private double min;
        private double max;
        private double step;

        protected UniformedStep() {
        }

        protected UniformedStep(double min, double max, double step) {
            this.min = min;
            this.max = max;
            this.step = step > 0.0 ? step : 1.0;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }

        @Override
        public double get(RandomSource random) {
            double range = (this.max - this.min) / this.step + 1.0;
            double randomIndex = random.nextDouble(range);
            return this.min + randomIndex * this.step;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.DOUBLE.writeBits(this.min, buffer);
            Adapters.DOUBLE.writeBits(this.max, buffer);
            Adapters.DOUBLE.writeBits(this.step, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.DOUBLE.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.DOUBLE.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
            Adapters.DOUBLE.readBits(buffer).ifPresent(value -> {
                this.step = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.DOUBLE.writeNbt(this.min).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.DOUBLE.writeNbt(this.max).ifPresent(tag -> nbt.m_128365_("max", tag));
            Adapters.DOUBLE.writeNbt(this.step).ifPresent(tag -> nbt.m_128365_("step", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.DOUBLE.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.DOUBLE.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value;
            });
            Adapters.DOUBLE.readNbt(nbt.m_128423_("step")).ifPresent(value -> {
                this.step = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.DOUBLE.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.DOUBLE.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            Adapters.DOUBLE.writeJson(this.step).ifPresent(tag -> json.add("step", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.DOUBLE.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.DOUBLE.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
            Adapters.DOUBLE.readJson(json.get("step")).ifPresent(value -> {
                this.step = value;
            });
        }
    }
}

