/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.roll;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public interface FloatRoll
extends ISerializable<CompoundTag, JsonObject> {
    public float getMin();

    public float getMax();

    public float get(RandomSource var1);

    default public boolean contains(float value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    public static Constant ofConstant(float count) {
        return new Constant(count);
    }

    public static Uniform ofUniform(float min, float max) {
        return new Uniform(min, max);
    }

    public static UniformedStep ofUniformedStep(float min, float max, float step) {
        return new UniformedStep(min, max, step);
    }

    public static class Constant
    implements FloatRoll {
        private float count;

        protected Constant() {
        }

        protected Constant(float count) {
            this.count = count;
        }

        public float getCount() {
            return this.count;
        }

        @Override
        public float getMin() {
            return this.getCount();
        }

        @Override
        public float getMax() {
            return this.getCount();
        }

        @Override
        public float get(RandomSource random) {
            return this.count;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.FLOAT.writeBits(Float.valueOf(this.count), buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.FLOAT.readBits(buffer).ifPresent(value -> {
                this.count = value.floatValue();
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.FLOAT.writeNbt(Float.valueOf(this.count)).ifPresent(tag -> nbt.m_128365_("count", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.FLOAT.readNbt(nbt.m_128423_("count")).ifPresent(value -> {
                this.count = value.floatValue();
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.FLOAT.writeJson(Float.valueOf(this.count)).ifPresent(tag -> json.add("count", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.FLOAT.readJson(json.get("count")).ifPresent(value -> {
                this.count = value.floatValue();
            });
        }
    }

    public static class Uniform
    implements FloatRoll {
        private float min;
        private float max;

        protected Uniform() {
        }

        protected Uniform(float min, float max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public float getMin() {
            return this.min;
        }

        @Override
        public float getMax() {
            return this.min + (this.max - this.min);
        }

        @Override
        public float get(RandomSource random) {
            return random.nextFloat() * (this.max - this.min) + this.min;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.FLOAT.writeBits(Float.valueOf(this.min), buffer);
            Adapters.FLOAT.writeBits(Float.valueOf(this.max), buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.FLOAT.readBits(buffer).ifPresent(value -> {
                this.min = value.floatValue();
            });
            Adapters.FLOAT.readBits(buffer).ifPresent(value -> {
                this.max = value.floatValue();
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.FLOAT.writeNbt(Float.valueOf(this.min)).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.max)).ifPresent(tag -> nbt.m_128365_("max", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.FLOAT.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value.floatValue();
            });
            Adapters.FLOAT.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value.floatValue();
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.FLOAT.writeJson(Float.valueOf(this.min)).ifPresent(tag -> json.add("min", tag));
            Adapters.FLOAT.writeJson(Float.valueOf(this.max)).ifPresent(tag -> json.add("max", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.FLOAT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value.floatValue();
            });
            Adapters.FLOAT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value.floatValue();
            });
        }
    }

    public static class UniformedStep
    implements FloatRoll {
        private float min;
        private float max;
        private float step;

        protected UniformedStep() {
        }

        protected UniformedStep(float min, float max, float step) {
            this.min = min;
            this.max = max;
            this.step = step > 0.0f ? step : 1.0f;
        }

        @Override
        public float getMin() {
            return this.min;
        }

        @Override
        public float getMax() {
            return this.max;
        }

        @Override
        public float get(RandomSource random) {
            int steps = Mth.m_14143_((float)((this.max - this.min) / this.step + 1.0f));
            int index = random.nextInt(steps);
            return this.min + (float)index * this.step;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.FLOAT.writeBits(Float.valueOf(this.min), buffer);
            Adapters.FLOAT.writeBits(Float.valueOf(this.max), buffer);
            Adapters.FLOAT.writeBits(Float.valueOf(this.step), buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.FLOAT.readBits(buffer).ifPresent(value -> {
                this.min = value.floatValue();
            });
            Adapters.FLOAT.readBits(buffer).ifPresent(value -> {
                this.max = value.floatValue();
            });
            Adapters.FLOAT.readBits(buffer).ifPresent(value -> {
                this.step = value.floatValue();
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.FLOAT.writeNbt(Float.valueOf(this.min)).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.max)).ifPresent(tag -> nbt.m_128365_("max", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.step)).ifPresent(tag -> nbt.m_128365_("step", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.FLOAT.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value.floatValue();
            });
            Adapters.FLOAT.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value.floatValue();
            });
            Adapters.FLOAT.readNbt(nbt.m_128423_("step")).ifPresent(value -> {
                this.step = value.floatValue();
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.FLOAT.writeJson(Float.valueOf(this.min)).ifPresent(tag -> json.add("min", tag));
            Adapters.FLOAT.writeJson(Float.valueOf(this.max)).ifPresent(tag -> json.add("max", tag));
            Adapters.FLOAT.writeJson(Float.valueOf(this.step)).ifPresent(tag -> json.add("step", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.FLOAT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value.floatValue();
            });
            Adapters.FLOAT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value.floatValue();
            });
            Adapters.FLOAT.readJson(json.get("step")).ifPresent(value -> {
                this.step = value.floatValue();
            });
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<FloatRoll> {
        public Adapter() {
            super("type", true);
            this.register("constant", Constant.class, Constant::new);
            this.register("uniform", Uniform.class, Uniform::new);
            this.register("uniformed_step", UniformedStep.class, UniformedStep::new);
        }

        @Override
        @Nullable
        protected FloatRoll readSuppliedNbt(Tag nbt) {
            Optional result;
            if ((nbt instanceof NumericTag || nbt instanceof StringTag) && (result = Adapters.FLOAT.readNbt(nbt)).isPresent()) {
                return FloatRoll.ofConstant(((Float)result.get()).floatValue());
            }
            return (FloatRoll)super.readSuppliedNbt(nbt);
        }

        @Override
        @Nullable
        protected FloatRoll readSuppliedJson(JsonElement json) {
            Optional result;
            JsonPrimitive primitive;
            if (json instanceof JsonPrimitive && ((primitive = (JsonPrimitive)json).isNumber() || primitive.isString()) && (result = Adapters.FLOAT.readJson(json)).isPresent()) {
                return FloatRoll.ofConstant(((Float)result.get()).floatValue());
            }
            return (FloatRoll)super.readSuppliedJson(json);
        }
    }
}

