/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.roll;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public interface IntRoll
extends ISerializable<CompoundTag, JsonObject> {
    public int getMin();

    public int getMax();

    public int get(RandomSource var1);

    default public boolean contains(int value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    public static Constant ofConstant(int count) {
        return new Constant(count);
    }

    public static Uniform ofUniform(int min, int max) {
        return new Uniform(min, max);
    }

    public static UniformedStep ofUniformedStep(int min, int max, int step) {
        return new UniformedStep(min, max, step);
    }

    public static Triangular ofTriangular(int min, int max, int mode) {
        return new Triangular(min, max, mode);
    }

    public static Exponential ofExponential(int min, int max, double lambda) {
        return new Exponential(min, max, lambda);
    }

    public static Circular ofCircular(int min, int max, int center, double sharpness) {
        return new Circular(min, max, center, sharpness);
    }

    public static class Constant
    implements IntRoll {
        private int count;

        protected Constant() {
        }

        protected Constant(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int getMin() {
            return this.getCount();
        }

        @Override
        public int getMax() {
            return this.getCount();
        }

        @Override
        public int get(RandomSource random) {
            return this.count;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.count, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.count = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.INT.readNbt(nbt.m_128423_("count")).ifPresent(value -> {
                this.count = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.count).ifPresent(tag -> json.add("count", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("count")).ifPresent(value -> {
                this.count = value;
            });
        }
    }

    public static class Uniform
    implements IntRoll {
        private int min;
        private int max;

        protected Uniform() {
        }

        protected Uniform(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }

        @Override
        public int get(RandomSource random) {
            return random.nextInt(this.max - this.min + 1) + this.min;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.min, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.max, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT.writeNbt(this.min).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.INT.writeNbt(this.max).ifPresent(tag -> nbt.m_128365_("max", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.INT.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.INT.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
        }
    }

    public static class UniformedStep
    implements IntRoll {
        private int min;
        private int max;
        private int step;

        protected UniformedStep() {
        }

        protected UniformedStep(int min, int max, int step) {
            this.min = min;
            this.max = max;
            this.step = step > 0 ? step : 1;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }

        @Override
        public int get(RandomSource random) {
            int range = (this.max - this.min) / this.step + 1;
            int randomIndex = random.nextInt(range);
            return this.min + randomIndex * this.step;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.min, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.max, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.step, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.step = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT.writeNbt(this.min).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.INT.writeNbt(this.max).ifPresent(tag -> nbt.m_128365_("max", tag));
            Adapters.INT.writeNbt(this.step).ifPresent(tag -> nbt.m_128365_("step", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.INT.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("step")).ifPresent(value -> {
                this.step = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.INT.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            Adapters.INT.writeJson(this.step).ifPresent(tag -> json.add("step", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT.readJson(json.get("step")).ifPresent(value -> {
                this.step = value;
            });
        }
    }

    public static class Triangular
    implements IntRoll {
        private int min;
        private int max;
        private int mode;

        protected Triangular() {
        }

        protected Triangular(int min, int max, int mode) {
            this.min = min;
            this.max = max;
            this.mode = Math.max(min, Math.min(max, mode));
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }

        public int getMode() {
            return this.mode;
        }

        @Override
        public int get(RandomSource random) {
            double range = this.max - this.min;
            double modeOffset = (double)(this.mode - this.min) / range;
            double u = random.nextDouble();
            if (u <= modeOffset) {
                return this.min + (int)Math.sqrt(u * range * (double)(this.mode - this.min));
            }
            return this.max - (int)Math.sqrt((1.0 - u) * range * (double)(this.max - this.mode));
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.min, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.max, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.mode, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.mode = value;
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT.writeNbt(this.min).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.INT.writeNbt(this.max).ifPresent(tag -> nbt.m_128365_("max", tag));
            Adapters.INT.writeNbt(this.mode).ifPresent(tag -> nbt.m_128365_("mode", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.INT.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("mode")).ifPresent(value -> {
                this.mode = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.INT.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            Adapters.INT.writeJson(this.mode).ifPresent(tag -> json.add("mode", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT.readJson(json.get("mode")).ifPresent(value -> {
                this.mode = value;
            });
        }
    }

    public static class Exponential
    implements IntRoll {
        private int min;
        private int max;
        private double lambda;

        protected Exponential() {
        }

        protected Exponential(int min, int max, double lambda) {
            this.min = min;
            this.max = max;
            this.lambda = lambda > 0.0 ? lambda : 1.0;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }

        public double getLambda() {
            return this.lambda;
        }

        @Override
        public int get(RandomSource random) {
            double u = random.nextDouble();
            double expValue = -Math.log(1.0 - u) / this.lambda;
            double normalizedValue = 1.0 - Math.exp(-this.lambda * expValue);
            return this.min + (int)(normalizedValue * (double)(this.max - this.min + 1));
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.min, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.max, buffer);
            buffer.writeDouble(this.lambda);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
            this.lambda = buffer.readDouble();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT.writeNbt(this.min).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.INT.writeNbt(this.max).ifPresent(tag -> nbt.m_128365_("max", tag));
            nbt.m_128347_("lambda", this.lambda);
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.INT.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value;
            });
            if (nbt.m_128441_("lambda")) {
                this.lambda = nbt.m_128459_("lambda");
            }
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.INT.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            json.addProperty("lambda", (Number)this.lambda);
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
            if (json.has("lambda")) {
                this.lambda = json.get("lambda").getAsDouble();
            }
        }
    }

    public static class Circular
    implements IntRoll {
        private int min;
        private int max;
        private int center;
        private double sharpness;

        protected Circular() {
        }

        protected Circular(int min, int max, int center, double sharpness) {
            this.min = min;
            this.max = max;
            this.center = Math.max(min, Math.min(max, center));
            this.sharpness = sharpness > 0.0 ? sharpness : 1.0;
        }

        @Override
        public int getMin() {
            return this.min;
        }

        @Override
        public int getMax() {
            return this.max;
        }

        public int getCenter() {
            return this.center;
        }

        public double getSharpness() {
            return this.sharpness;
        }

        @Override
        public int get(RandomSource random) {
            double u = random.nextDouble();
            double v = random.nextDouble();
            double radius = Math.sqrt(-2.0 * Math.log(u));
            double theta = Math.PI * 2 * v;
            double normalValue = radius * Math.cos(theta);
            double range = (double)(this.max - this.min) / 2.0;
            double scaleFactor = range / (this.sharpness * 3.0);
            int result = (int)((double)this.center + normalValue * scaleFactor);
            return Math.max(this.min, Math.min(this.max, result));
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.min, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.max, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.center, buffer);
            buffer.writeDouble(this.sharpness);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.center = value;
            });
            this.sharpness = buffer.readDouble();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.INT.writeNbt(this.min).ifPresent(tag -> nbt.m_128365_("min", tag));
            Adapters.INT.writeNbt(this.max).ifPresent(tag -> nbt.m_128365_("max", tag));
            Adapters.INT.writeNbt(this.center).ifPresent(tag -> nbt.m_128365_("center", tag));
            nbt.m_128347_("sharpness", this.sharpness);
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            Adapters.INT.readNbt(nbt.m_128423_("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("max")).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT.readNbt(nbt.m_128423_("center")).ifPresent(value -> {
                this.center = value;
            });
            if (nbt.m_128441_("sharpness")) {
                this.sharpness = nbt.m_128459_("sharpness");
            }
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.INT.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            Adapters.INT.writeJson(this.center).ifPresent(tag -> json.add("center", tag));
            json.addProperty("sharpness", (Number)this.sharpness);
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
            Adapters.INT.readJson(json.get("center")).ifPresent(value -> {
                this.center = value;
            });
            if (json.has("sharpness")) {
                this.sharpness = json.get("sharpness").getAsDouble();
            }
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<IntRoll> {
        public Adapter() {
            super("type", true);
            this.register("constant", Constant.class, Constant::new);
            this.register("uniform", Uniform.class, Uniform::new);
            this.register("uniformed_step", UniformedStep.class, UniformedStep::new);
            this.register("triangular", Triangular.class, Triangular::new);
            this.register("exponential", Exponential.class, Exponential::new);
            this.register("circular", Circular.class, Circular::new);
        }

        @Override
        @Nullable
        protected IntRoll readSuppliedNbt(Tag nbt) {
            Optional result;
            if ((nbt instanceof NumericTag || nbt instanceof StringTag) && (result = Adapters.INT.readNbt(nbt)).isPresent()) {
                return IntRoll.ofConstant((Integer)result.get());
            }
            return (IntRoll)super.readSuppliedNbt(nbt);
        }

        @Override
        @Nullable
        protected IntRoll readSuppliedJson(JsonElement json) {
            Optional result;
            JsonPrimitive primitive;
            if (json instanceof JsonPrimitive && ((primitive = (JsonPrimitive)json).isNumber() || primitive.isString()) && (result = Adapters.INT.readJson(json)).isPresent()) {
                return IntRoll.ofConstant((Integer)result.get());
            }
            return (IntRoll)super.readSuppliedJson(json);
        }
    }
}

