/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public class BlockCuboid
implements ISerializable<CompoundTag, JsonObject> {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    protected BlockCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public static BlockCuboid of(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new BlockCuboid(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static BlockCuboid of(BlockPos min, BlockPos max) {
        return BlockCuboid.of(min.m_123341_(), min.m_123342_(), min.m_123343_(), max.m_123341_(), max.m_123342_(), max.m_123343_());
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public static BlockCuboid of(BlockPos pos) {
        return BlockCuboid.of(pos, pos);
    }

    public List<BlockCuboid> subtract(BlockCuboid other) {
        return List.of(this);
    }

    public Optional<BlockCuboid> combine(BlockCuboid other) {
        if (this.equals(other)) {
            return Optional.of(this);
        }
        if (other.minX > this.maxX || this.minX > other.maxX) {
            return Optional.empty();
        }
        if (other.minY > this.maxY || this.minY > other.maxY) {
            return Optional.empty();
        }
        if (other.minZ > this.maxZ || this.minX > other.maxZ) {
            return Optional.empty();
        }
        return Optional.of(BlockCuboid.of(Math.min(this.minX, other.minX), Math.min(this.minY, other.minY), Math.min(this.minZ, other.minZ), Math.max(this.maxX, other.maxX), Math.max(this.maxY, other.maxY), Math.max(this.maxZ, other.maxZ)));
    }

    public static void add(List<BlockCuboid> cuboids, BlockCuboid other) {
        BlockCuboid added = other;
        int addedIndex = -1;
        boolean done = false;
        while (!done) {
            done = true;
            for (int i = cuboids.size() - 1; i >= 0; --i) {
                BlockCuboid merged;
                if (i == addedIndex || (merged = (BlockCuboid)cuboids.get(i).combine(added).orElse(null)) == null) continue;
                cuboids.set(i, merged);
                done = false;
                if (addedIndex >= 0) {
                    cuboids.remove(addedIndex);
                }
                added = merged;
                addedIndex = i;
            }
        }
        if (addedIndex < 0) {
            cuboids.add(added);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlockCuboid other = (BlockCuboid)object;
        return this.minX == other.minX && this.minY == other.minY && this.minZ == other.minZ && this.maxX == other.maxX && this.maxY == other.maxY && this.maxZ == other.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public BlockCuboid offset(Vec3i offset) {
        return new BlockCuboid(this.minX + offset.m_123341_(), this.minY + offset.m_123342_(), this.minZ + offset.m_123343_(), this.maxX + offset.m_123341_(), this.maxY + offset.m_123342_(), this.maxZ + offset.m_123343_());
    }

    public boolean contains(Vec3i point) {
        return this.minX <= point.m_123341_() && this.maxX >= point.m_123341_() && this.minY <= point.m_123342_() && this.maxY >= point.m_123342_() && this.minZ <= point.m_123343_() && this.maxZ >= point.m_123343_();
    }

    public BlockCuboid grow(int x, int y, int z) {
        return new BlockCuboid(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public BlockCuboid rotate(Rotation rotation, BlockPos pivot, boolean centered) {
        int termX;
        BlockPos min = switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(termX + this.minZ, this.minY, (switch (rotation) {
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    termX = pivot.m_123341_() - pivot.m_123343_() - (centered ? 0 : 1);
                    yield pivot.m_123341_() + pivot.m_123343_();
                }
                case Rotation.CLOCKWISE_90 -> {
                    termX = pivot.m_123341_() + pivot.m_123343_();
                    yield pivot.m_123343_() - pivot.m_123341_() - (centered ? 0 : 1);
                }
                case Rotation.CLOCKWISE_180 -> {
                    termX = pivot.m_123341_() + pivot.m_123341_() - (centered ? 0 : 1);
                    yield pivot.m_123343_() + pivot.m_123343_() - (centered ? 0 : 1);
                }
                default -> {
                    termX = 0;
                    yield 0;
                }
            }) - this.minX);
            case Rotation.CLOCKWISE_90 -> new BlockPos(termX - this.minZ, this.minY, (switch (rotation) {
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    termX = pivot.m_123341_() - pivot.m_123343_() - (centered ? 0 : 1);
                    yield pivot.m_123341_() + pivot.m_123343_();
                }
                case Rotation.CLOCKWISE_90 -> {
                    termX = pivot.m_123341_() + pivot.m_123343_();
                    yield pivot.m_123343_() - pivot.m_123341_() - (centered ? 0 : 1);
                }
                case Rotation.CLOCKWISE_180 -> {
                    termX = pivot.m_123341_() + pivot.m_123341_() - (centered ? 0 : 1);
                    yield pivot.m_123343_() + pivot.m_123343_() - (centered ? 0 : 1);
                }
                default -> {
                    termX = 0;
                    yield 0;
                }
            }) + this.minX);
            case Rotation.CLOCKWISE_180 -> new BlockPos(termX - this.minX, this.minY, (switch (rotation) {
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    termX = pivot.m_123341_() - pivot.m_123343_() - (centered ? 0 : 1);
                    yield pivot.m_123341_() + pivot.m_123343_();
                }
                case Rotation.CLOCKWISE_90 -> {
                    termX = pivot.m_123341_() + pivot.m_123343_();
                    yield pivot.m_123343_() - pivot.m_123341_() - (centered ? 0 : 1);
                }
                case Rotation.CLOCKWISE_180 -> {
                    termX = pivot.m_123341_() + pivot.m_123341_() - (centered ? 0 : 1);
                    yield pivot.m_123343_() + pivot.m_123343_() - (centered ? 0 : 1);
                }
                default -> {
                    termX = 0;
                    yield 0;
                }
            }) - this.minZ);
            default -> new BlockPos(this.minX, this.minY, this.minZ);
        };
        BlockPos max = switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(termX + this.maxZ, this.maxY, termZ - this.maxX);
            case Rotation.CLOCKWISE_90 -> new BlockPos(termX - this.maxZ, this.maxY, termZ + this.maxX);
            case Rotation.CLOCKWISE_180 -> new BlockPos(termX - this.maxX, this.maxY, termZ - this.maxZ);
            default -> new BlockPos(this.maxX, this.maxY, this.maxZ);
        };
        return new BlockCuboid(Math.min(min.m_123341_(), max.m_123341_()), min.m_123342_(), Math.min(min.m_123343_(), max.m_123343_()), Math.max(min.m_123341_(), max.m_123341_()), max.m_123342_(), Math.max(min.m_123343_(), max.m_123343_()));
    }

    public static class Adapter
    implements ISimpleAdapter<BlockCuboid, Tag, JsonElement> {
        @Override
        public void writeBits(@Nullable BlockCuboid value, BitBuffer buffer) {
            Adapters.BOOLEAN.writeBits(value == null, buffer);
            if (value != null) {
                Adapters.INT_SEGMENTED_7.writeBits(value.minX, buffer);
                Adapters.INT_SEGMENTED_7.writeBits(value.minY, buffer);
                Adapters.INT_SEGMENTED_7.writeBits(value.minZ, buffer);
                Adapters.INT_SEGMENTED_7.writeBits(value.maxX - value.minX, buffer);
                Adapters.INT_SEGMENTED_7.writeBits(value.maxY - value.minY, buffer);
                Adapters.INT_SEGMENTED_7.writeBits(value.maxZ - value.minZ, buffer);
            }
        }

        @Override
        public Optional<BlockCuboid> readBits(BitBuffer buffer) {
            if (Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
                return Optional.empty();
            }
            int minX = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            int minY = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            int minZ = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            int maxX = minX + (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            int maxY = minY + (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            int maxZ = minZ + (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            return Optional.of(new BlockCuboid(minX, minY, minZ, maxX, maxY, maxZ));
        }

        @Override
        public Optional<Tag> writeNbt(@Nullable BlockCuboid value) {
            if (value == null) {
                return Optional.empty();
            }
            ListTag array = new ListTag();
            array.add((Object)LongTag.m_128882_((long)BlockPos.m_121882_((int)value.minX, (int)value.minY, (int)value.minZ)));
            array.add((Object)LongTag.m_128882_((long)BlockPos.m_121882_((int)value.maxX, (int)value.maxY, (int)value.maxZ)));
            return Optional.of(array);
        }

        @Override
        public Optional<BlockCuboid> readNbt(@Nullable Tag nbt) {
            CompoundTag compound;
            ListTag list;
            if (nbt instanceof ListTag && (list = (ListTag)nbt).size() == 2 && list.get(0) instanceof NumericTag) {
                long min = ((NumericTag)list.get(0)).m_7046_();
                long max2 = ((NumericTag)list.get(1)).m_7046_();
                return Optional.of(BlockCuboid.of(BlockPos.m_122022_((long)min), BlockPos.m_122022_((long)max2)));
            }
            if (nbt instanceof CompoundTag && (compound = (CompoundTag)nbt).m_128431_().size() == 2) {
                CollectionTag tag;
                CollectionTag max;
                CollectionTag tag2;
                Tag max2 = compound.m_128423_("min");
                CollectionTag min = max2 instanceof CollectionTag ? (tag2 = (CollectionTag)max2) : null;
                Tag tag3 = compound.m_128423_("max");
                CollectionTag collectionTag = max = tag3 instanceof CollectionTag ? (tag = (CollectionTag)tag3) : null;
                if (min == null || max == null || min.size() != 3 || max.size() != 3) {
                    return Optional.empty();
                }
                return Optional.of(BlockCuboid.of((Integer)Adapters.INT.readNbt((Tag)min.get(0)).orElseThrow(), (Integer)Adapters.INT.readNbt((Tag)min.get(1)).orElseThrow(), (Integer)Adapters.INT.readNbt((Tag)min.get(2)).orElseThrow(), (Integer)Adapters.INT.readNbt((Tag)max.get(0)).orElseThrow(), (Integer)Adapters.INT.readNbt((Tag)max.get(1)).orElseThrow(), (Integer)Adapters.INT.readNbt((Tag)max.get(2)).orElseThrow()));
            }
            return Optional.empty();
        }
    }
}

