/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.storage;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockSetEvent;
import iskallia.vault.core.world.DummyProgressListener;
import iskallia.vault.core.world.generator.DummyChunkGenerator;
import iskallia.vault.core.world.threading.ThreadingMode;
import iskallia.vault.mixin.AccessorMinecraftServer;
import iskallia.vault.mixin.AccessorServerChunkCache;
import iskallia.vault.mixin.AccessorWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VirtualWorld
extends ServerLevel {
    public static final int UPDATE_IGNORE_PLACE = 256;
    protected ThreadingMode threadingMode;
    protected int tickCount;
    protected int randomTickSpeed;
    protected boolean delete;

    protected VirtualWorld(MinecraftServer server, Executor executor, LevelStorageSource.LevelStorageAccess session, ServerLevelData properties, ResourceKey<Level> worldKey, Holder<DimensionType> registryEntry, ChunkProgressListener progressListener, ChunkGenerator chunkGenerator, boolean isDebug, long hashedSeed, List<CustomSpawner> spawners, boolean shouldTickTime) {
        super(server, executor, session, properties, worldKey, registryEntry, progressListener, chunkGenerator, isDebug, hashedSeed, spawners, shouldTickTime);
    }

    public ThreadingMode getThreadingMode() {
        return this.threadingMode;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public boolean isMarkedForDeletion() {
        return this.delete;
    }

    public VirtualWorld setThreadingMode(ThreadingMode threadingMode) {
        this.threadingMode = threadingMode;
        return this;
    }

    public void setRandomTickSpeed(int randomTickSpeed) {
        this.randomTickSpeed = randomTickSpeed;
    }

    public void markForDeletion() {
        this.delete = true;
    }

    public void swapThreadsAndRun(Thread thread, Runnable runnable) {
        String oldName = thread.getName();
        Thread[] old = new Thread[]{((AccessorWorld)((Object)this)).getThread(), ((AccessorServerChunkCache)this.m_7726_()).getThread()};
        thread.setName(this.m_46472_().m_135782_().toString());
        ((AccessorWorld)((Object)this)).setThread(thread);
        ((AccessorServerChunkCache)this.m_7726_()).setThread(thread);
        runnable.run();
        thread.setName(oldName);
        ((AccessorWorld)((Object)this)).setThread(old[0]);
        ((AccessorServerChunkCache)this.m_7726_()).setThread(old[1]);
    }

    public void m_8714_(LevelChunk chunk, int randomTickSpeed) {
        super.m_8714_(chunk, this.randomTickSpeed);
    }

    public void m_8793_(BooleanSupplier hasTimeLeft) {
        super.m_8793_(hasTimeLeft);
        ++this.tickCount;
    }

    public boolean m_6933_(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        BlockState blockstate;
        CommonEvents.BLOCK_SET.invoke((LevelWriter)this, pos, state, flags, recursionLeft, BlockSetEvent.Type.HEAD);
        if (this.m_151570_(pos) || !this.f_46443_ && this.m_46659_()) {
            CommonEvents.BLOCK_SET.invoke((LevelWriter)this, pos, state, flags, recursionLeft, BlockSetEvent.Type.RETURN);
            return false;
        }
        LevelChunk levelchunk = this.m_46745_(pos);
        Block block = state.m_60734_();
        pos = pos.m_7949_();
        BlockSnapshot blockSnapshot = null;
        if (this.captureBlockSnapshots && !this.f_46443_) {
            blockSnapshot = BlockSnapshot.create((ResourceKey)this.m_46472_(), (LevelAccessor)this, (BlockPos)pos, (int)flags);
            this.capturedBlockSnapshots.add(blockSnapshot);
        }
        BlockState old = this.m_8055_(pos);
        int oldLight = old.getLightEmission((BlockGetter)this, pos);
        int oldOpacity = old.m_60739_((BlockGetter)this, pos);
        if ((flags & 0x100) != 0) {
            boolean oldFlag = this.captureBlockSnapshots;
            this.captureBlockSnapshots = true;
            blockstate = levelchunk.m_6978_(pos, state, (flags & 0x40) != 0);
            this.captureBlockSnapshots = oldFlag;
        } else {
            blockstate = levelchunk.m_6978_(pos, state, (flags & 0x40) != 0);
        }
        if (blockstate == null) {
            if (blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
            }
            CommonEvents.BLOCK_SET.invoke((LevelWriter)this, pos, state, flags, recursionLeft, BlockSetEvent.Type.RETURN);
            return false;
        }
        BlockState existing = this.m_8055_(pos);
        if ((flags & 0x80) == 0 && existing != blockstate && (existing.m_60739_((BlockGetter)this, pos) != oldOpacity || existing.getLightEmission((BlockGetter)this, pos) != oldLight || existing.m_60787_() || blockstate.m_60787_())) {
            this.m_46473_().m_6180_("queueCheckLight");
            this.m_7726_().m_7827_().m_142202_(pos);
            this.m_46473_().m_7238_();
        }
        if (blockSnapshot == null) {
            this.markAndNotifyBlock(pos, levelchunk, blockstate, state, flags, recursionLeft);
        }
        CommonEvents.BLOCK_SET.invoke((LevelWriter)this, pos, state, flags, recursionLeft, BlockSetEvent.Type.RETURN);
        return true;
    }

    public boolean m_46461_() {
        return false;
    }

    public boolean m_46462_() {
        return true;
    }

    public static VirtualWorld create(ResourceLocation id, ThreadingMode mode) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Executor executor = ((AccessorMinecraftServer)server).getWorkerExecutor();
        LevelStorageSource.LevelStorageAccess session = ((AccessorMinecraftServer)server).getSession();
        DerivedLevelData properties = new DerivedLevelData(server.m_129910_(), server.m_129910_().m_5996_());
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)id);
        DummyProgressListener progressListener = new DummyProgressListener();
        DimensionType dimension = DimensionType.m_204497_((OptionalLong)OptionalLong.of(15000L), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (double)1.0, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (int)0, (int)192, (int)192, (TagKey)BlockTags.f_13058_, (ResourceLocation)DimensionType.f_63841_, (float)0.05f);
        DummyChunkGenerator chunkGenerator = new DummyChunkGenerator((Registry<StructureSet>)server.m_206579_().m_175515_(Registry.f_211073_), (Registry<Biome>)server.m_206579_().m_175515_(Registry.f_122885_));
        boolean isDebugWorld = false;
        long hashedSeed = 0L;
        ArrayList<CustomSpawner> spawners = new ArrayList<CustomSpawner>();
        boolean shouldTickTime = false;
        VirtualWorld world = new VirtualWorld(server, executor, session, (ServerLevelData)properties, (ResourceKey<Level>)worldKey, (Holder<DimensionType>)Holder.m_205709_((Object)dimension), progressListener, chunkGenerator, isDebugWorld, hashedSeed, spawners, shouldTickTime);
        world.setThreadingMode(mode);
        return world;
    }
}

