/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.storage;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.storage.WorldZone;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;

public class WorldZones
implements ISerializable<CompoundTag, JsonObject> {
    private Long2ObjectMap<IntSet> chunkToZones = new Long2ObjectOpenHashMap();
    private Int2ObjectMap<WorldZone> indexToZone = new Int2ObjectOpenHashMap();
    private int index;
    private IntSet addedZones = new IntOpenHashSet();
    private IntSet removedZones = new IntOpenHashSet();

    public Int2ObjectMap<WorldZone> getAll() {
        return this.indexToZone;
    }

    public IntSet getAddedZones() {
        return this.addedZones;
    }

    public IntSet getRemovedZones() {
        return this.removedZones;
    }

    public Optional<WorldZone> get(int zoneIndex) {
        return Optional.ofNullable((WorldZone)this.indexToZone.get(zoneIndex));
    }

    public List<WorldZone> get(BlockPos pos) {
        return this.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public List<WorldZone> get(int x, int y, int z) {
        long chunk = ChunkPos.m_45589_((int)(x >> 4), (int)(z >> 4));
        ArrayList<WorldZone> zones = new ArrayList<WorldZone>();
        IntSet affected = (IntSet)this.chunkToZones.get(chunk);
        if (affected == null) {
            return zones;
        }
        IntIterator intIterator = affected.iterator();
        while (intIterator.hasNext()) {
            int index = (Integer)intIterator.next();
            WorldZone zone = (WorldZone)this.indexToZone.get(index);
            if (zone == null || !zone.contains(new BlockPos(x, y, z))) continue;
            zones.add(zone);
        }
        return zones;
    }

    public int add(int index, WorldZone zone) {
        this.remove(index);
        zone.setLocked(true);
        this.indexToZone.put(index, (Object)zone);
        LongIterator longIterator = zone.getChunks().iterator();
        while (longIterator.hasNext()) {
            long chunk = (Long)longIterator.next();
            ((IntSet)this.chunkToZones.computeIfAbsent(chunk, l -> new IntOpenHashSet())).add(index);
        }
        this.removedZones.remove(index);
        this.addedZones.add(index);
        return index;
    }

    public int add(WorldZone zone) {
        return this.add(this.index++, zone);
    }

    public void remove(int zoneIndex) {
        WorldZone region = (WorldZone)this.indexToZone.remove(zoneIndex);
        if (region == null) {
            return;
        }
        region.getChunks().iterator().forEachRemaining(chunk -> {
            IntSet chunkRegions = (IntSet)this.chunkToZones.get(chunk);
            if (chunkRegions == null) {
                return;
            }
            chunkRegions.remove(zoneIndex);
            if (chunkRegions.isEmpty()) {
                this.chunkToZones.remove(chunk);
            }
        });
        this.addedZones.remove(zoneIndex);
        this.removedZones.add(zoneIndex);
    }

    public void refreshDiff() {
        this.addedZones.clear();
        this.removedZones.clear();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.INT_SEGMENTED_7.writeBits(this.indexToZone.size(), buffer);
        this.indexToZone.forEach((index, zone) -> {
            Adapters.INT_SEGMENTED_7.writeBits(index, buffer);
            Adapters.WORLD_ZONE.writeBits((WorldZone)zone, buffer);
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        int size = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.chunkToZones.clear();
        this.indexToZone.clear();
        for (int i = 0; i < size; ++i) {
            this.indexToZone.put(((Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow()).intValue(), (Object)Adapters.WORLD_ZONE.readBits(buffer).orElseThrow());
        }
        this.indexToZone.forEach((index, zone) -> {
            LongIterator longIterator = zone.getChunks().iterator();
            while (longIterator.hasNext()) {
                long chunk = (Long)longIterator.next();
                ((IntSet)this.chunkToZones.computeIfAbsent(chunk, l -> new IntOpenHashSet())).add(index.intValue());
            }
        });
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            ListTag list = new ListTag();
            this.indexToZone.forEach((index, zone) -> {
                CompoundTag entry = new CompoundTag();
                Adapters.INT.writeNbt(index).ifPresent(tag -> entry.m_128365_("index", tag));
                Adapters.WORLD_ZONE.writeNbt((WorldZone)zone).ifPresent(tag -> entry.m_128365_("zone", (Tag)tag));
                list.add((Object)entry);
            });
            nbt.m_128365_("zones", (Tag)list);
            Adapters.INT.writeNbt(this.index).ifPresent(tag -> nbt.m_128365_("index", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.chunkToZones.clear();
        this.indexToZone.clear();
        ListTag list = nbt.m_128437_("zones", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            this.indexToZone.put(((Integer)Adapters.INT.readNbt(entry.m_128423_("index")).orElseThrow()).intValue(), (Object)Adapters.WORLD_ZONE.readNbt(entry.m_128469_("zone")).orElseThrow());
        }
        this.indexToZone.forEach((index, zone) -> {
            LongIterator longIterator = zone.getChunks().iterator();
            while (longIterator.hasNext()) {
                long chunk = (Long)longIterator.next();
                ((IntSet)this.chunkToZones.computeIfAbsent(chunk, l -> new IntOpenHashSet())).add(index.intValue());
            }
        });
    }
}

