/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template;

import iskallia.vault.core.util.iterator.MappingIterator;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class DynamicTemplate
extends Template {
    private final List<PartialTile> tiles = new ArrayList<PartialTile>();
    private final List<PartialEntity> entities = new ArrayList<PartialEntity>();

    public void add(PartialTile tile) {
        this.tiles.add(tile);
    }

    @Override
    public Iterator<ResourceLocation> getTags() {
        return Collections.emptyIterator();
    }

    @Override
    public void addTag(ResourceLocation tag) {
    }

    @Override
    public boolean hasTag(ResourceLocation tag) {
        return false;
    }

    @Override
    public Iterator<PartialTile> getTiles(TilePredicate filter, PlacementSettings settings) {
        return new MappingIterator<PartialTile, PartialTile>(this.tiles.iterator(), tile -> {
            if (!filter.test((PartialTile)tile)) {
                return null;
            }
            tile = tile.copy();
            for (Processor processor : settings.getTileProcessors()) {
                if (tile == null || !filter.test((PartialTile)tile)) {
                    tile = null;
                    break;
                }
                tile = processor.process(tile, settings.getProcessorContext());
            }
            return tile;
        });
    }

    @Override
    public Iterator<PartialEntity> getEntities(EntityPredicate filter, PlacementSettings settings) {
        return new MappingIterator<PartialEntity, PartialEntity>(this.entities.iterator(), entity -> {
            if (!filter.test((PartialEntity)entity)) {
                return null;
            }
            entity = entity.copy();
            for (Processor processor : settings.getEntityProcessors()) {
                if (entity == null || !filter.test((PartialEntity)entity)) {
                    entity = null;
                    break;
                }
                entity = processor.process(entity, settings.getProcessorContext());
            }
            return entity;
        });
    }
}

