/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template;

import iskallia.vault.VaultMod;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class Performance {
    private static final int PRINT_INTERVAL = 5000;
    private static final double SMOOTHING_FACTOR = 0.001;
    private static final double RETENTION_FACTOR = 0.999;
    private final AtomicInteger chunkCount = new AtomicInteger(0);
    private final long startTimeMs = System.currentTimeMillis();
    private final AtomicLong lastPrintTimeMs = new AtomicLong(this.startTimeMs);
    private int lastPrintedCount = 0;
    private final AtomicLong nanosecondsPerChunk = new AtomicLong(0L);
    private final AtomicLong lastChunkTimeNs = new AtomicLong(System.nanoTime());

    public double getChunksPerSecond() {
        long nspc = this.nanosecondsPerChunk.get();
        return nspc > 0L ? 1.0E9 / (double)nspc : 0.0;
    }

    public int getTotalChunks() {
        return this.chunkCount.get();
    }

    public void recordChunk() {
        int currentCount = this.chunkCount.incrementAndGet();
        if (!FMLEnvironment.production) {
            this.logPerformanceIfNeeded(currentCount);
        }
        this.updateRealTimeMetrics();
    }

    private void logPerformanceIfNeeded(int currentCount) {
        long currentTimeMs = System.currentTimeMillis();
        long lastPrintTimeValue = this.lastPrintTimeMs.get();
        if (lastPrintTimeValue + 5000L < currentTimeMs) {
            long elapsedTimeMs = currentTimeMs - this.startTimeMs;
            double averageChunksPerSecond = 1000.0 * (double)currentCount / (double)elapsedTimeMs;
            int chunksSinceLastPrint = currentCount - this.lastPrintedCount;
            double recentChunksPerSecond = 1000.0 * (double)chunksSinceLastPrint / 5000.0;
            VaultMod.LOGGER.info(String.format("Performance: chunks: %d, elapsed: %dms, avg: %.2f/s, recent: %.2f/s, realtime: %.2f/s", currentCount, elapsedTimeMs, averageChunksPerSecond, recentChunksPerSecond, this.getChunksPerSecond()));
            this.lastPrintedCount = currentCount;
            this.lastPrintTimeMs.set(currentTimeMs);
        }
    }

    private void updateRealTimeMetrics() {
        long currentTimeNs = System.nanoTime();
        long deltaTimeNs = currentTimeNs - this.lastChunkTimeNs.getAndSet(currentTimeNs);
        this.nanosecondsPerChunk.updateAndGet(current -> (long)((double)current * 0.999 + 0.001 * (double)deltaTimeNs));
    }
}

