/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template;

import com.google.common.collect.Lists;
import iskallia.vault.VaultMod;
import iskallia.vault.block.HeraldControllerBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.util.iterator.MappingIterator;
import iskallia.vault.core.world.data.LazyObject;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.processor.Processor;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.StreamedTemplate;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.init.ModBlocks;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;

public class StructureTemplate
extends Template
implements INBTSerializable<CompoundTag>,
StreamedTemplate,
LazyObject {
    public static final Comparator<PartialTile> SORTER = Comparator.comparingInt(tile -> tile.getPos().m_123342_()).thenComparingInt(tile -> tile.getPos().m_123341_()).thenComparingInt(tile -> tile.getPos().m_123343_());
    private Map<TilePredicate, List<PartialTile>> tiles = new IdentityHashMap<TilePredicate, List<PartialTile>>();
    private Map<EntityPredicate, List<PartialEntity>> entities = new IdentityHashMap<EntityPredicate, List<PartialEntity>>();
    private IdPalette palette;
    private Vec3i size = Vec3i.f_123288_;
    private Set<ResourceLocation> tags = new HashSet<ResourceLocation>();
    private String path;
    private TilePredicate filter;
    private AtomicReference<CompletableFuture<Void>> initializationTask = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));
    private static final ExecutorService LAZY_LOADING_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setName("Vault\u2011LazyLoading");
        t.setDaemon(true);
        return t;
    });

    protected StructureTemplate(String path, TilePredicate filter) {
        this.path = path;
        this.filter = filter;
    }

    public static StructureTemplate fromPath(String path) {
        return StructureTemplate.fromPath(path, TilePredicate.FALSE);
    }

    public static StructureTemplate fromPath(String path, TilePredicate filter) {
        StructureTemplate template = new StructureTemplate(path, filter);
        template.setUninitialized();
        return template;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public Iterator<ResourceLocation> getTags() {
        return this.tags.iterator();
    }

    @Override
    public void addTag(ResourceLocation tag) {
        this.tags.add(tag);
    }

    @Override
    public boolean hasTag(ResourceLocation tag) {
        return this.tags.contains(tag);
    }

    @Override
    public void setUninitialized() {
        this.initializationTask.set(null);
    }

    @Override
    public void initializeIfNot() {
        CompletableFuture<Void> task = this.initializationTask.get();
        if (task == null) {
            CompletableFuture<Void> newTask = new CompletableFuture<Void>();
            if (this.initializationTask.compareAndSet(null, newTask)) {
                newTask.completeAsync(() -> {
                    Void void_;
                    FileInputStream fis = new FileInputStream(this.path);
                    try {
                        this.deserializeNBT(NbtIo.m_128939_((InputStream)fis));
                        void_ = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to load template from " + this.path, e);
                        }
                    }
                    fis.close();
                    return void_;
                }, LAZY_LOADING_EXECUTOR);
                task = newTask;
            } else {
                task = this.initializationTask.get();
            }
        }
        try {
            task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<PartialTile> getTiles(TilePredicate filter, PlacementSettings settings) {
        this.initializeIfNot();
        return new MappingIterator<PartialTile, PartialTile>(this.tiles.get(filter).iterator(), tile -> {
            if ((tile = tile.copy()) == null || !filter.test((PartialTile)tile)) {
                return null;
            }
            tile = settings.getTileMapper().mapBlock((PartialTile)tile, settings.getProcessorContext(), Integer.MIN_VALUE);
            return tile;
        });
    }

    @Override
    public Stream<PartialTile> getTileStream(TilePredicate filter, PlacementSettings settings) {
        this.initializeIfNot();
        return this.tiles.get(filter).parallelStream().map(tile -> {
            if ((tile = tile.copy()) == null || !filter.test((PartialTile)tile)) {
                return null;
            }
            return settings.getTileMapper().mapBlock((PartialTile)tile, settings.getProcessorContext(), Integer.MIN_VALUE);
        }).filter(Objects::nonNull);
    }

    @Override
    public Iterator<PartialEntity> getEntities(EntityPredicate filter, PlacementSettings settings) {
        this.initializeIfNot();
        return new MappingIterator<PartialEntity, PartialEntity>(this.entities.get(filter).iterator(), entity -> {
            entity = entity.copy();
            for (Processor processor : settings.getEntityProcessors()) {
                if (entity == null || !filter.test((PartialEntity)entity)) {
                    entity = null;
                    break;
                }
                entity = processor.process(entity, settings.getProcessorContext());
            }
            return entity;
        });
    }

    public CompoundTag serializeNBT() {
        this.initializeIfNot();
        CompoundTag nbt = new CompoundTag();
        if (this.tiles.isEmpty()) {
            nbt.m_128365_("blocks", (Tag)new ListTag());
            nbt.m_128365_("palette", (Tag)new ListTag());
        } else {
            ListTag blocksNBT = new ListTag();
            for (PartialTile partialTile : this.tiles.get(ALL_TILES)) {
                int paletteId = this.palette.getIdFor(partialTile.getState());
                blocksNBT.add((Object)this.toPaletteNBT(partialTile, new CompoundTag(), paletteId));
            }
            nbt.m_128365_("blocks", (Tag)blocksNBT);
            ListTag paletteNBT = new ListTag();
            for (PartialBlockState state : this.palette) {
                Adapters.PARTIAL_BLOCK_STATE.writeNbt(state).ifPresent(arg_0 -> paletteNBT.add(arg_0));
            }
            nbt.m_128365_("palette", (Tag)paletteNBT);
        }
        ListTag entitiesNBT = new ListTag();
        for (PartialEntity partialEntity : this.entities.get(ALL_ENTITIES)) {
            CompoundTag entityNBT = new CompoundTag();
            ListTag posNBT = new ListTag();
            posNBT.add((Object)DoubleTag.m_128500_((double)partialEntity.getPos().f_82479_));
            posNBT.add((Object)DoubleTag.m_128500_((double)partialEntity.getPos().f_82480_));
            posNBT.add((Object)DoubleTag.m_128500_((double)partialEntity.getPos().f_82481_));
            entityNBT.m_128365_("pos", (Tag)posNBT);
            ListTag blockPosNBT = new ListTag();
            blockPosNBT.add((Object)IntTag.m_128679_((int)partialEntity.getBlockPos().m_123341_()));
            blockPosNBT.add((Object)IntTag.m_128679_((int)partialEntity.getBlockPos().m_123342_()));
            blockPosNBT.add((Object)IntTag.m_128679_((int)partialEntity.getBlockPos().m_123343_()));
            entityNBT.m_128365_("blockPos", (Tag)blockPosNBT);
            partialEntity.getNbt().asWhole().ifPresent(tag -> entityNBT.m_128365_("nbt", (Tag)tag));
            entitiesNBT.add((Object)entityNBT);
        }
        nbt.m_128365_("entities", (Tag)entitiesNBT);
        ListTag sizeNBT = new ListTag();
        sizeNBT.add((Object)IntTag.m_128679_((int)this.size.m_123341_()));
        sizeNBT.add((Object)IntTag.m_128679_((int)this.size.m_123342_()));
        sizeNBT.add((Object)IntTag.m_128679_((int)this.size.m_123343_()));
        nbt.m_128365_("size", (Tag)sizeNBT);
        nbt.m_128405_("DataVersion", SharedConstants.m_183709_().getWorldVersion());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.tiles.clear();
        this.entities.clear();
        this.tiles.put(Template.ALL_TILES, new ArrayList());
        this.tiles.put(Template.JIGSAWS, new ArrayList());
        this.tiles.put(Template.PLACEHOLDERS, new ArrayList());
        this.tiles.put(Template.VAULT_PORTALS, new ArrayList());
        this.entities.put(Template.ALL_ENTITIES, new ArrayList());
        ListTag sizeNBT = nbt.m_128437_("size", 3);
        this.size = new Vec3i(sizeNBT.m_128763_(0), sizeNBT.m_128763_(1), sizeNBT.m_128763_(2));
        ListTag blocksNBT = nbt.m_128437_("blocks", 10);
        if (nbt.m_128425_("palettes", 9)) {
            this.loadPalette(nbt.m_128437_("palettes", 9).m_128744_(0), blocksNBT);
            VaultMod.LOGGER.error("Template does not support multiple palettes, using the first one instead");
        } else {
            this.loadPalette(nbt.m_128437_("palette", 10), blocksNBT);
        }
        ListTag entitiesNBT = nbt.m_128437_("entities", 10);
        for (int j = 0; j < entitiesNBT.size(); ++j) {
            CompoundTag entityNBT = entitiesNBT.m_128728_(j);
            ListTag posNBT = entityNBT.m_128437_("pos", 6);
            Vec3 pos = new Vec3(posNBT.m_128772_(0), posNBT.m_128772_(1), posNBT.m_128772_(2));
            ListTag blockPosNBT = entityNBT.m_128437_("blockPos", 3);
            BlockPos blockPos = new BlockPos(blockPosNBT.m_128763_(0), blockPosNBT.m_128763_(1), blockPosNBT.m_128763_(2));
            if (!entityNBT.m_128441_("nbt")) continue;
            PartialEntity entity = PartialEntity.of(pos, blockPos, PartialCompoundNbt.of(entityNBT.m_128469_("nbt")));
            this.entities.forEach((filter, list) -> {
                if (filter.test(entity)) {
                    list.add(entity);
                }
            });
        }
    }

    private void loadPalette(ListTag paletteNBT, ListTag blocksNBT) {
        this.palette = new IdPalette();
        for (int i = 0; i < paletteNBT.size(); ++i) {
            PartialBlockState state = Adapters.PARTIAL_BLOCK_STATE.readNbt((Tag)paletteNBT.m_128728_(i)).orElse(null);
            if (state == null) continue;
            this.palette.addMapping(state, i);
        }
        ArrayList normal = Lists.newArrayList();
        ArrayList withNBT = Lists.newArrayList();
        ArrayList withSpecialShape = Lists.newArrayList();
        for (int j = 0; j < blocksNBT.size(); ++j) {
            CompoundTag blockNBT = blocksNBT.m_128728_(j);
            PartialTile tile = StructureTemplate.fromPaletteNBT(blockNBT, this.palette::getStateFor);
            BlockState state = tile.getState().asWhole().orElse(ModBlocks.ERROR_BLOCK.m_49966_());
            if (this.filter.test(tile)) continue;
            if (tile.getEntity().asWhole().isPresent()) {
                withNBT.add(tile);
                continue;
            }
            if (!state.m_60734_().m_49967_() && state.m_60838_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
                normal.add(tile);
                continue;
            }
            withSpecialShape.add(tile);
        }
        if (this.path.equals("config/the_vault/gen/1.0/structures/vault/starts/herald.nbt")) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
            boolean found = false;
            Direction facing = Direction.SOUTH;
            for (PartialTile tile : withNBT) {
                if (!tile.getState().is(ModBlocks.PLACEHOLDER)) continue;
                facing = (Direction)tile.getState().getProperties().get(PlaceholderBlock.FACING);
                tile.setState(PartialBlockState.of((BlockState)((BlockState)ModBlocks.HERALD_CONTROLLER.m_49966_().m_61124_(HeraldControllerBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)HeraldControllerBlock.FACING, (Comparable)facing)));
                tile.setEntity(PartialCompoundNbt.of(new CompoundTag()));
                pos.m_122190_((Vec3i)tile.getPos()).m_122173_(Direction.UP);
                break;
            }
            for (PartialTile tile : withNBT) {
                if (!pos.equals((Object)tile.getPos())) continue;
                tile.setState(PartialBlockState.of((BlockState)((BlockState)ModBlocks.HERALD_CONTROLLER.m_49966_().m_61124_(HeraldControllerBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)HeraldControllerBlock.FACING, (Comparable)facing)));
                tile.setEntity(PartialCompoundNbt.of(new CompoundTag()));
                found = true;
                break;
            }
            if (!found) {
                withNBT.add(PartialTile.of(PartialBlockState.of((BlockState)((BlockState)ModBlocks.HERALD_CONTROLLER.m_49966_().m_61124_(HeraldControllerBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)HeraldControllerBlock.FACING, (Comparable)facing)), PartialCompoundNbt.of(new CompoundTag()), pos.m_7949_()));
            }
        }
        for (PartialTile tile : StructureTemplate.getOrderedTiles(normal, withNBT, withSpecialShape)) {
            this.tiles.forEach((filter, list) -> {
                if (filter.test(tile)) {
                    list.add(tile);
                }
            });
        }
    }

    private static List<PartialTile> getOrderedTiles(List<PartialTile> normal, List<PartialTile> withNBT, List<PartialTile> withSpecialShape) {
        normal.sort(SORTER);
        withSpecialShape.sort(SORTER);
        withNBT.sort(SORTER);
        ArrayList<PartialTile> tiles = new ArrayList<PartialTile>();
        tiles.addAll(normal);
        tiles.addAll(withSpecialShape);
        tiles.addAll(withNBT);
        return tiles;
    }

    public Tag toPaletteNBT(PartialTile tile, CompoundTag nbt, int index) {
        nbt.m_128405_("state", index);
        tile.getEntity().asWhole().ifPresent(tag -> nbt.m_128365_("nbt", (Tag)tag.m_6426_()));
        if (tile.getPos() != null) {
            ListTag posNBT = new ListTag();
            posNBT.add((Object)IntTag.m_128679_((int)tile.getPos().m_123341_()));
            posNBT.add((Object)IntTag.m_128679_((int)tile.getPos().m_123342_()));
            posNBT.add((Object)IntTag.m_128679_((int)tile.getPos().m_123343_()));
            nbt.m_128365_("pos", (Tag)posNBT);
        }
        return nbt;
    }

    public static PartialTile fromPaletteNBT(CompoundTag tag, Function<Integer, PartialBlockState> stateFunction) {
        PartialBlockState state = PartialBlockState.of(ModBlocks.ERROR_BLOCK.m_49966_());
        PartialCompoundNbt nbt = PartialCompoundNbt.empty();
        BlockPos pos = null;
        if (tag.m_128425_("state", 3)) {
            state = stateFunction.apply(tag.m_128451_("state"));
        }
        if (tag.m_128425_("pos", 9)) {
            ListTag posNBT = tag.m_128437_("pos", 3);
            pos = new BlockPos(posNBT.m_128763_(0), posNBT.m_128763_(1), posNBT.m_128763_(2));
        }
        if (tag.m_128425_("nbt", 10)) {
            nbt = PartialCompoundNbt.of(tag.m_128469_("nbt"));
        }
        return PartialTile.of(state, nbt, pos);
    }

    public static class IdPalette
    implements Iterable<PartialBlockState> {
        public static final PartialBlockState DEFAULT_STATE = PartialBlockState.of(ModBlocks.ERROR_BLOCK);
        private final IdMapper<PartialBlockState> ids = new IdMapper(16);
        private int nextId;

        public int getIdFor(PartialBlockState pState) {
            int i = this.ids.m_7447_((Object)pState);
            if (i == -1) {
                i = this.nextId++;
                this.ids.m_122664_((Object)pState, i);
            }
            return i;
        }

        public PartialBlockState getStateFor(int id) {
            PartialBlockState state = (PartialBlockState)this.ids.m_7942_(id);
            return state == null ? DEFAULT_STATE : state;
        }

        public void addMapping(PartialBlockState state, int id) {
            this.ids.m_122664_((Object)state, id);
        }

        @Override
        public Iterator<PartialBlockState> iterator() {
            return this.ids.iterator();
        }
    }
}

