/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template;

import iskallia.vault.core.data.key.Keyed;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.generator.BatchBlockPlacer;
import iskallia.vault.core.world.generator.JigsawData;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.StreamedTemplate;
import iskallia.vault.core.world.template.configured.ConfiguredTemplate;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public abstract class Template
extends Keyed<Template> {
    public static final TilePredicate ALL_TILES = (state, nbt) -> true;
    public static final TilePredicate JIGSAWS = TilePredicate.of(Blocks.f_50678_);
    public static final TilePredicate PLACEHOLDERS = TilePredicate.of(ModBlocks.PLACEHOLDER);
    public static final TilePredicate VAULT_PORTALS = (state, nbt) -> {
        Block block = state.getBlock().asWhole().orElse(null);
        if (block == ModBlocks.VAULT_PORTAL) {
            return true;
        }
        return block == Blocks.f_50678_ && new JigsawData(PartialTile.of(state, nbt)).getFinalState().m_60734_() == ModBlocks.VAULT_PORTAL;
    };
    public static final EntityPredicate ALL_ENTITIES = EntityPredicate.TRUE;
    protected static final Direction[] FLOWING_DIRECTIONS = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    protected static final TilePlacementResult EMPTY_TILE_RESULT = new TilePlacementResult(new ArrayList<PartialTile>(), new ArrayList<BlockPos>(), new ArrayList<BlockPos>());

    public abstract Iterator<ResourceLocation> getTags();

    public abstract void addTag(ResourceLocation var1);

    public abstract boolean hasTag(ResourceLocation var1);

    public Iterator<PartialTile> getTiles(PlacementSettings settings) {
        return this.getTiles(ALL_TILES, settings);
    }

    public Iterator<PartialEntity> getEntities(PlacementSettings settings) {
        return this.getEntities(ALL_ENTITIES, settings);
    }

    public Iterator<PartialTile> getTiles(TilePredicate filter) {
        return this.getTiles(filter, PlacementSettings.EMPTY);
    }

    public Iterator<PartialEntity> getEntities(EntityPredicate filter) {
        return this.getEntities(filter, PlacementSettings.EMPTY);
    }

    public abstract Iterator<PartialTile> getTiles(TilePredicate var1, PlacementSettings var2);

    public abstract Iterator<PartialEntity> getEntities(EntityPredicate var1, PlacementSettings var2);

    public <T extends ConfiguredTemplate> T configure(ConfiguredTemplate.Factory<T> factory, PlacementSettings settings) {
        return factory.create(this, settings);
    }

    public void place(ServerLevelAccessor world, PlacementSettings settings) {
        TilePlacementResult result = this.placeTiles(world, settings);
        this.fixFluidPlacement(world, result);
        this.updateBlockEntities(world, result);
        this.placeEntities(world, settings);
    }

    protected TilePlacementResult placeTiles(ServerLevelAccessor world, PlacementSettings settings) {
        Stream<PartialTile> tileStream;
        if (settings.doIgnoreTiles()) {
            return EMPTY_TILE_RESULT;
        }
        TilePlacementResult result = new TilePlacementResult(new ArrayList<PartialTile>(1024), new ArrayList<BlockPos>(settings.doKeepFluids() ? 4096 : 0), new ArrayList<BlockPos>(settings.doKeepFluids() ? 4096 : 0));
        Template template = this;
        if (template instanceof StreamedTemplate) {
            StreamedTemplate streamedTemplate = (StreamedTemplate)((Object)template);
            tileStream = streamedTemplate.getTileStream(ALL_TILES, settings);
        } else {
            tileStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getTiles(settings), 16), true);
        }
        BatchBlockPlacer.placeTiles((LevelAccessor)world, tileStream, result);
        return result;
    }

    protected void fixFluidPlacement(ServerLevelAccessor world, TilePlacementResult result) {
        boolean fluidPlaced = true;
        while (fluidPlaced && !result.flowingPositions.isEmpty()) {
            fluidPlaced = false;
            Iterator<BlockPos> iterator = result.flowingPositions.iterator();
            while (iterator.hasNext()) {
                BlockState state;
                Block block;
                BlockPos flowingPos = iterator.next();
                FluidState current = world.m_6425_(flowingPos);
                for (int i = 0; i < FLOWING_DIRECTIONS.length && !current.m_76170_(); ++i) {
                    BlockPos neighborPos = flowingPos.m_142300_(FLOWING_DIRECTIONS[i]);
                    FluidState neighborFluid = world.m_6425_(neighborPos);
                    if (!neighborFluid.m_76170_() || result.sourcePositions.contains(neighborPos)) continue;
                    current = neighborFluid;
                }
                if (!current.m_76170_() || !((block = (state = world.m_8055_(flowingPos)).m_60734_()) instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)block).m_7361_((LevelAccessor)world, flowingPos, state, current);
                fluidPlaced = true;
                iterator.remove();
            }
        }
    }

    protected void updateBlockEntities(ServerLevelAccessor world, TilePlacementResult result) {
        for (PartialTile tile : result.placedBlockEntities) {
            BlockEntity blockEntity = world.m_7702_(tile.getPos());
            if (blockEntity == null) continue;
            blockEntity.m_6596_();
        }
    }

    protected void placeEntities(ServerLevelAccessor world, PlacementSettings settings) {
        if (settings.doIgnoreEntities()) {
            return;
        }
        this.getEntities(settings).forEachRemaining(entity -> {
            Entity spawned;
            CompoundTag nbt = entity.getNbt().asWhole().map(CompoundTag::m_6426_).orElseGet(CompoundTag::new);
            ListTag posNBT = new ListTag();
            posNBT.add((Object)DoubleTag.m_128500_((double)entity.getPos().f_82479_));
            posNBT.add((Object)DoubleTag.m_128500_((double)entity.getPos().f_82480_));
            posNBT.add((Object)DoubleTag.m_128500_((double)entity.getPos().f_82481_));
            nbt.m_128365_("Pos", (Tag)posNBT);
            nbt.m_128473_("UUID");
            try {
                spawned = EntityType.m_20642_((CompoundTag)nbt, (Level)world.m_6018_()).orElse(null);
                if (spawned == null) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
            spawned.m_7678_(entity.getPos().f_82479_, entity.getPos().f_82480_, entity.getPos().f_82481_, spawned.m_146908_(), spawned.m_146909_());
            if (settings.doFinalizeEntities() && spawned instanceof Mob) {
                ((Mob)spawned).m_6518_(world, world.m_6436_(new BlockPos(entity.getPos())), settings.getMobSpawnType(), null, nbt);
            }
            world.m_47205_(spawned);
        });
    }

    public static class TilePlacementResult {
        public final List<PartialTile> placedBlockEntities;
        public final List<BlockPos> flowingPositions;
        public final List<BlockPos> sourcePositions;

        public TilePlacementResult(List<PartialTile> placedBlockEntities, List<BlockPos> flowingPositions, List<BlockPos> sourcePositions) {
            this.placedBlockEntities = placedBlockEntities;
            this.flowingPositions = flowingPositions;
            this.sourcePositions = sourcePositions;
        }
    }
}

