/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template.configured;

import iskallia.vault.VaultMod;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.generator.GeneratorThreading;
import iskallia.vault.core.world.template.StaticTemplate;
import iskallia.vault.core.world.template.StreamedTemplate;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.core.world.template.configured.ConfiguredTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;

public class SectionedTemplate {
    private final ConfiguredTemplate baseTemplate;
    private final AtomicBoolean hasStarted = new AtomicBoolean(false);
    private final CompletableFuture<Map<SectionPos, StaticTemplate>> sections = new CompletableFuture();

    public SectionedTemplate(ConfiguredTemplate baseTemplate) {
        this.baseTemplate = baseTemplate;
    }

    public void place(ServerLevelAccessor world, ChunkPos pos) {
        Map<SectionPos, StaticTemplate> sectionMap = this.ensureGeneratedAndGet();
        int minSection = world.m_151560_();
        int maxSection = world.m_151561_();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(maxSection - minSection + 1);
        for (int sectionY = minSection; sectionY <= maxSection; ++sectionY) {
            SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)pos, (int)sectionY);
            StaticTemplate template = sectionMap.get(sectionPos);
            if (template == null) continue;
            futures.add(CompletableFuture.runAsync(() -> template.place(world, this.baseTemplate.getSettings()), GeneratorThreading.getGeneratorExecutor()));
        }
        futures.forEach(CompletableFuture::join);
    }

    private Map<SectionPos, StaticTemplate> ensureGeneratedAndGet() {
        if (!this.hasStarted.getPlain() && this.hasStarted.compareAndSet(false, true)) {
            this.generateAsync();
        }
        try {
            return this.sections.get();
        }
        catch (InterruptedException | ExecutionException e) {
            VaultMod.LOGGER.error("Failed to generate sections for template: {}", this.baseTemplate.getParent().getKey(), (Object)e);
            return Map.of();
        }
    }

    private void generateAsync() {
        this.sections.completeAsync(() -> {
            Map tiles = ((StreamedTemplate)((Object)this.baseTemplate.getParent())).getTileStream(Template.ALL_TILES, this.baseTemplate.getSettings()).collect(SectionedTemplate.createParallelTileCollector());
            ConcurrentHashMap result = new ConcurrentHashMap();
            tiles.forEach((secPos, tileList) -> {
                ArrayList<PartialTile> optimizedTiles = new ArrayList<PartialTile>((Collection<PartialTile>)tileList);
                if (optimizedTiles instanceof ArrayList) {
                    optimizedTiles.trimToSize();
                }
                result.put(secPos, new StaticTemplate(optimizedTiles, new ArrayList<PartialEntity>(128)));
            });
            ArrayList entities = new ArrayList();
            this.baseTemplate.getParent().getEntities(Template.ALL_ENTITIES, this.baseTemplate.getSettings()).forEachRemaining(entities::add);
            entities.forEach(entity -> {
                StaticTemplate template;
                SectionPos sp = SectionPos.m_123199_((BlockPos)entity.getBlockPos());
                StaticTemplate staticTemplate = template = result.computeIfAbsent(sp, k -> new StaticTemplate(new ArrayList<PartialTile>(), new ArrayList<PartialEntity>(16)));
                synchronized (staticTemplate) {
                    ((List)template.getEntities()).add(entity);
                }
            });
            result.values().forEach(template -> {
                if (template.getEntities() instanceof ArrayList) {
                    ((ArrayList)template.getEntities()).trimToSize();
                }
            });
            return result;
        }, GeneratorThreading.getRoomGeneratorExecutor());
    }

    private static <T> Collector<T, Map<SectionPos, List<T>>, Map<SectionPos, List<T>>> createParallelTileCollector() {
        return Collector.of(ConcurrentHashMap::new, (sectionMap, tileElement) -> {
            SectionPos sectionPosition = null;
            if (tileElement instanceof PartialTile) {
                sectionPosition = SectionPos.m_123199_((BlockPos)((PartialTile)tileElement).getPos());
            } else if (tileElement instanceof PartialEntity) {
                sectionPosition = SectionPos.m_123199_((BlockPos)((PartialEntity)tileElement).getBlockPos());
            }
            if (sectionPosition != null) {
                Map map = sectionMap;
                synchronized (map) {
                    sectionMap.computeIfAbsent(sectionPosition, key -> new ArrayList(4096)).add(tileElement);
                }
            }
        }, (firstMap, secondMap) -> {
            secondMap.forEach((sectionPosition, elementList) -> firstMap.merge(sectionPosition, elementList, (firstList, secondList) -> {
                firstList.addAll(secondList);
                return firstList;
            }));
            return firstMap;
        }, Function.identity(), Collector.Characteristics.IDENTITY_FINISH);
    }
}

