/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.key.TemplateKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.iterator.MappingIterator;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.template.data.TemplateEntry;
import iskallia.vault.core.world.template.data.TemplatePool;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class IndirectTemplateEntry
implements TemplateEntry {
    protected ResourceLocation reference;
    protected List<ResourceLocation> palettes;

    public IndirectTemplateEntry() {
        this(null, new ArrayList<ResourceLocation>());
    }

    public IndirectTemplateEntry(ResourceLocation reference, List<ResourceLocation> palettes) {
        this.reference = reference;
        this.palettes = new ArrayList<ResourceLocation>(palettes);
    }

    public ResourceLocation getReferenceId() {
        return this.reference;
    }

    public TemplatePoolKey getReference() {
        return VaultRegistry.TEMPLATE_POOL.getKey(this.reference);
    }

    @Override
    public TemplateKey getTemplate() {
        throw new UnsupportedOperationException("Indirect entry, flatten first");
    }

    @Override
    public Iterable<PaletteKey> getPalettes() {
        return () -> new MappingIterator<ResourceLocation, PaletteKey>(this.palettes.iterator(), id -> VaultRegistry.PALETTE.getKey((ResourceLocation)id));
    }

    @Override
    public void addPalettes(Iterable<ResourceLocation> palettes) {
        for (ResourceLocation palette : palettes) {
            this.palettes.add(palette);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.IDENTIFIER.writeBits(this.reference, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.palettes.size(), buffer);
        for (ResourceLocation palette : this.palettes) {
            Adapters.IDENTIFIER.writeBits(palette, buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.reference = Adapters.IDENTIFIER.readBits(buffer).orElseThrow();
        int size = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.palettes = new ArrayList<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            this.palettes.add(Adapters.IDENTIFIER.readBits(buffer).orElseThrow());
        }
    }

    @Override
    public Optional<Tag> writeNbt() {
        if (!this.palettes.isEmpty()) {
            CompoundTag nbt = new CompoundTag();
            Adapters.IDENTIFIER.writeNbt(this.reference).ifPresent(value -> nbt.m_128365_("id", value));
            ListTag list = new ListTag();
            for (ResourceLocation palette : this.palettes) {
                Adapters.IDENTIFIER.writeNbt(palette).ifPresent(arg_0 -> list.add(arg_0));
            }
            nbt.m_128365_("palettes", (Tag)list);
            return Optional.of(nbt);
        }
        return Adapters.IDENTIFIER.writeNbt(this.reference);
    }

    @Override
    public void readNbt(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            Adapters.IDENTIFIER.readNbt(compound.m_128423_("id")).ifPresent(value -> {
                this.reference = value;
            });
            if (!compound.m_128441_("palettes")) {
                return;
            }
            ListTag list = compound.m_128437_("palettes", 8);
            this.palettes = new ArrayList<ResourceLocation>();
            for (Tag tag : list) {
                Adapters.IDENTIFIER.readNbt(tag).ifPresent(this.palettes::add);
            }
        } else if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            this.reference = new ResourceLocation(string.m_7916_());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Optional<JsonElement> writeJson() {
        if (!this.palettes.isEmpty()) {
            JsonObject json = new JsonObject();
            Adapters.IDENTIFIER.writeJson(this.reference).ifPresent(element -> json.add("id", element));
            JsonArray array = new JsonArray();
            for (ResourceLocation palette : this.palettes) {
                Adapters.IDENTIFIER.writeJson(palette).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0));
            }
            json.add("palettes", (JsonElement)array);
            return Optional.of(json);
        }
        return Adapters.IDENTIFIER.writeJson(this.reference);
    }

    @Override
    public void readJson(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            Adapters.IDENTIFIER.readJson(object.get("id")).ifPresent(value -> {
                this.reference = value;
            });
            if (!object.has("palettes")) {
                return;
            }
            JsonArray array = object.getAsJsonArray("palettes");
            if (array == null) {
                return;
            }
            this.palettes = new ArrayList<ResourceLocation>();
            for (JsonElement element : array) {
                Adapters.IDENTIFIER.readJson(element).ifPresent(this.palettes::add);
            }
        } else if (json instanceof JsonPrimitive) {
            JsonPrimitive element = (JsonPrimitive)json;
            Adapters.IDENTIFIER.readJson((JsonElement)element).ifPresent(value -> {
                this.reference = value;
            });
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public TemplateEntry flatten(Version version, RandomSource random) {
        TemplateEntry flattened = ((TemplatePool)this.getReference().get(version)).getRandom(random).orElse(null);
        if (flattened == null) {
            return null;
        }
        flattened = flattened.copy().flatten(version, random);
        flattened.addPalettes(this.palettes);
        return flattened;
    }

    @Override
    public boolean validate() {
        return VaultRegistry.TEMPLATE_POOL.getKey(this.reference) != null;
    }

    @Override
    public TemplateEntry copy() {
        return new IndirectTemplateEntry(this.reference, new ArrayList<ResourceLocation>(this.palettes));
    }

    public String toString() {
        return "{reference=" + (this.reference == null ? "null" : this.reference.toString()) + "}";
    }
}

