/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template.tasks;

import iskallia.vault.VaultMod;
import iskallia.vault.core.world.template.tasks.BlocksToSectionTask;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class BlocksToProtoSectionTask
extends BlocksToSectionTask<ProtoChunk> {
    public BlocksToProtoSectionTask(ProtoChunk chunk) {
        super(chunk);
    }

    public static boolean isNearStarterRoom(BlockPos pos) {
        return pos.m_123341_() >= -70 && pos.m_123341_() <= 70 && pos.m_123343_() >= -70 && pos.m_123343_() <= 70;
    }

    public static boolean inStarterRoom(BlockPos p) {
        return p.m_123341_() >= 13 && p.m_123341_() <= 33 && p.m_123342_() >= 22 && p.m_123342_() <= 42 && p.m_123343_() >= 26 && p.m_123343_() <= 46 || p.m_123341_() >= 26 && p.m_123341_() <= 46 && p.m_123342_() >= 23 && p.m_123342_() <= 42 && p.m_123343_() >= 13 && p.m_123343_() <= 33;
    }

    @Override
    protected void typeSpecificStuff(boolean skipHeightmaps, BlockState newState, BlockState oldState, BlockPos position, LevelChunkSection section, List<Runnable> tasks) {
        if (position == null || newState == null || section == null || tasks == null) {
            VaultMod.LOGGER.info("Null parameters in BlocksToProtoSectionTask: pos={}, state={}, section={}, tasks={}", (Object)position, (Object)newState, (Object)section, tasks);
            return;
        }
        if (newState.m_155947_()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("x", position.m_123341_());
            compoundTag.m_128405_("y", position.m_123342_());
            compoundTag.m_128405_("z", position.m_123343_());
            compoundTag.m_128359_("id", "DUMMY");
            ((ProtoChunk)this.chunk).m_5604_(compoundTag);
        }
        if (!skipHeightmaps) {
            try {
                this.updateHeightmaps(position, newState);
            }
            catch (Exception e) {
                VaultMod.LOGGER.error("Error updating heightmaps at {}", (Object)position, (Object)e);
            }
        }
    }

    private void updateHeightmaps(BlockPos position, BlockState newState) {
        EnumSet requiredHeightmaps = ((ProtoChunk)this.chunk).m_6415_().m_62500_();
        if (requiredHeightmaps == null || requiredHeightmaps.isEmpty()) {
            return;
        }
        EnumSet<Heightmap.Types> missingHeightmaps = null;
        for (Heightmap.Types type : requiredHeightmaps) {
            boolean found = false;
            for (Map.Entry entry : ((ProtoChunk)this.chunk).m_6890_()) {
                if (entry.getKey() != type) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (missingHeightmaps == null) {
                missingHeightmaps = EnumSet.noneOf(Heightmap.Types.class);
            }
            missingHeightmaps.add(type);
        }
        if (missingHeightmaps != null) {
            Heightmap.m_64256_((ChunkAccess)this.chunk, missingHeightmaps);
        }
        int x = position.m_123341_() & 0xF;
        int y = position.m_123342_();
        int z = position.m_123343_() & 0xF;
        for (Map.Entry entry : ((ProtoChunk)this.chunk).m_6890_()) {
            if (!requiredHeightmaps.contains(entry.getKey()) || entry.getValue() == null) continue;
            ((Heightmap)entry.getValue()).m_64249_(x, y, z, newState);
        }
    }
}

