/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.template.tasks;

import iskallia.vault.core.world.template.tasks.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.ProtoChunk;

public abstract class BlocksToSectionTask<T extends ChunkAccess> {
    protected final T chunk;

    protected BlocksToSectionTask(T chunk) {
        this.chunk = chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockPos> setBlocks(int sectionIdx, List<Pair<BlockPos, BlockState>> blocks, boolean skipHeightmaps) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        int minY = this.chunk.m_141937_() + 16 * sectionIdx;
        int maxY = minY + 16;
        int minX = this.chunk.m_7697_().f_45578_ * 16;
        int maxX = minX + 16;
        int minZ = this.chunk.m_7697_().f_45579_ * 16;
        int maxZ = minZ + 16;
        LevelChunkSection section = this.chunk.m_183278_(sectionIdx);
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        try {
            PalettedContainer palettedContainer = section.m_63019_();
            synchronized (palettedContainer) {
                for (Pair<BlockPos, BlockState> entry : blocks) {
                    BlockPos position = entry.getFirst();
                    if (position == null) continue;
                    BlockState newState = entry.getSecond();
                    if (position.m_123341_() < minX || position.m_123341_() >= maxX || position.m_123343_() < minZ || position.m_123343_() >= maxZ || position.m_123342_() < minY || position.m_123342_() >= maxY) continue;
                    if (newState.getLightEmission(this.chunk, position) > 0 && this.chunk instanceof ProtoChunk) {
                        result.add(new BlockPos(position.m_123341_(), position.m_123342_(), position.m_123343_()));
                    }
                    BlockState oldState = section.m_62991_(position.m_123341_() & 0xF, position.m_123342_() & 0xF, position.m_123343_() & 0xF, newState, false);
                    if (!newState.m_155947_() && oldState.m_155947_()) {
                        this.chunk.m_8114_(position);
                    }
                    this.typeSpecificStuff(skipHeightmaps, newState, oldState, position, section, tasks);
                }
            }
        }
        finally {
            section.m_63006_();
            for (Runnable task : tasks) {
                task.run();
            }
        }
        return result.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected abstract void typeSpecificStuff(boolean var1, BlockState var2, BlockState var3, BlockPos var4, LevelChunkSection var5, List<Runnable> var6);
}

