/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.discoverylogic;

import iskallia.vault.discoverylogic.goal.base.DiscoveryGoal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.INBTSerializable;

public class DiscoveryGoalsState
implements INBTSerializable<CompoundTag> {
    protected UUID playerUuid;
    protected Set<ResourceLocation> completedGoals;
    protected Map<ResourceLocation, Float> ongoingGoals;

    public DiscoveryGoalsState(ServerPlayer serverPlayer) {
        this(serverPlayer.m_142081_());
    }

    public DiscoveryGoalsState(UUID playerUuid) {
        this.playerUuid = playerUuid;
        this.completedGoals = new HashSet<ResourceLocation>();
        this.ongoingGoals = new HashMap<ResourceLocation, Float>();
    }

    public float getProcess(DiscoveryGoal<?> goal) {
        return this.ongoingGoals.getOrDefault(goal.getId(), Float.valueOf(0.0f)).floatValue();
    }

    public void setProgress(ServerPlayer player, DiscoveryGoal<?> goal, float progress) {
        ResourceLocation goalId = goal.getId();
        if (this.completedGoals.contains(goalId)) {
            return;
        }
        this.ongoingGoals.put(goalId, Float.valueOf(progress));
        if (progress >= goal.getTargetProgress()) {
            goal.onGoalAchieved(player);
            this.ongoingGoals.remove(goalId);
            this.completedGoals.add(goalId);
        }
    }

    public void progress(ServerPlayer player, DiscoveryGoal<?> goal, float deltaProgress) {
        ResourceLocation goalId = goal.getId();
        if (this.completedGoals.contains(goalId)) {
            return;
        }
        float progress = this.ongoingGoals.merge(goalId, Float.valueOf(deltaProgress), Float::sum).floatValue();
        if (progress >= goal.getTargetProgress()) {
            goal.onGoalAchieved(player);
            this.ongoingGoals.remove(goalId);
            this.completedGoals.add(goalId);
        }
    }

    public void resetGoal(ResourceLocation goalId) {
        this.ongoingGoals.computeIfPresent(goalId, (id, progress) -> Float.valueOf(0.0f));
    }

    public void resetGoalIf(Predicate<ResourceLocation> predicate) {
        this.ongoingGoals.keySet().stream().filter(predicate).toList().forEach(this.ongoingGoals::remove);
    }

    public void deleteCompletions() {
        this.completedGoals.clear();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag completedGoalsTag = new ListTag();
        this.completedGoals.forEach(goalId -> completedGoalsTag.add((Object)StringTag.m_129297_((String)goalId.toString())));
        nbt.m_128365_("CompletedGoals", (Tag)completedGoalsTag);
        ListTag ongoingGoalKeys = new ListTag();
        ListTag ongoingGoalValues = new ListTag();
        this.ongoingGoals.forEach((goalId, progress) -> {
            ongoingGoalKeys.add((Object)StringTag.m_129297_((String)goalId.toString()));
            ongoingGoalValues.add((Object)FloatTag.m_128566_((float)progress.floatValue()));
        });
        nbt.m_128365_("OngoingGoalKeys", (Tag)ongoingGoalKeys);
        nbt.m_128365_("OngoingGoalValues", (Tag)ongoingGoalValues);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.completedGoals.clear();
        this.ongoingGoals.clear();
        ListTag completedGoalsTag = nbt.m_128437_("CompletedGoals", 8);
        for (int i = 0; i < completedGoalsTag.size(); ++i) {
            ResourceLocation goalId = ResourceLocation.m_135820_((String)completedGoalsTag.m_128778_(i));
            this.completedGoals.add(goalId);
        }
        ListTag ongoingGoalKeys = nbt.m_128437_("OngoingGoalKeys", 8);
        ListTag ongoingGoalValues = nbt.m_128437_("OngoingGoalValues", 5);
        for (int i = 0; i < ongoingGoalKeys.size(); ++i) {
            ResourceLocation goalId = ResourceLocation.m_135820_((String)ongoingGoalKeys.m_128778_(i));
            float progress = ongoingGoalValues.m_128775_(i);
            this.ongoingGoals.put(goalId, Float.valueOf(progress));
        }
    }
}

