/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.discoverylogic.goal.base;

import iskallia.vault.discoverylogic.DiscoveryGoalsState;
import iskallia.vault.world.data.DiscoveryGoalStatesData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public abstract class DiscoveryGoal<G extends DiscoveryGoal<G>> {
    protected ResourceLocation id;
    protected RewardGranter<G> reward;
    protected float targetProgress;

    public DiscoveryGoal(float targetProgress) {
        this.targetProgress = targetProgress;
    }

    protected G getSelf() {
        DiscoveryGoal g = this;
        return (G)g;
    }

    public G setReward(RewardGranter<G> reward) {
        this.reward = reward;
        return this.getSelf();
    }

    public void onGoalAchieved(ServerPlayer player) {
        if (this.reward != null) {
            this.reward.grant(player, this.getSelf());
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        if (this.id != null) {
            throw new IllegalStateException();
        }
        this.id = id;
    }

    public float getCurrentProgress(ServerPlayer player) {
        DiscoveryGoalStatesData worldData = DiscoveryGoalStatesData.get(player.m_183503_());
        DiscoveryGoalsState state = worldData.getState(player);
        return state.getProcess(this);
    }

    public float getTargetProgress() {
        return this.targetProgress;
    }

    public void resetProgress(ServerPlayer player) {
        DiscoveryGoalStatesData worldData = DiscoveryGoalStatesData.get(player.m_183503_());
        DiscoveryGoalsState state = worldData.getState(player);
        state.resetGoal(this.getId());
        worldData.m_77762_();
    }

    public void progress(ServerPlayer player, float deltaProgress) {
        DiscoveryGoalStatesData worldData = DiscoveryGoalStatesData.get(player.m_183503_());
        DiscoveryGoalsState state = worldData.getState(player);
        state.progress(player, this, deltaProgress);
        worldData.m_77762_();
    }

    public void setProgress(ServerPlayer player, float progress) {
        DiscoveryGoalStatesData worldData = DiscoveryGoalStatesData.get(player.m_183503_());
        DiscoveryGoalsState state = worldData.getState(player);
        state.setProgress(player, this, progress);
        worldData.m_77762_();
    }

    @FunctionalInterface
    public static interface RewardGranter<G extends DiscoveryGoal<G>> {
        public void grant(ServerPlayer var1, G var2);
    }
}

