/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.dump;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.StatUtils;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.util.calc.AttributeLimitHelper;
import iskallia.vault.util.calc.BlockChanceHelper;
import iskallia.vault.util.calc.CooldownHelper;
import iskallia.vault.util.calc.LuckyHitHelper;
import iskallia.vault.util.calc.PlayerStatisticsCollector;
import iskallia.vault.util.calc.SoulChanceHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerPrestigePowersData;
import iskallia.vault.world.data.PlayerReputationData;
import iskallia.vault.world.data.PlayerResearchesData;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.SkillAltarData;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;

public class PlayerSnapshotDump {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static String createAndSerializeSnapshot(ServerPlayer sPlayer) {
        return GSON.toJson((Object)PlayerSnapshotDump.createSnapshot(sPlayer));
    }

    public static PlayerSnapshot createSnapshot(ServerPlayer player) {
        PlayerSnapshot snapshot = new PlayerSnapshot(player);
        ServerLevel world = player.m_183503_();
        snapshot.version = 1;
        PlayerVaultStats stats = PlayerVaultStatsData.get(world).getVaultStats((Player)player);
        snapshot.vaultLevel = stats.getVaultUncappedLevel();
        snapshot.levelPercent = (float)stats.getExp() / (float)stats.getExpNeededToNextLevel();
        AttributeMap mgr = player.m_21204_();
        for (Attribute attribute : ForgeRegistries.ATTRIBUTES) {
            if (!mgr.m_22171_(attribute)) continue;
            ResourceLocation attrId = attribute.getRegistryName();
            snapshot.vanillaAttributes.put(attrId == null ? attribute.m_22087_() : attrId.toString(), mgr.m_22181_(attribute));
        }
        AttributeSnapshot attributeSnapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        snapshot.putGearAttribute(ModGearAttributes.ABILITY_POWER, () -> Float.valueOf(AbilityPowerHelper.getAbilityPower((Player)player)));
        snapshot.putGearAttribute(ModGearAttributes.HEALING_EFFECTIVENESS, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.COOLDOWN_REDUCTION, () -> Float.valueOf(CooldownHelper.getCooldownMultiplier((LivingEntity)player)));
        snapshot.putGearAttribute(ModGearAttributes.RESISTANCE, () -> Float.valueOf(AttributeLimitHelper.getResistanceLimit((LivingEntity)player)));
        snapshot.putGearAttribute(ModGearAttributes.BLOCK, () -> Float.valueOf(BlockChanceHelper.getBlockChance((LivingEntity)player)));
        snapshot.putGearAttribute(ModGearAttributes.CRITICAL_HIT_TAKEN_REDUCTION, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.DURABILITY_WEAR_REDUCTION, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.THORNS_DAMAGE_FLAT, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.ON_HIT_CHAIN, VaultGearAttributeTypeMerger.intSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.ON_HIT_STUN, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.SHOCKING_HIT_CHANCE, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.SWEEPING_HIT_CHANCE, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.ITEM_QUANTITY, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.ITEM_RARITY, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.TRAP_DISARMING, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.COPIOUSLY, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.MINING_SPEED, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.SOUL_QUANTITY, () -> Float.valueOf(SoulChanceHelper.getSoulChance((LivingEntity)player)));
        snapshot.putGearAttribute(ModGearAttributes.LUCKY_HIT_CHANCE, () -> Float.valueOf(LuckyHitHelper.getLuckyHitChance((LivingEntity)player)));
        snapshot.putGearAttribute(ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.DAMAGE_ILLAGERS, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.DAMAGE_SPIDERS, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.DAMAGE_UNDEAD, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.putGearAttribute(ModGearAttributes.DAMAGE_NETHER, VaultGearAttributeTypeMerger.floatSum(), attributeSnapshot);
        snapshot.summaryAttributes.put("dps", (JsonElement)new JsonPrimitive((Number)StatUtils.getAverageDps((Player)player)));
        snapshot.summaryAttributes.put("defense", (JsonElement)new JsonPrimitive((Number)StatUtils.getDefence((Player)player)));
        Arrays.stream(EquipmentSlot.values()).forEach(slotType -> {
            ItemStack stack = player.m_6844_(slotType);
            if (!stack.m_41619_()) {
                snapshot.equipment.put(slotType.name(), new SerializableItemStack(stack));
            }
        });
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            for (String slot : Arrays.asList("charm", "blue_trinket", "red_trinket", "belt", "necklace")) {
                handler.getStacksHandler(slot).ifPresent(stackHandler -> {
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStacks().getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        snapshot.equipment.put(slot + (String)(i == 0 ? "" : "_" + i), new SerializableItemStack(stack));
                    }
                });
            }
        });
        PlayerAbilitiesData.get(world).getAbilities((Player)player).iterate(Skill.class, skill -> {
            if (skill.isUnlocked() && skill instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)skill;
                if (skill.getId() != null) {
                    snapshot.abilities.put(tiered.getId(), tiered.getUnmodifiedTier());
                }
            }
        });
        PlayerTalentsData.get(world).getTalents((Player)player).iterate(Skill.class, skill -> {
            if (skill.isUnlocked() && skill instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)skill;
                if (skill.getId() != null) {
                    snapshot.talents.put(skill.getId(), tiered.getUnmodifiedTier());
                }
            }
        });
        PlayerPrestigePowersData.get(world).getPowers((Player)player).iterate(Skill.class, skill -> {
            if (skill.isUnlocked() && skill instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)skill;
                if (skill.getId() != null) {
                    snapshot.abilities.put(skill.getId(), tiered.getUnmodifiedTier());
                }
            }
        });
        PlayerExpertisesData.get(world).getExpertises((Player)player).iterate(Skill.class, skill -> {
            if (skill.isUnlocked() && skill instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)skill;
                if (skill.getId() != null) {
                    snapshot.expertises.put(skill.getId(), tiered.getUnmodifiedTier());
                }
            }
        });
        ResearchTree researches = PlayerResearchesData.get(world).getResearches((Player)player);
        snapshot.researches.addAll(researches.getResearchesDone());
        SkillAltarData.get(world).getSkillTemplates(player.m_142081_()).forEach((index, template) -> {
            JsonObject object = new JsonObject();
            JsonObject icon = new JsonObject();
            icon.addProperty("key", template.getIcon().key());
            icon.addProperty("isTalent", Boolean.valueOf(template.getIcon().isTalent()));
            object.add("icon", (JsonElement)icon);
            JsonObject abilities = new JsonObject();
            template.getAbilities().iterate(Skill.class, skill -> {
                if (skill.isUnlocked() && skill instanceof TieredSkill) {
                    TieredSkill tiered = (TieredSkill)skill;
                    if (skill.getId() != null) {
                        abilities.addProperty(skill.getId(), (Number)tiered.getUnmodifiedTier());
                    }
                }
            });
            JsonObject talents = new JsonObject();
            template.getTalents().iterate(Skill.class, skill -> {
                if (skill.isUnlocked() && skill instanceof TieredSkill) {
                    TieredSkill tiered = (TieredSkill)skill;
                    if (skill.getId() != null) {
                        talents.addProperty(skill.getId(), (Number)tiered.getUnmodifiedTier());
                    }
                }
            });
            object.add("abilities", (JsonElement)abilities);
            object.add("talents", (JsonElement)talents);
            snapshot.skillTemplates.add(object);
        });
        PlayerStatisticsCollector.VaultRunsSnapshot vaultRunsSnapshot = PlayerStatisticsCollector.VaultRunsSnapshot.ofPlayer(player);
        snapshot.completed = vaultRunsSnapshot.completed;
        snapshot.survived = vaultRunsSnapshot.survived;
        snapshot.failed = vaultRunsSnapshot.failed;
        for (VaultGod type : VaultGod.values()) {
            snapshot.reputation.put(type.getName(), PlayerReputationData.getReputation(player.m_142081_(), type));
        }
        return snapshot;
    }

    public static class PlayerSnapshot {
        protected int version;
        protected final UUID playerUUID;
        protected final String playerNickname;
        protected final long timestamp;
        protected int completed;
        protected int survived;
        protected int failed;
        protected int vaultLevel = 0;
        protected float levelPercent = 0.0f;
        protected Map<String, Double> vanillaAttributes = new LinkedHashMap<String, Double>();
        protected Map<String, JsonElement> gearAttributes = new LinkedHashMap<String, JsonElement>();
        protected Map<String, JsonElement> summaryAttributes = new LinkedHashMap<String, JsonElement>();
        protected Map<String, Integer> reputation = new LinkedHashMap<String, Integer>();
        protected Map<String, SerializableItemStack> equipment = new LinkedHashMap<String, SerializableItemStack>();
        protected Map<String, Integer> abilities = new LinkedHashMap<String, Integer>();
        protected Map<String, Integer> talents = new LinkedHashMap<String, Integer>();
        protected Map<String, Integer> expertises = new LinkedHashMap<String, Integer>();
        protected Set<String> researches = new LinkedHashSet<String>();
        protected List<JsonObject> skillTemplates = new ArrayList<JsonObject>();

        public PlayerSnapshot(ServerPlayer playerEntity) {
            this.playerUUID = playerEntity.m_142081_();
            this.playerNickname = playerEntity.m_7755_().getString();
            this.timestamp = Instant.now().getEpochSecond();
        }

        public <V extends Comparable<V>> void putGearAttribute(VaultGearAttribute<V> attribute, Supplier<V> valueSupplier) {
            this.gearAttributes.put(attribute.getRegistryName().toString(), attribute.getType().serialize((Comparable)valueSupplier.get()));
        }

        public <V extends Comparable<V>> void putGearAttribute(VaultGearAttribute<V> attribute, VaultGearAttributeTypeMerger<V, V> merger, AttributeSnapshot snapshot) {
            this.putGearAttribute(attribute, () -> (Comparable)snapshot.getAttributeValue(attribute, merger));
        }
    }

    public static class SerializableItemStack {
        private final String itemKey;
        private final int count;
        private final String nbt;
        private final String gearData;

        private SerializableItemStack(ItemStack stack) {
            this.itemKey = stack.m_41720_().getRegistryName().toString();
            this.count = stack.m_41613_();
            this.nbt = stack.m_41782_() ? stack.m_41783_().toString() : null;
            this.gearData = VaultGearItem.serializeGearData(stack).toString();
        }
    }
}

