/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.dynamodel;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.dynamodel.DynamicModelProperties;
import iskallia.vault.dynamodel.model.item.shield.ShieldModel;
import iskallia.vault.init.ModDynamicModels;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.SimpleModelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicModel<M extends DynamicModel<M>> {
    protected final ResourceLocation id;
    protected final String displayName;
    protected DynamicModelProperties modelProperties = new DynamicModelProperties();

    public DynamicModel(ResourceLocation id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DynamicModelProperties getModelProperties() {
        return this.modelProperties;
    }

    public M properties(DynamicModelProperties modelProperties) {
        this.modelProperties = modelProperties;
        DynamicModel model = this;
        return (M)model;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Set<ModelResourceLocation> getAssociatedModelLocations() {
        return Collections.singleton(new ModelResourceLocation(this.getId(), "inventory"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation resolveBakedIcon(@NotNull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
        return this.getId();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Map<String, ResourceLocation> resolveTextures(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        ShieldModel shieldModel;
        ResourceLocation blockingModelId;
        ResourceLocation blockingModelPath;
        Object reader;
        HashMap<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
        ResourceLocation modelPath = new ResourceLocation(resourceLocation.m_135827_(), "models/" + resourceLocation.m_135815_() + ".json");
        boolean texturesFound = false;
        if (resourceManager.m_7165_(modelPath)) {
            try {
                Resource resource = resourceManager.m_142591_(modelPath);
                reader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);
                try {
                    JsonObject jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                    if (jsonObject.has("textures")) {
                        JsonObject texturesObj = jsonObject.getAsJsonObject("textures");
                        for (Map.Entry entry : texturesObj.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = ((JsonElement)entry.getValue()).getAsString();
                            textures.put(key, new ResourceLocation(value));
                        }
                        texturesFound = true;
                    }
                }
                finally {
                    ((InputStreamReader)reader).close();
                }
            }
            catch (Exception resource) {
                // empty catch block
            }
        }
        if ((reader = this) instanceof ShieldModel && resourceManager.m_7165_(blockingModelPath = new ResourceLocation((blockingModelId = (shieldModel = (ShieldModel)reader).getBlockingModelId()).m_135827_(), "models/item/" + blockingModelId.m_135815_() + ".json"))) {
            try {
                Resource blockingResource = resourceManager.m_142591_(blockingModelPath);
                try (InputStreamReader reader2 = new InputStreamReader(blockingResource.m_6679_(), StandardCharsets.UTF_8);){
                    JsonObject jsonObject = (JsonObject)new Gson().fromJson((Reader)reader2, JsonObject.class);
                    if (jsonObject.has("textures")) {
                        JsonObject texturesObj = jsonObject.getAsJsonObject("textures");
                        for (Map.Entry entry : texturesObj.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = ((JsonElement)entry.getValue()).getAsString();
                            if (textures.containsKey(key)) continue;
                            textures.put(key, new ResourceLocation(value));
                        }
                        texturesFound = true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!texturesFound) {
            textures.put("layer0", ModDynamicModels.textureExists(resourceManager, resourceLocation) ? resourceLocation : ModDynamicModels.EMPTY_TEXTURE);
            if (ModDynamicModels.textureExists(resourceManager, DynamicModel.appendToId(resourceLocation, "_overlay"))) {
                textures.put("layer1", DynamicModel.appendToId(resourceLocation, "_overlay"));
            }
            for (int i = 0; i < 10; ++i) {
                if (!ModDynamicModels.textureExists(resourceManager, DynamicModel.appendToId(resourceLocation, "_layer" + i))) continue;
                textures.put("layer" + i, DynamicModel.appendToId(resourceLocation, "_layer" + i));
            }
        }
        return textures;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockModel generateItemModel(Map<String, ResourceLocation> textures) {
        String jsonPattern = "{  \"parent\": \"item/generated\",  \"textures\": {{textures}},  \"display\": {    \"thirdperson_lefthand\": {      \"rotation\": [0.0, 0.0, 0.0],      \"translation\": [0.0, 0.1875, 0.0625],      \"scale\": [0.55, 0.55, 0.55]    },    \"thirdperson_righthand\": {      \"rotation\": [0.0, 0.0, 0.0],      \"translation\": [0.0, 0.1875, 0.0625],      \"scale\": [0.55, 0.55, 0.55]    },    \"firstperson_lefthand\": {      \"rotation\": [0.0, -90.0, 25.0],      \"translation\": [0.070625, 0.2, 0.070625],      \"scale\": [0.68, 0.68, 0.68]    },    \"firstperson_righthand\": {      \"rotation\": [0.0, -90.0, 25.0],      \"translation\": [0.070625, 0.2, 0.070625],      \"scale\": [0.68, 0.68, 0.68]    },    \"head\": {      \"rotation\": [0, 180, 0],      \"translation\": [0.0, 0.8125, 0.4375],      \"scale\": [1, 1, 1]    },    \"gui\": {      \"rotation\": [0, 0, 0],      \"translation\": [0, 0, 0],      \"scale\": [1, 1, 1]    },    \"ground\": {      \"rotation\": [0, 0, 0],      \"translation\": [0.0, 0.125, 0.0],      \"scale\": [0.5, 0.5, 0.5]    },    \"fixed\": {      \"rotation\": [0.0, 180.0, 0.0],      \"translation\": [0.0, 0.0, 0.0],      \"scale\": [0.5, 0.5, 0.5]    }  }}";
        return this.createUnbakedModel(jsonPattern, textures);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected BlockModel createUnbakedModel(String jsonPattern, Map<String, ResourceLocation> textures) {
        String texturesJson = textures.entrySet().stream().map(entry -> "\"" + (String)entry.getKey() + "\": \"" + String.valueOf(entry.getValue()) + "\"").collect(Collectors.joining(", ", "{", "}"));
        String modelJson = jsonPattern.replace("{{textures}}", texturesJson);
        return BlockModel.m_111463_((String)modelJson);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BakedModel bakeModel(ModelResourceLocation modelLocation, ForgeModelBakery modelLoader, BlockModel unbakedModel) {
        BlockModel itemModel = new ItemModelGenerator().m_111670_(ForgeModelBakery.defaultTextureGetter(), unbakedModel);
        return itemModel.m_111449_((ModelBakery)modelLoader, itemModel, ForgeModelBakery.defaultTextureGetter(), (ModelState)SimpleModelState.IDENTITY, (ResourceLocation)modelLocation, false);
    }

    public static ResourceLocation appendToId(ResourceLocation id, String append) {
        return new ResourceLocation(id.m_135827_(), id.m_135815_() + append);
    }

    public static ResourceLocation prependToId(String prepend, ResourceLocation id) {
        return new ResourceLocation(id.m_135827_(), prepend + id.m_135815_());
    }

    public static ResourceLocation removePrefixFromId(String prefix, ResourceLocation id) {
        if (id.m_135815_().startsWith(prefix)) {
            return new ResourceLocation(id.m_135827_(), id.m_135815_().replaceFirst(prefix, ""));
        }
        return id;
    }
}

