/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.dynamodel.model.item.shield;

import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.util.calc.BlockChanceHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShieldModel
extends DynamicModel<ShieldModel> {
    protected ResourceLocation blockingModelId = ShieldModel.appendToId(this.getId(), "_blocking");

    public ShieldModel(ResourceLocation id, String displayName) {
        super(id, displayName);
    }

    public ResourceLocation getBlockingModelId() {
        return this.blockingModelId;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Set<ModelResourceLocation> getAssociatedModelLocations() {
        HashSet<ModelResourceLocation> locations = new HashSet<ModelResourceLocation>(super.getAssociatedModelLocations());
        locations.add(new ModelResourceLocation(this.blockingModelId, "inventory"));
        return locations;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation resolveBakedIcon(@NotNull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
        LocalPlayer player;
        if (entity instanceof LocalPlayer && BlockChanceHelper.isPlayerBlocking((Player)(player = (LocalPlayer)entity))) {
            return this.blockingModelId;
        }
        return super.resolveBakedIcon(stack, world, entity, seed);
    }

    public void onBlocked(LivingEntity attacked, DamageSource damageSource) {
    }
}

