/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.effect;

import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.mana.Mana;
import iskallia.vault.mana.ManaAction;
import iskallia.vault.network.message.ClientboundPlayerLastDamageSourceMessage;
import iskallia.vault.util.damage.DamageUtil;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;

public class PoisonOverrideEffect
extends MobEffect {
    private static final Map<UUID, UUID> poisonSources = new HashMap<UUID, UUID>();

    public PoisonOverrideEffect() {
        super(MobEffectCategory.HARMFUL, 5149489);
        this.setRegistryName(new ResourceLocation("minecraft", "poison"));
    }

    public static void registerSource(LivingEntity target, Entity source) {
        if (source != null) {
            poisonSources.put(target.m_142081_(), source.m_142081_());
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Entity sourceEntity;
        MobEffectInstance instance = entity.m_21124_(MobEffects.f_19614_);
        if (instance == null) {
            return;
        }
        int duration = instance.m_19557_();
        UUID sourceId = poisonSources.get(entity.m_142081_());
        DamageSource source = sourceId != null && entity.f_19853_ instanceof ServerLevel ? ((sourceEntity = ((ServerLevel)entity.f_19853_).m_8791_(sourceId)) instanceof ServerPlayer ? DamageSource.m_19344_((Player)((ServerPlayer)sourceEntity)) : (sourceEntity != null ? DamageSource.m_19370_((LivingEntity)((LivingEntity)sourceEntity)) : DamageSource.f_19319_)) : DamageSource.f_19319_;
        if (ServerVaults.get(entity.f_19853_).isEmpty()) {
            int tickPart = 25 >> amplifier;
            boolean doEffect = true;
            if (tickPart > 0) {
                boolean bl = doEffect = duration % tickPart == 0;
            }
            if (doEffect && entity.m_21223_() > 1.0f) {
                Runnable damageTask = () -> {
                    entity.m_6469_(source, 1.0f);
                    if (!entity.f_19853_.f_46443_ && entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        ModNetwork.CHANNEL.sendTo((Object)new ClientboundPlayerLastDamageSourceMessage(DamageSource.f_19319_), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    }
                };
                if (source.m_7639_() instanceof ServerPlayer) {
                    ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_EFFECT_ATTACKING.runIfNotSet(damageTask));
                } else {
                    ActiveFlags.IS_EFFECT_ATTACKING.runIfNotSet(damageTask);
                }
            }
            if (duration <= 1) {
                poisonSources.remove(entity.m_142081_());
            }
            return;
        }
        if (duration % 20 == 0) {
            DamageSource finalSource = source;
            Runnable damageTask = () -> ActiveFlags.IS_EFFECT_ATTACKING.runIfNotSet(() -> DamageUtil.shotgunAttack(entity, e -> {
                Entity patt4568$temp;
                ServerPlayer player;
                e.m_6469_(finalSource, (float)(amplifier + 1));
                if (!e.f_19853_.f_46443_ && e instanceof ServerPlayer) {
                    player = (ServerPlayer)e;
                    ModNetwork.CHANNEL.sendTo((Object)new ClientboundPlayerLastDamageSourceMessage(DamageSource.f_19319_), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                if ((patt4568$temp = finalSource.m_7639_()) instanceof ServerPlayer) {
                    player = (ServerPlayer)patt4568$temp;
                    EtchingHelper.getEtchings((LivingEntity)player, EtchingGearAttributes.POISON_MANA).stream().findFirst().ifPresent(stack -> {
                        int mana = (Integer)stack.getValue();
                        Mana.increase((Player)player, ManaAction.PLAYER_ACTION, mana);
                    });
                }
            }));
            if (source.m_7639_() instanceof ServerPlayer) {
                ActiveFlags.IS_AP_ATTACKING.runIfNotSet(damageTask);
            } else {
                damageTask.run();
            }
        }
        if (duration <= 1) {
            poisonSources.remove(entity.m_142081_());
        }
    }
}

