/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity;

import iskallia.vault.block.SurgeBlock;
import iskallia.vault.client.gui.helper.Easing;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.network.NetworkHooks;

public class EarthSurgeEntity
extends Entity {
    @Nullable
    private UUID ownerUUID;
    private int minRadius;
    private int maxRadius;
    private float currentRadius;
    private float maxDamage;
    private float minDamage;
    private float speedMultiplier;
    private float speed = 0.5f;
    private final List<Vec2> targetVectors = new ArrayList<Vec2>();
    private int maxYOffset = 2;

    public EarthSurgeEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public EarthSurgeEntity(Level pLevel, UUID ownerUUID, int minRadius, int maxRadius, float minDamage, float maxDamage, float speedMultiplier) {
        this(ModEntities.EARTH_SURGE, pLevel);
        this.ownerUUID = ownerUUID;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
        this.speedMultiplier = speedMultiplier;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (this.targetVectors.isEmpty()) {
            LivingEntity owner = this.getOwner();
            if (owner == null) {
                this.m_146870_();
                return;
            }
            this.f_19853_.m_6443_(LivingEntity.class, this.m_142469_().m_82400_((double)(this.maxRadius + 5)), arg_0 -> ((LivingEntity)owner).m_6779_(arg_0)).forEach(entity -> {
                Vec2 vec = new Vec2((float)(entity.m_20185_() - this.m_20185_()), (float)(entity.m_20189_() - this.m_20189_())).m_165902_();
                this.targetVectors.add(vec);
            });
        }
        if (this.currentRadius < (float)this.minRadius) {
            this.currentRadius = this.minRadius;
        }
        float nextRadius = this.currentRadius + this.speed;
        float currentDamage = this.calculateCurrentDamage();
        float currentSurgeRatio = Easing.waveCalc(0.1f + (this.currentRadius - (float)this.minRadius) / (float)(this.maxRadius - this.minRadius) * 0.9f, 0.3f, Easing.EASE_OUT_CUBIC, Easing.EASE_OUT_SINE);
        int x = (int)(-nextRadius);
        while ((float)x <= nextRadius) {
            int z = (int)(-nextRadius);
            while ((float)z <= nextRadius) {
                double dist = Math.sqrt(x * x + z * z);
                if (!(dist < (double)this.currentRadius) && !(dist >= (double)nextRadius) && this.closeToTargetVector(x, z)) {
                    BlockPos pos;
                    for (int yOffset = -this.maxYOffset; yOffset <= this.maxYOffset && !this.tryChangeToSurgeBlock(pos = new BlockPos(this.m_20185_() + (double)x, this.m_20186_() - 1.0 + (double)yOffset, this.m_20189_() + (double)z), currentDamage, currentSurgeRatio); ++yOffset) {
                    }
                }
                ++z;
            }
            ++x;
        }
        this.currentRadius = nextRadius;
        this.speed *= this.speedMultiplier;
        if (this.currentRadius > (float)this.maxRadius) {
            this.m_146870_();
        }
    }

    private boolean tryChangeToSurgeBlock(BlockPos pos, float currentDamage, float currentSurgeRatio) {
        BlockState state = this.m_183503_().m_8055_(pos);
        BlockState stateAbove = this.m_183503_().m_8055_(pos.m_7494_());
        if (!state.m_60795_() && (stateAbove.m_60795_() || stateAbove.m_60767_().m_76336_()) && !(state.m_60734_() instanceof EntityBlock) && state.m_60734_() != ModBlocks.SURGE_BLOCK) {
            this.m_183503_().m_7731_(pos, ModBlocks.SURGE_BLOCK.m_49966_(), this.minRadius);
            SurgeBlock.setData((BlockGetter)this.m_183503_(), pos, this.ownerUUID, state, currentDamage, currentSurgeRatio);
            return true;
        }
        return false;
    }

    @Nullable
    private LivingEntity getOwner() {
        Level level;
        if (this.ownerUUID == null || !((level = this.f_19853_) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (LivingEntity)serverLevel.m_8791_(this.ownerUUID);
    }

    private boolean closeToTargetVector(int x, int z) {
        for (Vec2 targetVector : this.targetVectors) {
            float angle = (float)Math.abs(Math.toDegrees(Math.atan2(targetVector.f_82471_, targetVector.f_82470_) - Math.atan2(z, x)));
            if (!(angle < 15.0f)) continue;
            return true;
        }
        return false;
    }

    private float calculateCurrentDamage() {
        return this.minDamage + (1.0f - (this.currentRadius - (float)this.minRadius) / (float)this.maxRadius) * (this.maxDamage - this.minDamage);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        this.ownerUUID = tag.m_128403_("OwnerUUID") ? tag.m_128342_("OwnerUUID") : null;
        this.currentRadius = tag.m_128457_("CurrentRadius");
        this.minRadius = tag.m_128451_("MinRadius");
        this.maxRadius = tag.m_128451_("MaxRadius");
        this.minDamage = tag.m_128457_("MinDamage");
        this.maxDamage = tag.m_128457_("MaxDamage");
        ListTag targetVectorsTag = tag.m_128437_("TargetVectors", 10);
        targetVectorsTag.forEach(vecTag -> {
            CompoundTag vecCompound = (CompoundTag)vecTag;
            this.targetVectors.add(new Vec2(vecCompound.m_128457_("X"), vecCompound.m_128457_("Y")));
        });
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.ownerUUID != null) {
            tag.m_128362_("OwnerUUID", this.ownerUUID);
        }
        tag.m_128350_("CurrentRadius", this.currentRadius);
        tag.m_128405_("MinRadius", this.minRadius);
        tag.m_128405_("MaxRadius", this.maxRadius);
        tag.m_128350_("MinDamage", this.minDamage);
        tag.m_128350_("MaxDamage", this.maxDamage);
        ListTag targetVectorsTag = new ListTag();
        this.targetVectors.forEach(vec -> {
            CompoundTag vecTag = new CompoundTag();
            vecTag.m_128350_("X", vec.f_82470_);
            vecTag.m_128350_("Y", vec.f_82471_);
            targetVectorsTag.add((Object)vecTag);
        });
        tag.m_128365_("TargetVectors", (Tag)targetVectorsTag);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

