/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LongJumpMidJump;
import net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PrepareRamNearestTarget;
import net.minecraft.world.entity.ai.behavior.RamTarget;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AggressiveGoatAi {
    private static final UniformInt NO_COOLDOWN = UniformInt.m_146622_((int)0, (int)0);
    private static final TargetingConditions PLAYER_RAM_TARGET = TargetingConditions.m_148352_().m_26883_(32.0).m_26888_(AggressiveGoatAi::isPlayerTargetable);

    private AggressiveGoatAi() {
    }

    public static Brain<?> makeBrain(Brain<Goat> brain) {
        AggressiveGoatAi.initCoreActivity(brain);
        AggressiveGoatAi.initIdleActivity(brain);
        AggressiveGoatAi.initLongJumpActivity(brain);
        AggressiveGoatAi.initRamActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_150240_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Goat> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<Goat> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(entity -> entity instanceof Player, 12.0f), UniformInt.m_146622_((int)20, (int)40))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new RandomStroll(1.2f), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(1.25f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(20, 40), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148203_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initLongJumpActivity(Brain<Goat> brain) {
        brain.m_21903_(Activity.f_150239_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new LongJumpMidJump(NO_COOLDOWN, SoundEvents.f_144151_)), (Object)Pair.of((Object)1, (Object)new LongJumpToRandomPos(NO_COOLDOWN, 5, 5, 1.5f, goat -> goat.m_149397_() ? SoundEvents.f_144147_ : SoundEvents.f_144167_))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148199_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initRamActivity(Brain<Goat> brain) {
        brain.m_21903_(Activity.f_150240_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RamTarget(goat -> NO_COOLDOWN, PLAYER_RAM_TARGET, 3.0f, goat -> goat.m_6162_() ? 1.0 : 2.5, goat -> goat.m_149397_() ? SoundEvents.f_144150_ : SoundEvents.f_144170_)), (Object)Pair.of((Object)1, (Object)new PrepareRamNearestTarget(goat -> 0, 4, 7, 1.35f, PLAYER_RAM_TARGET, 20, goat -> goat.m_149397_() ? SoundEvents.f_144149_ : SoundEvents.f_144169_))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(Goat goat) {
        goat.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_150240_, (Object)Activity.f_150239_, (Object)Activity.f_37979_));
    }

    public static Ingredient getTemptations() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_});
    }

    private static boolean isPlayerTargetable(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return player.m_6084_() && player.f_19853_.m_6857_().m_61935_(player.m_142469_());
    }
}

