/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.ai;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.WorldSettings;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class ChampionGoal {
    public static void registerTeleportGoal(Vault vault, Mob mob) {
        VaultDifficulty vaultDifficulty = WorldSettings.get(mob.f_19853_).getPlayerDifficulty(vault.get(Vault.OWNER));
        if (vaultDifficulty.shouldChampionRangeAttack()) {
            mob.f_21345_.m_25352_(3, (Goal)new TeleportToPlayerGoal(mob, ModConfigs.FIGHTER.chancerPerTick / 2));
        }
    }

    public static class TeleportToPlayerGoal
    extends Goal {
        private final Mob mob;
        private final int chance;
        private int waitTicks;
        private int progress;
        private long lastHurtTick = -100L;
        private long lastAttemptTick = -200L;

        public TeleportToPlayerGoal(Mob mob, int chance) {
            this.mob = mob;
            this.chance = chance;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (!(livingEntity instanceof Player)) {
                return false;
            }
            Player target = (Player)livingEntity;
            long now = this.mob.f_19797_;
            if (this.mob.m_21187_().nextInt(this.chance) != 0) {
                return false;
            }
            double dy = target.m_20186_() - this.mob.m_20186_();
            boolean hasLOS = this.mob.m_21574_().m_148306_((Entity)target);
            if (hasLOS && dy < 1.5) {
                return false;
            }
            return this.targetOutOfReachAbove();
        }

        public boolean m_8045_() {
            return this.mob.m_5448_() instanceof Player && this.progress < 1;
        }

        public void m_8056_() {
            this.waitTicks = 0;
            this.progress = 0;
        }

        public void m_8037_() {
            if (this.waitTicks < 40) {
                ++this.waitTicks;
                return;
            }
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            this.lastAttemptTick = this.mob.f_19797_;
            if (this.lastHurtTick > this.lastAttemptTick - 60L) {
                double x = Math.floor(target.m_20185_()) + 0.5;
                double y = target.m_20186_();
                double z = Math.floor(target.m_20189_()) + 0.5;
                this.mob.m_183503_().m_5594_(null, this.mob.m_142538_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.mob.m_6021_(x, y, z);
                this.mob.m_183503_().m_5594_(null, this.mob.m_142538_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
                ++this.progress;
                this.waitTicks = 0;
            }
        }

        public void m_8041_() {
            this.progress = 0;
        }

        private boolean targetOutOfReachAbove() {
            ChampionLogic.IChampionLogicHolder holder;
            Mob mob;
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !((mob = this.mob) instanceof ChampionLogic.IChampionLogicHolder) || (holder = (ChampionLogic.IChampionLogicHolder)mob).getChampionLogic().isPacified()) {
                return false;
            }
            if ((long)this.mob.f_19797_ - this.lastHurtTick > 60L) {
                return false;
            }
            double baseReach = this.mob.m_20205_() * 2.0f + target.m_20205_();
            double buffer = 1.0;
            double maxReach = baseReach + buffer;
            double targetDistance = this.mob.m_20280_((Entity)target);
            if (targetDistance <= maxReach * maxReach) {
                return false;
            }
            Path path = this.mob.m_21573_().m_26570_();
            if (path == null) {
                return true;
            }
            return !path.m_77403_() || this.mob.m_21573_().m_26577_();
        }

        public void markHurtByPlayer() {
            this.lastHurtTick = this.mob.f_19797_;
        }
    }
}

