/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.ai;

import iskallia.vault.entity.ai.GoalTask;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowEntityGoal<T extends Mob, O extends LivingEntity>
extends GoalTask<T> {
    private O owner;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;
    private final Supplier<Optional<O>> ownerSupplier;

    public FollowEntityGoal(T entity, double speed, float minDist, float maxDist, boolean teleportToLeaves, Supplier<Optional<O>> ownerSupplier) {
        super(entity);
        this.followSpeed = speed;
        this.navigator = entity.m_21573_();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.ownerSupplier = ownerSupplier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(((Mob)this.getEntity()).m_21573_() instanceof GroundPathNavigation) && !(((Mob)this.getEntity()).m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity owner = this.ownerSupplier.get().orElse(null);
        if (owner == null) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (owner.m_20280_(this.getEntity()) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigator.m_26571_()) {
            return false;
        }
        return ((Mob)this.getEntity()).m_20280_(this.owner) > (double)(this.maxDist * this.maxDist);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = ((Mob)this.getEntity()).m_21439_(BlockPathTypes.WATER);
        ((Mob)this.getEntity()).m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigator.m_26573_();
        ((Mob)this.getEntity()).m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        ((Mob)this.getEntity()).m_21563_().m_24960_(this.owner, 10.0f, (float)((Mob)this.getEntity()).m_8132_());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        if (!((Mob)this.getEntity()).m_21523_() && !((Mob)this.getEntity()).m_20159_()) {
            if (((Mob)this.getEntity()).m_20280_(this.owner) >= 144.0) {
                this.tryToTeleportNearEntity();
            } else {
                this.navigator.m_5624_(this.owner, this.followSpeed);
            }
        }
        this.timeToRecalcPath = 10;
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int j = this.nextInt(-3, 3);
            int k = this.nextInt(-1, 1);
            int l = this.nextInt(-3, 3);
            boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        ((Mob)this.getEntity()).m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, ((Mob)this.getEntity()).m_146908_(), ((Mob)this.getEntity()).m_146909_());
        this.navigator.m_26573_();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.getWorld(), (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathnodetype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.getWorld().m_8055_(pos.m_7495_());
        if (!this.teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_141950_((Vec3i)((Mob)this.getEntity()).m_142538_());
        return this.getWorld().m_45756_(this.getEntity(), ((Mob)this.getEntity()).m_142469_().m_82338_(blockpos));
    }

    private int nextInt(int min, int max) {
        return this.getWorld().m_5822_().nextInt(max - min + 1) + min;
    }
}

