/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.ai;

import iskallia.vault.entity.ai.GoalTask;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class TeleportGoal<T extends LivingEntity>
extends GoalTask<T> {
    private final Predicate<T> startCondition;
    private final Function<T, Vec3> targetSupplier;
    private final Consumer<T> postTeleport;

    protected TeleportGoal(T entity, Predicate<T> startCondition, Function<T, Vec3> targetSupplier, Consumer<T> postTeleport) {
        super(entity);
        this.startCondition = startCondition;
        this.targetSupplier = targetSupplier;
        this.postTeleport = postTeleport;
    }

    public static <T extends LivingEntity> Builder<T> builder(T entity) {
        return new Builder<T>(entity);
    }

    public boolean m_8036_() {
        return this.startCondition.test(this.getEntity());
    }

    public void m_8056_() {
        boolean teleported;
        Vec3 target = this.targetSupplier.apply(this.getEntity());
        if (target != null && (teleported = this.getEntity().m_20984_(target.m_7096_(), target.m_7098_(), target.m_7094_(), true))) {
            this.postTeleport.accept(this.getEntity());
        }
    }

    public static class Builder<T extends LivingEntity> {
        private final T entity;
        private Predicate<T> startCondition = entity -> false;
        private Function<T, Vec3> targetSupplier = entity -> null;
        private Consumer<T> postTeleport = entity -> {};

        private Builder(T entity2) {
            this.entity = entity2;
        }

        public Builder<T> start(Predicate<T> startCondition) {
            this.startCondition = startCondition;
            return this;
        }

        public Builder<T> to(Function<T, Vec3> targetSupplier) {
            this.targetSupplier = targetSupplier;
            return this;
        }

        public Builder<T> then(Consumer<T> postTeleport) {
            this.postTeleport = postTeleport;
            return this;
        }

        public TeleportGoal<T> build() {
            return new TeleportGoal<T>(this.entity, this.startCondition, this.targetSupplier, this.postTeleport);
        }
    }
}

