/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.ai.greed;

import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.ai.GoalTask;
import iskallia.vault.entity.entity.AcidPursuerEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AcidPursuerGroundSlamGoal
extends GoalTask<AcidPursuerEntity> {
    private static final int ASCEND_TICKS = 10;
    private static final int COOLDOWN_TICKS = 100;
    private static final float SLAM_RADIUS = 3.0f;
    private int cooldown;
    private int ticks;
    private boolean ascending;
    private Vec3 targetPos;

    public AcidPursuerGroundSlamGoal(AcidPursuerEntity entity) {
        super(entity);
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return ((AcidPursuerEntity)((Object)this.getEntity())).m_5448_() != null && ((AcidPursuerEntity)((Object)this.getEntity())).m_20096_();
    }

    public boolean m_8045_() {
        return ((AcidPursuerEntity)((Object)this.getEntity())).isAttacking();
    }

    public void m_8056_() {
        this.ascending = true;
        this.ticks = 0;
        LivingEntity target = ((AcidPursuerEntity)((Object)this.getEntity())).m_5448_();
        this.targetPos = target != null ? target.m_20182_() : null;
        ((AcidPursuerEntity)((Object)this.getEntity())).startGroundSlamAttack();
        Vec3 direction = Vec3.f_82478_;
        if (this.targetPos != null) {
            direction = this.targetPos.m_82546_(((AcidPursuerEntity)((Object)this.getEntity())).m_20182_());
            direction = new Vec3(direction.f_82479_, 0.0, direction.f_82481_).m_82541_().m_82490_((double)0.4f);
            ((AcidPursuerEntity)((Object)this.getEntity())).m_21563_().m_24946_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_);
        }
        ((AcidPursuerEntity)((Object)this.getEntity())).m_20334_(direction.f_82479_, 0.6, direction.f_82481_);
    }

    public void m_8037_() {
        if (!((AcidPursuerEntity)((Object)this.getEntity())).m_6084_()) {
            this.m_8041_();
            return;
        }
        if (this.ascending) {
            if (this.ticks < 10) {
                Vec3 movement = ((AcidPursuerEntity)((Object)this.getEntity())).m_20184_();
                ((AcidPursuerEntity)((Object)this.getEntity())).m_20334_(movement.f_82479_, movement.f_82480_ + 0.1, movement.f_82481_);
            } else {
                this.ascending = false;
            }
            ++this.ticks;
            return;
        }
        if (((AcidPursuerEntity)((Object)this.getEntity())).m_20096_()) {
            this.performSlam();
            ((AcidPursuerEntity)((Object)this.getEntity())).stopAttacking();
            this.cooldown = 100;
        }
    }

    private void performSlam() {
        if (this.getWorld().m_5776_()) {
            return;
        }
        Vec3 pos = ((AcidPursuerEntity)((Object)this.getEntity())).m_20182_();
        ServerLevel level = (ServerLevel)this.getWorld();
        this.spawnGroundEffects(level, pos, 3.0f);
        this.pushBackEntities(level, pos, 3.0f);
        this.damagePlayers(level, pos, 3.0f);
    }

    private void pushBackEntities(ServerLevel level, Vec3 pos, float radius) {
        AABB area = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - 1.0, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)((AcidPursuerEntity)((Object)this.getEntity())).m_20206_(), pos.f_82481_ + (double)radius);
        List targets = level.m_6443_(LivingEntity.class, area, e -> e != this.getEntity());
        for (LivingEntity target : targets) {
            double dz;
            double dx = pos.f_82479_ - target.m_20185_();
            if (dx * dx + (dz = pos.f_82481_ - target.m_20189_()) * dz < 1.0E-4) {
                dx = (level.f_46441_.nextDouble() - level.f_46441_.nextDouble()) * 0.01;
                dz = (level.f_46441_.nextDouble() - level.f_46441_.nextDouble()) * 0.01;
            }
            target.m_147240_((double)0.4f, dx, dz);
        }
    }

    private void damagePlayers(ServerLevel level, Vec3 pos, float radius) {
        AABB area = new AABB(pos.f_82479_ - (double)radius, pos.f_82480_ - 1.0, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)((AcidPursuerEntity)((Object)this.getEntity())).m_20206_(), pos.f_82481_ + (double)radius);
        List players = level.m_6443_(Player.class, area, p -> !p.m_7306_(this.getEntity()));
        float damage = (float)((AcidPursuerEntity)((Object)this.getEntity())).m_21133_(Attributes.f_22281_);
        for (Player player : players) {
            boolean hurt = player.m_6469_(DamageSource.m_19370_(this.getEntity()), damage);
            if (hurt) continue;
            VaultMod.LOGGER.debug("GroundSlam player resisted damage: {}", (Object)player.m_7755_().getString());
        }
    }

    private void spawnGroundEffects(ServerLevel level, Vec3 pos, float radius) {
        int i;
        int particleCount = (int)(radius * radius * 5.0f);
        for (i = 0; i < particleCount; ++i) {
            BlockState blockState;
            double distance = level.f_46441_.nextDouble() * (double)radius;
            double angle = level.f_46441_.nextDouble() * 6.2831854820251465;
            double x = pos.f_82479_ + distance * Math.cos(angle);
            double z = pos.f_82481_ + distance * Math.sin(angle);
            BlockPos blockPos = new BlockPos(x, pos.f_82480_ - 1.0, z);
            while (blockPos.m_123342_() > level.m_141937_() && level.m_46859_(blockPos)) {
                blockPos = blockPos.m_7495_();
            }
            if (blockPos.m_123342_() <= level.m_141937_() || (blockState = level.m_8055_(blockPos)).m_60795_()) continue;
            level.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.5f, 0.4f), 1.5f), x, (double)blockPos.m_123342_() + 0.5, z, 5, 0.0, 0.5, 0.0, 0.2);
            if (level.f_46441_.nextFloat() < 0.3f) {
                level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, (double)blockPos.m_123342_() + 0.5, z, 8, 0.2, 0.5, 0.2, 0.3);
            }
            if (!(level.f_46441_.nextFloat() < 0.2f)) continue;
            level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, (double)blockPos.m_123342_() + 0.5, z, 8, 0.3, 1.2, 0.3, 1.0);
        }
        for (i = 0; i < 3; ++i) {
            float pitch = 0.5f + level.f_46441_.nextFloat() * 0.2f;
            level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.HOSTILE, 0.5f, pitch);
        }
    }

    public void m_8041_() {
        ((AcidPursuerEntity)((Object)this.getEntity())).stopAttacking();
        this.ascending = false;
        this.ticks = 0;
    }
}

