/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.ArtifactBossImmunityParticleOptions;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.attack.AoeCloseAttack;
import iskallia.vault.entity.boss.attack.BasicMeleeAttack;
import iskallia.vault.entity.boss.attack.BossMeleeAttackGoal;
import iskallia.vault.entity.boss.attack.IMeleeAttack;
import iskallia.vault.entity.boss.attack.ThrowAttack;
import iskallia.vault.entity.boss.stage.BossStageManager;
import iskallia.vault.entity.boss.stage.IBossStage;
import iskallia.vault.entity.boss.stage.SparkStage;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.ClientboundArtifactBossImmunityParticleMessage;
import iskallia.vault.network.message.ClientboundBossStagesMessage;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.WorldSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

@Mod.EventBusSubscriber
public class ArtifactBossEntity
extends VaultBossBaseEntity
implements IAnimatable {
    public static final String SUMMON_ATTACK_NAME = "summon";
    public static final String PUNCH_ATTACK_NAME = "punch";
    public static final String HAMMER_SMASH_ATTACK_NAME = "hammersmash";
    public static final String UPPERCUT_ATTACK_NAME = "uppercut";
    public static final String GROUND_SLAM_ATTACK_NAME = "groundslam";
    public static final String THROW_ATTACK_NAME = "throw";
    public static final String AOE_CLOSE_ATTACK_NAME = "aoeclose";
    public static final BasicMeleeAttack.BasicMeleeAttackAttributes HAMMERSMASH_ATTACK = new BasicMeleeAttack.BasicMeleeAttackAttributes(new BasicMeleeAttack.BasicMeleeAttackAttributes.Slice(-0.1f, 0.6f), 30, 17, "hammersmash", 1.0f, 0.0f);
    public static final BasicMeleeAttack.BasicMeleeAttackAttributes UPPERCUT_ATTACK = new BasicMeleeAttack.BasicMeleeAttackAttributes(new BasicMeleeAttack.BasicMeleeAttackAttributes.Slice(-0.1f, 0.6f), 25, 15, "uppercut", 1.5f, 0.3f);
    public static final BasicMeleeAttack.BasicMeleeAttackAttributes GROUNDSLAM_ATTACK = new BasicMeleeAttack.BasicMeleeAttackAttributes(new BasicMeleeAttack.BasicMeleeAttackAttributes.Slice(-0.1f, 0.6f), 45, 24, "groundslam", 2.5f, 0.1f);
    public static final BasicMeleeAttack.BasicMeleeAttackAttributes PUNCH_ATTACK = new BasicMeleeAttack.BasicMeleeAttackAttributes(new BasicMeleeAttack.BasicMeleeAttackAttributes.Slice(0.0f, 0.6f), 20, 8, "punch", 0.5f, 0.0f);
    public static final Map<String, BiFunction<VaultBossBaseEntity, Double, IMeleeAttack>> MELEE_ATTACK_FACTORIES = Map.of("hammersmash", (boss, multiplier) -> new BasicMeleeAttack((VaultBossBaseEntity)boss, (double)multiplier, HAMMERSMASH_ATTACK), "uppercut", (boss, multiplier) -> new BasicMeleeAttack((VaultBossBaseEntity)boss, (double)multiplier, UPPERCUT_ATTACK), "groundslam", (boss, multiplier) -> new BasicMeleeAttack((VaultBossBaseEntity)boss, (double)multiplier, GROUNDSLAM_ATTACK), "throw", ThrowAttack::new, "aoeclose", AoeCloseAttack::new, "punch", (boss, multiplier) -> new BasicMeleeAttack((VaultBossBaseEntity)boss, (double)multiplier, PUNCH_ATTACK));
    private static final EntityDataAccessor<Integer> CURRENT_STAGE_INDEX = SynchedEntityData.m_135353_(ArtifactBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_STUNNED = SynchedEntityData.m_135353_(ArtifactBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final List<IBossStage> stages = new ArrayList<IBossStage>();
    private boolean stagesInitialized = false;
    private BossMeleeAttackGoal meleeAttackGoal;
    private static final AnimationBuilder HAMMERSMASH_ANIM = new AnimationBuilder().addAnimation("animation.vaultbattlemage.hammersmash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private static final AnimationBuilder UPPERCUT_ANIM = new AnimationBuilder().addAnimation("animation.vaultbattlemage.uppercut", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder SUMMON_ANIM = new AnimationBuilder().addAnimation("animation.vaultbattlemage.summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder SUMMON_CONTINUOUS_ANIM = new AnimationBuilder().addAnimation("animation.vaultbattlemage.summonstart", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("animation.vaultbattlemage.summonloop", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder GROUNDSLAM_ANIM = new AnimationBuilder().addAnimation("animation.vaultbattlemage.groundslam", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    protected static final AnimationBuilder STUNNED_ANIM = new AnimationBuilder().addAnimation("animation.vaultbattlemage.stunned", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("animation.vaultbattlemage.stunnedloop", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder IDLE_ANIM = new AnimationBuilder().addAnimation("animation.vaultbattlemage.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder WALK_ANIM = new AnimationBuilder().addAnimation("animation.vaultbattlemage.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder AOE_CLOSE = new AnimationBuilder().addAnimation("animation.vaultbattlemage.aoeclose2", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public ArtifactBossEntity(EntityType<ArtifactBossEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BossStageGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.meleeAttackGoal = new BossMeleeAttackGoal(this);
        this.f_21345_.m_25352_(2, (Goal)this.meleeAttackGoal);
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1000000.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22282_, 2.5).m_22268_(ModAttributes.CRIT_CHANCE, 0.0).m_22268_(ModAttributes.CRIT_MULTIPLIER, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        if (!this.f_19853_.m_5776_() && !this.stagesInitialized) {
            this.stagesInitialized = true;
            ModConfigs.HERALD.getBossStageConfigs("artifact_boss").forEach(s -> this.stages.add(BossStageManager.createStageFromAttributes(this, s.stageType(), s.attributes())));
            ArtifactBossEntity.syncStagesToClient(this, PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()));
            this.setCurrentStageIndex(-1);
            this.setNextStage();
        }
        if (this.f_19853_.f_46443_) {
            if (!((Boolean)this.f_19804_.m_135370_(IS_STUNNED)).booleanValue()) {
                if (this.getCurrentStage().isPresent() && this.getCurrentStage().get() instanceof SparkStage) {
                    int col = 16769280;
                    int col2 = 16774829;
                    float r = (float)(col >> 16 & 0xFF) / 255.0f;
                    float g = (float)(col >> 8 & 0xFF) / 255.0f;
                    float b = (float)(col & 0xFF) / 255.0f;
                    float r2 = (float)(col2 >> 16 & 0xFF) / 255.0f;
                    float g2 = (float)(col2 >> 8 & 0xFF) / 255.0f;
                    float b2 = (float)(col2 & 0xFF) / 255.0f;
                    Vec3 vec3 = new Vec3(3.0, 8.0, 0.0).m_82524_((float)Math.toRadians(this.f_19797_ * 15));
                    this.f_19853_.m_6493_((ParticleOptions)new ArtifactBossImmunityParticleOptions((ParticleType<ArtifactBossImmunityParticleOptions>)((ParticleType)ModParticles.ARTIFACT_BOSS_IMMUNITY.get()), 20, new Vector3f(r, g, b), new Vector3f(r2, g2, b2)), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    Vec3 vec32 = new Vec3(3.0, 8.0, 0.0).m_82524_((float)Math.toRadians(this.f_19797_ * 15 + 180));
                    this.f_19853_.m_6493_((ParticleOptions)new ArtifactBossImmunityParticleOptions((ParticleType<ArtifactBossImmunityParticleOptions>)((ParticleType)ModParticles.ARTIFACT_BOSS_IMMUNITY.get()), 20, new Vector3f(r, g, b), new Vector3f(r2, g2, b2)), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), vec32.f_82479_, vec32.f_82480_, vec32.f_82481_);
                }
            } else {
                this.f_19853_.m_6493_((ParticleOptions)ModParticles.STUNNED.get(), true, this.m_20182_().m_7096_(), this.m_20182_().m_7098_() + (double)this.m_20206_() + 0.25, this.m_20182_().m_7094_(), (double)this.m_20205_(), 0.0, 0.0);
            }
        }
        super.m_8119_();
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        if (potionEffect.m_19544_() == ModEffects.CHILLED || potionEffect.m_19544_() == ModEffects.GLACIAL_SHATTER || potionEffect.m_19544_() == ModEffects.NO_AI) {
            return false;
        }
        return super.m_7301_(potionEffect);
    }

    public void m_7334_(Entity pEntity) {
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    public boolean m_7998_(Entity pEntity, boolean pForce) {
        return true;
    }

    public void setScaledHealth(int baseHealth) {
        double healthMultiplier = ServerVaults.get(this.f_19853_).map(vault -> WorldSettings.get(this.f_19853_).getPlayerDifficulty(vault.get(Vault.OWNER)).getBossHealthMultiplier()).orElse(1.0);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)baseHealth * healthMultiplier);
        this.m_21153_((float)((double)baseHealth * healthMultiplier));
    }

    public void setScaledDamage(double baseDamage) {
        double damageMultiplier = ServerVaults.get(this.f_19853_).map(vault -> WorldSettings.get(this.f_19853_).getPlayerDifficulty(vault.get(Vault.OWNER)).getBossDamageMultiplier()).orElse(1.0);
        this.m_21051_(Attributes.f_22281_).m_22100_(baseDamage * damageMultiplier);
    }

    protected SoundEvent m_7515_() {
        return ModSounds.ARTIFACT_BOSS_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return ModSounds.ARTIFACT_BOSS_HURT;
    }

    protected SoundEvent m_5592_() {
        return ModSounds.ARTIFACT_BOSS_DEATH;
    }

    public boolean m_6673_(DamageSource source) {
        return !source.m_19390_() && source != DamageSource.f_19317_ && this.getCurrentStage().map(IBossStage::makesBossInvulnerable).orElse(super.m_6673_(source)) != false;
    }

    protected void m_8022_() {
        if (this.getCurrentStage().isEmpty()) {
            super.m_8022_();
        }
    }

    @Override
    public Map<String, BiFunction<VaultBossBaseEntity, Double, IMeleeAttack>> getMeleeAttackFactories() {
        return MELEE_ATTACK_FACTORIES;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CURRENT_STAGE_INDEX, (Object)-1);
        this.f_19804_.m_135372_(IS_STUNNED, (Object)false);
    }

    @Override
    public WeightedList<VaultBossBaseEntity.AttackData> getMeleeAttacks() {
        return this.getCurrentStage().map(IBossStage::getMeleeAttacks).orElse((WeightedList)WeightedList.empty());
    }

    @Override
    public WeightedList<VaultBossBaseEntity.AttackData> getRageAttacks() {
        return this.getCurrentStage().map(IBossStage::getRageAttacks).orElse((WeightedList)WeightedList.empty());
    }

    @Override
    public double getAttackReach() {
        return 5.0;
    }

    public void setStunned(boolean stunned) {
        this.f_19804_.m_135381_(IS_STUNNED, (Object)stunned);
    }

    public void setCurrentStageIndex(int stageIndex) {
        this.f_19804_.m_135381_(CURRENT_STAGE_INDEX, (Object)stageIndex);
    }

    public int getCurrentStageIndex() {
        return (Integer)this.f_19804_.m_135370_(CURRENT_STAGE_INDEX);
    }

    public Optional<IBossStage> getCurrentStage() {
        int currentStageIndex = this.getCurrentStageIndex();
        if (currentStageIndex < 0 || currentStageIndex >= this.stages.size()) {
            return Optional.empty();
        }
        return Optional.of(this.stages.get(this.getCurrentStageIndex()));
    }

    private void setNextStage() {
        this.setCurrentStageIndex(this.getCurrentStageIndex() + 1);
        this.getCurrentStage().ifPresent(IBossStage::init);
    }

    public boolean hasMoreStages() {
        return this.stages.size() > this.getCurrentStageIndex() + 1;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ListTag stagesNbt1 = new ListTag();
        for (IBossStage stage : this.stages) {
            stagesNbt1.add((Object)stage.serialize());
        }
        ListTag stagesNbt = stagesNbt1;
        compound.m_128365_("Stages", (Tag)stagesNbt);
        compound.m_128379_("StagesInitialized", this.stagesInitialized);
        compound.m_128405_("CurrentStage", this.getCurrentStageIndex());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ListTag stagesNbt = compound.m_128437_("Stages", 10);
        this.stages.clear();
        for (int i = 0; i < stagesNbt.size(); ++i) {
            CompoundTag stageNbt = stagesNbt.m_128728_(i);
            this.stages.add(BossStageManager.createStageFrom(this, stageNbt));
        }
        this.stagesInitialized = compound.m_128471_("StagesInitialized");
        this.setCurrentStageIndex(compound.m_128451_("CurrentStage"));
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82377_(2.0, 0.0, 2.0);
    }

    public int m_8085_() {
        return 30;
    }

    public void m_6667_(DamageSource cause) {
        if (cause != DamageSource.f_19317_ && this.hasMoreStages()) {
            this.m_21153_(1.0f);
        } else {
            super.m_6667_(cause);
            this.meleeAttackGoal.m_8041_();
            this.getCurrentStage().ifPresent(stage -> {
                stage.stop();
                stage.finish();
            });
        }
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (sound == this.m_5592_() && this.hasMoreStages()) {
            return;
        }
        super.m_5496_(sound, volume, pitch);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        EntityDamageSource entityDamageSource;
        boolean wasHurt = super.m_6469_(pSource, pAmount);
        if (wasHurt) {
            this.getCurrentStage().ifPresent(IBossStage::onHurt);
        }
        if (this.getCurrentStage().isPresent() && this.getCurrentStage().get() instanceof SparkStage && !this.f_19853_.m_5776_() && this.m_6673_(pSource) && pSource instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)pSource).m_7639_() instanceof Player) {
            int col = 0xFFFFB2;
            int col2 = 0xFFFFDD;
            ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_142538_())), (Object)new ClientboundArtifactBossImmunityParticleMessage(this.m_20182_(), col, col2));
        }
        return wasHurt;
    }

    public boolean isCloseToDeath() {
        return this.m_21223_() <= 1.0f;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "StageAnimation", 5.0f, this::stageAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Walking", 5.0f, this::walkAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Idle", 5.0f, this::idleAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "AttackMove", 0.0f, this::attackMoveAnimController));
    }

    private PlayState attackMoveAnimController(AnimationEvent<ArtifactBossEntity> event) {
        AnimationController controller = event.getController();
        return this.getActiveAttackMove().map(attackMove -> switch (attackMove) {
            case HAMMER_SMASH_ATTACK_NAME -> {
                controller.setAnimation(HAMMERSMASH_ANIM);
                yield PlayState.CONTINUE;
            }
            case UPPERCUT_ATTACK_NAME -> {
                controller.setAnimation(UPPERCUT_ANIM);
                yield PlayState.CONTINUE;
            }
            case GROUND_SLAM_ATTACK_NAME -> {
                controller.setAnimation(GROUNDSLAM_ANIM);
                yield PlayState.CONTINUE;
            }
            case SUMMON_ATTACK_NAME -> {
                controller.setAnimation(SUMMON_ANIM);
                yield PlayState.CONTINUE;
            }
            case AOE_CLOSE_ATTACK_NAME -> {
                controller.setAnimation(AOE_CLOSE);
                yield PlayState.CONTINUE;
            }
            default -> throw new IllegalStateException("Unexpected value: " + attackMove);
        }).orElseGet(() -> {
            controller.markNeedsReload();
            return PlayState.STOP;
        });
    }

    private PlayState stageAnimController(AnimationEvent<ArtifactBossEntity> event) {
        return this.getCurrentStage().flatMap(IBossStage::getAnimation).map(a -> {
            event.getController().transitionLengthTicks = 5.0;
            if (((Boolean)this.f_19804_.m_135370_(IS_STUNNED)).booleanValue()) {
                a = STUNNED_ANIM;
                event.getController().transitionLengthTicks = 0.0;
            }
            event.getController().setAnimation(a);
            return PlayState.CONTINUE;
        }).orElse(PlayState.STOP);
    }

    private PlayState idleAnimController(AnimationEvent<ArtifactBossEntity> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(IDLE_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState walkAnimController(AnimationEvent<ArtifactBossEntity> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(WALK_ANIM);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ArtifactBossEntity) {
            ArtifactBossEntity artifactBossEntity = (ArtifactBossEntity)entity;
            entity = event.getPlayer();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ArtifactBossEntity.syncStagesToClient(artifactBossEntity, PacketDistributor.PLAYER.with(() -> player));
            }
        }
    }

    private static void syncStagesToClient(ArtifactBossEntity artifactBossEntity, PacketDistributor.PacketTarget target) {
        ArrayList<CompoundTag> stagesNbt = new ArrayList<CompoundTag>();
        for (IBossStage stage : artifactBossEntity.stages) {
            stagesNbt.add(stage.serialize());
        }
        ModNetwork.CHANNEL.send(target, (Object)new ClientboundBossStagesMessage(artifactBossEntity.m_142049_(), stagesNbt));
    }

    public void setStagesFromNbt(List<CompoundTag> stagesNbt) {
        this.stages.clear();
        for (CompoundTag stageNbt : stagesNbt) {
            this.stages.add(BossStageManager.createStageFrom(this, stageNbt));
        }
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    private boolean isAtSpawnPoint() {
        return this.spawnPosition != null && this.spawnPosition.m_82557_(this.m_20182_()) < 1.0;
    }

    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(IS_STUNNED);
    }

    public boolean m_6128_() {
        return true;
    }

    @Override
    public ServerBossEvent getServerBossInfo() {
        return new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    }

    @Override
    public void playAttackSound() {
        this.f_19853_.m_5594_(null, this.m_142538_(), ModSounds.ARTIFACT_BOSS_ATTACK, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    private static class BossStageGoal
    extends Goal {
        private final ArtifactBossEntity boss;

        public BossStageGoal(ArtifactBossEntity boss) {
            this.boss = boss;
        }

        public boolean m_8036_() {
            return this.boss.getCurrentStage().isPresent();
        }

        public void m_8056_() {
            super.m_8056_();
            this.boss.getCurrentStage().ifPresent(currentStage -> {
                if (!this.boss.isAtSpawnPoint()) {
                    Level patt23826$temp = this.boss.f_19853_;
                    if (patt23826$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt23826$temp;
                        serverLevel.m_6263_(null, this.boss.m_20182_().m_7096_(), this.boss.m_20182_().m_7098_(), this.boss.m_20182_().m_7094_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 0.5f, 2.0f);
                    }
                    this.boss.m_6021_(this.boss.spawnPosition.f_82479_, this.boss.spawnPosition.f_82480_, this.boss.spawnPosition.f_82481_);
                }
                currentStage.getControlFlags().forEach(f -> this.boss.f_21345_.m_25360_(f, false));
                currentStage.start();
            });
        }

        public void m_8041_() {
            super.m_8041_();
            this.boss.getCurrentStage().ifPresent(currentStage -> {
                currentStage.getControlFlags().forEach(f -> this.boss.f_21345_.m_25360_(f, true));
                currentStage.stop();
                if (currentStage.isFinished()) {
                    currentStage.finish();
                    this.boss.setNextStage();
                }
            });
        }

        public void m_8037_() {
            super.m_8037_();
            this.boss.getCurrentStage().ifPresent(IBossStage::tick);
        }

        public boolean m_8045_() {
            return this.boss.getCurrentStage().map(IBossStage::isFinished).orElse(true) == false;
        }
    }
}

