/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.VaultMod;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.AnimationSpeedWrapper;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.attack.BasicMeleeAttack;
import iskallia.vault.entity.boss.attack.IMeleeAttack;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.easing.EasingType;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class BoogiemanBossEntity
extends VaultBossEntity
implements IAnimatable {
    private static final AnimationSpeedWrapper SLASH_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("Slash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE), b -> 1.5);
    private static final AnimationSpeedWrapper JAB_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("Jab", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE), b -> 1.5);
    private static final AnimationSpeedWrapper SNOWBALL_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("Snowball", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
    private static final AnimationSpeedWrapper JUMP_ATTACK_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("JumpAttack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
    private static final AnimationSpeedWrapper WALK_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("Walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP), b -> b.m_21051_(Attributes.f_22279_).m_22135_() / (double)0.2f);
    private static final WeightedList<AnimationSpeedWrapper> PUNCH_ANIMATIONS = new WeightedList<AnimationSpeedWrapper>().add(SLASH_ANIM, 2).add(JAB_ANIM, 2);
    public static final String JAB_ATTACK_NAME = "jab";
    public static final String SLASH_ATTACK_NAME = "slash";
    public static final BasicMeleeAttack.BasicMeleeAttackAttributes JAB_ATTACK = new BasicMeleeAttack.BasicMeleeAttackAttributes(new BasicMeleeAttack.BasicMeleeAttackAttributes.Slice(0.0f, 0.6f), 20, 8, "jab", 0.5f, 0.0f);
    public static final BasicMeleeAttack.BasicMeleeAttackAttributes SLASH_ATTACK = new BasicMeleeAttack.BasicMeleeAttackAttributes(new BasicMeleeAttack.BasicMeleeAttackAttributes.Slice(0.0f, 0.4f), 20, 8, "slash", 0.5f, -0.2f);
    public static final Map<String, BiFunction<VaultBossBaseEntity, Double, IMeleeAttack>> MELEE_ATTACK_FACTORIES = Map.of("jab", (boss, multiplier) -> new BasicMeleeAttack((VaultBossBaseEntity)boss, (double)multiplier, JAB_ATTACK), "slash", (boss, multiplier) -> new BasicMeleeAttack((VaultBossBaseEntity)boss, (double)multiplier, SLASH_ATTACK));
    @Nullable
    private AnimationSpeedWrapper currentAttackAnimation = null;

    public BoogiemanBossEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "AttackAnimation", 5.0f, EasingType.EaseOutQuint, this::attackMoveAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Walking", 5.0f, this::walkAnimController));
    }

    @Override
    public Map<String, BiFunction<VaultBossBaseEntity, Double, IMeleeAttack>> getMeleeAttackFactories() {
        return MELEE_ATTACK_FACTORIES;
    }

    @Override
    public double getAttackReach() {
        return 3.0;
    }

    private PlayState attackMoveAnimController(AnimationEvent<BoogiemanBossEntity> event) {
        AnimationController controller = event.getController();
        return this.getActiveAttackMove().map(attackMove -> {
            if (!this.m_21573_().m_26571_()) {
                return PlayState.CONTINUE;
            }
            switch (attackMove) {
                case "slash": {
                    this.currentAttackAnimation = SLASH_ANIM;
                    this.currentAttackAnimation.applyTo(controller, this);
                    return PlayState.CONTINUE;
                }
                case "jab": {
                    this.currentAttackAnimation = JAB_ANIM;
                    this.currentAttackAnimation.applyTo(controller, this);
                    return PlayState.CONTINUE;
                }
                case "snowball_ranged_attack": {
                    this.currentAttackAnimation = SNOWBALL_ANIM;
                    this.currentAttackAnimation.applyTo(controller, this);
                    return PlayState.CONTINUE;
                }
            }
            VaultMod.LOGGER.error("Unexpected value: " + attackMove);
            return PlayState.STOP;
        }).orElseGet(() -> {
            this.currentAttackAnimation = null;
            controller.markNeedsReload();
            return PlayState.STOP;
        });
    }

    private PlayState walkAnimController(AnimationEvent<BoogiemanBossEntity> event) {
        if (event.isMoving()) {
            AnimationController controller = event.getController();
            WALK_ANIM.applyTo(controller, this);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    public void playAttackSound() {
        this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_12317_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }
}

