/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.CatalystInhibitorItem;
import iskallia.vault.network.message.NovaParticleMessage;
import iskallia.vault.network.message.StonefallParticleMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class BossProtectionCatalystEntity
extends Entity {
    public static final EntityDataSerializer<CatalystType> TYPE_SERIALIZER = new EntityDataSerializer<CatalystType>(){

        public void write(FriendlyByteBuf buf, CatalystType value) {
            buf.m_130068_((Enum)value);
        }

        public CatalystType read(FriendlyByteBuf buf) {
            return (CatalystType)buf.m_130066_(CatalystType.class);
        }

        public CatalystType copy(CatalystType value) {
            return value;
        }
    };
    private static final EntityDataAccessor<CatalystType> TYPE;
    private static final float RADIUS_AROUND_CENTER = 5.0f;
    private static final float ORBIT_RADIUS = 0.75f;
    private Vec3 center;
    private float angle;
    private float explosionDamageMultiplier;
    private boolean exploding = false;
    private int explosionTimer = 0;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;

    public BossProtectionCatalystEntity(Level pLevel, Vec3 center, float angle, CatalystType catalystType, float explosionDamageMultiplier) {
        this(ModEntities.BOSS_PROTECTION_CATALYST, pLevel);
        this.center = center;
        this.angle = angle;
        this.explosionDamageMultiplier = explosionDamageMultiplier;
        this.setCatalystType(catalystType);
        this.m_146884_(center);
    }

    public BossProtectionCatalystEntity(EntityType<BossProtectionCatalystEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public void updatePosition() {
        double horizontalAngle = (double)this.angle + Math.toRadians(this.f_19853_.m_46467_() % 360L);
        double orbitAngle = horizontalAngle * 7.0;
        double distanceFromCenter = 5.0 + Math.cos(orbitAngle) * 0.75;
        double xAroundCenter = distanceFromCenter * Math.cos(horizontalAngle);
        double zAroundCenter = distanceFromCenter * Math.sin(horizontalAngle);
        Vec3 nextPos = new Vec3(this.center.m_7096_() + xAroundCenter, this.center.m_7098_() + 2.0 + 0.75 * Math.sin(orbitAngle), this.center.m_7094_() + zAroundCenter);
        this.m_20219_(nextPos);
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        this.lerpX = pX;
        this.lerpY = pY;
        this.lerpZ = pZ;
        this.lerpSteps = pPosRotationIncrements;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TYPE, (Object)CatalystType.LIVING);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.lerpSteps > 0) {
                double x = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
                double y = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
                double z = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
                --this.lerpSteps;
                this.m_6034_(x, y, z);
            }
            return;
        }
        this.updatePosition();
        if (this.exploding) {
            --this.explosionTimer;
            if (this.explosionTimer <= 0) {
                this.explode();
                this.exploding = false;
            }
        }
    }

    private void explode() {
        this.f_19853_.m_142346_(null, GameEvent.f_157812_, this.m_20097_());
        float radius = 50.0f;
        float diameter = radius * 2.0f;
        int minX = Mth.m_14107_((double)(this.m_20185_() - (double)diameter - 1.0));
        int maxX = Mth.m_14107_((double)(this.m_20185_() + (double)diameter + 1.0));
        int minY = Mth.m_14107_((double)(this.m_20186_() - (double)diameter - 1.0));
        int maxY = Mth.m_14107_((double)(this.m_20186_() + (double)diameter + 1.0));
        int minZ = Mth.m_14107_((double)(this.m_20189_() - (double)diameter - 1.0));
        int maxZ = Mth.m_14107_((double)(this.m_20189_() + (double)diameter + 1.0));
        List entities = this.f_19853_.m_45933_((Entity)this, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        Vec3 explosionCenter = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NovaParticleMessage(new Vec3(this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_()), 4.0f));
        HashMap<Player, Vec3> hitPlayers = new HashMap<Player, Vec3>();
        for (Entity entity : entities) {
            Player player;
            double zDist;
            double yDist;
            double xDist;
            double dist;
            double normalizedEntityDist;
            if (entity.m_6128_() || !((normalizedEntityDist = Math.sqrt(entity.m_20238_(explosionCenter)) / (double)diameter) < 1.0) || (dist = Math.sqrt((xDist = entity.m_20185_() - this.m_20185_()) * xDist + (yDist = entity.m_20188_() - this.m_20186_()) * yDist + (zDist = entity.m_20189_() - this.m_20189_()) * zDist)) == 0.0) continue;
            xDist /= dist;
            yDist /= dist;
            zDist /= dist;
            double entityCloseness = 1.0 - normalizedEntityDist;
            entity.m_6469_(DamageSource.m_19373_((LivingEntity)null), (float)((int)((entityCloseness * entityCloseness + entityCloseness) / 2.0 * (double)this.explosionDamageMultiplier * (double)diameter + 1.0)));
            double knockbackRatio = entityCloseness;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                knockbackRatio = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)entityCloseness);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(xDist * knockbackRatio, yDist * knockbackRatio, zDist * knockbackRatio));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            hitPlayers.put(player, new Vec3(xDist * entityCloseness, yDist * entityCloseness, zDist * entityCloseness));
        }
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer serverplayer : serverLevel.m_6907_()) {
                if (!(serverplayer.m_20238_(this.m_20182_()) < 4096.0)) continue;
                serverplayer.f_8906_.m_141995_((Packet)new ClientboundExplodePacket(this.m_20185_(), this.m_20186_(), this.m_20189_(), 50.0f, List.of(), (Vec3)hitPlayers.get(serverplayer)));
            }
        }
    }

    public void hitWithInhibitor(Player player, ItemStack inhibitorStack) {
        Item item = inhibitorStack.m_41720_();
        if (item instanceof CatalystInhibitorItem) {
            CatalystInhibitorItem catalystInhibitorItem = (CatalystInhibitorItem)item;
            if (this.getCatalystType() == catalystInhibitorItem.getCatalystType()) {
                if (!this.f_19853_.f_46443_) {
                    this.m_5496_(SoundEvents.f_12411_, 1.0f, 1.0f);
                    ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
                    ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StonefallParticleMessage(new Vec3(this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_()), 3.0f));
                    this.f_19853_.m_6263_(null, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), ModSounds.ARTIFACT_BOSS_CATALYST_HIT, SoundSource.BLOCKS, 1.0f, 0.75f + new Random().nextFloat() * 0.35f);
                    this.m_146870_();
                }
            } else {
                this.f_19853_.m_6263_(null, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), ModSounds.ARTIFACT_BOSS_CATALYST_HIT_WRONG, SoundSource.BLOCKS, 1.0f, 0.75f + new Random().nextFloat() * 0.35f);
                this.exploding = true;
                this.explosionTimer = 20;
            }
        }
    }

    protected void m_7378_(CompoundTag tag) {
        CompoundTag centerTag = tag.m_128469_("Center");
        this.center = new Vec3(centerTag.m_128459_("X"), centerTag.m_128459_("Y"), centerTag.m_128459_("Z"));
        this.angle = tag.m_128457_("Angle");
        this.explosionDamageMultiplier = tag.m_128457_("ExplosionDamageMultiplier");
        this.setCatalystType(CatalystType.valueOf(tag.m_128461_("CatalystType")));
    }

    public void setCatalystType(CatalystType catalystType) {
        this.f_19804_.m_135381_(TYPE, (Object)catalystType);
    }

    public CatalystType getCatalystType() {
        return (CatalystType)((Object)this.f_19804_.m_135370_(TYPE));
    }

    protected void m_7380_(CompoundTag tag) {
        CompoundTag centerTag = new CompoundTag();
        centerTag.m_128347_("X", this.center.f_82479_);
        centerTag.m_128347_("Y", this.center.f_82480_);
        centerTag.m_128347_("Z", this.center.f_82481_);
        tag.m_128365_("Center", (Tag)centerTag);
        tag.m_128350_("Angle", this.angle);
        tag.m_128350_("ExplosionDamageMultiplier", this.explosionDamageMultiplier);
        tag.m_128359_("CatalystType", this.getCatalystType().name());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        EntityDataSerializers.m_135050_(TYPE_SERIALIZER);
        TYPE = SynchedEntityData.m_135353_(BossProtectionCatalystEntity.class, TYPE_SERIALIZER);
    }

    public static enum CatalystType {
        LIVING,
        WOODEN,
        ORNATE,
        GILDED;

    }
}

