/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.core.data.adapter.Adapters;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.BossEvent;

public class BossRuneModifiers {
    private double healthPercent;
    private double damagePercent;
    private int abilityHaste;
    private ShieldAbilitySettings shieldAbility;
    private WaveBlastAbilitySettings waveBlastAbility;
    private ReviveAbilitySettings reviveAbility;

    public BossRuneModifiers() {
        this(0.0, 0.0, 0);
    }

    public BossRuneModifiers(double healthPercent, double damagePercent, int abilityHaste) {
        this.healthPercent = Math.max(0.0, healthPercent);
        this.damagePercent = Math.max(0.0, damagePercent);
        this.abilityHaste = Math.max(0, abilityHaste);
        this.shieldAbility = null;
        this.waveBlastAbility = null;
        this.reviveAbility = null;
    }

    public double getHealthPercent() {
        return this.healthPercent;
    }

    public double getDamagePercent() {
        return this.damagePercent;
    }

    public int getAbilityHaste() {
        return this.abilityHaste;
    }

    public boolean isEmpty() {
        return this.healthPercent <= 0.0 && this.damagePercent <= 0.0 && this.abilityHaste <= 0;
    }

    public BossRuneModifiers add(BossRuneModifiers other) {
        if (other == null) {
            return this;
        }
        this.healthPercent += Math.max(0.0, other.healthPercent);
        this.damagePercent += Math.max(0.0, other.damagePercent);
        this.abilityHaste += Math.max(0, other.abilityHaste);
        if (other.shieldAbility != null) {
            this.shieldAbility = other.shieldAbility.copy();
        }
        if (other.waveBlastAbility != null) {
            this.waveBlastAbility = other.waveBlastAbility.copy();
        }
        if (other.reviveAbility != null) {
            this.reviveAbility = this.reviveAbility == null ? other.reviveAbility.copy() : this.reviveAbility.merge(other.reviveAbility);
        }
        return this;
    }

    public BossRuneModifiers copy() {
        BossRuneModifiers copy = new BossRuneModifiers(this.healthPercent, this.damagePercent, this.abilityHaste);
        copy.shieldAbility = this.shieldAbility == null ? null : this.shieldAbility.copy();
        copy.waveBlastAbility = this.waveBlastAbility == null ? null : this.waveBlastAbility.copy();
        copy.reviveAbility = this.reviveAbility == null ? null : this.reviveAbility.copy();
        return copy;
    }

    public void copyFrom(BossRuneModifiers other) {
        Objects.requireNonNull(other);
        this.healthPercent = Math.max(0.0, other.healthPercent);
        this.damagePercent = Math.max(0.0, other.damagePercent);
        this.abilityHaste = Math.max(0, other.abilityHaste);
        this.shieldAbility = other.shieldAbility == null ? null : other.shieldAbility.copy();
        this.waveBlastAbility = other.waveBlastAbility == null ? null : other.waveBlastAbility.copy();
        this.reviveAbility = other.reviveAbility == null ? null : other.reviveAbility.copy();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.DOUBLE.writeNbt(this.healthPercent).ifPresent(tag -> nbt.m_128365_("health", tag));
        Adapters.DOUBLE.writeNbt(this.damagePercent).ifPresent(tag -> nbt.m_128365_("damage", tag));
        Adapters.INT.writeNbt(this.abilityHaste).ifPresent(tag -> nbt.m_128365_("ability_haste", tag));
        if (this.shieldAbility != null) {
            nbt.m_128365_("shield", (Tag)this.shieldAbility.toNbt());
        }
        if (this.waveBlastAbility != null) {
            nbt.m_128365_("wave_blast", (Tag)this.waveBlastAbility.toNbt());
        }
        if (this.reviveAbility != null) {
            nbt.m_128365_("revive", (Tag)this.reviveAbility.toNbt());
        }
        return nbt;
    }

    public static BossRuneModifiers fromNbt(CompoundTag nbt) {
        BossRuneModifiers modifiers = new BossRuneModifiers();
        if (nbt == null) {
            return modifiers;
        }
        BossRuneModifiers.readInto(modifiers, nbt);
        return modifiers;
    }

    private static void readInto(BossRuneModifiers target, CompoundTag nbt) {
        target.healthPercent = Adapters.DOUBLE.readNbt(nbt.m_128423_("health")).orElse(0.0);
        target.damagePercent = Adapters.DOUBLE.readNbt(nbt.m_128423_("damage")).orElse(0.0);
        target.abilityHaste = Adapters.INT.readNbt(nbt.m_128423_("ability_haste")).orElse(0);
        target.shieldAbility = ShieldAbilitySettings.fromNbt(nbt.m_128423_("shield"));
        target.waveBlastAbility = WaveBlastAbilitySettings.fromNbt(nbt.m_128423_("wave_blast"));
        target.reviveAbility = ReviveAbilitySettings.fromNbt(nbt.m_128423_("revive"));
    }

    public void readFrom(CompoundTag nbt) {
        if (nbt == null) {
            this.healthPercent = 0.0;
            this.damagePercent = 0.0;
            this.abilityHaste = 0;
            this.shieldAbility = null;
            this.waveBlastAbility = null;
            this.reviveAbility = null;
            return;
        }
        BossRuneModifiers.readInto(this, nbt);
    }

    public Optional<ShieldAbilitySettings> getShieldAbility() {
        return Optional.ofNullable(this.shieldAbility);
    }

    public void setShieldAbility(@Nullable ShieldAbilitySettings ability) {
        this.shieldAbility = ability == null ? null : ability.copy();
    }

    public Optional<WaveBlastAbilitySettings> getWaveBlastAbility() {
        return Optional.ofNullable(this.waveBlastAbility);
    }

    public void setWaveBlastAbility(@Nullable WaveBlastAbilitySettings ability) {
        this.waveBlastAbility = ability == null ? null : ability.copy();
    }

    public Optional<ReviveAbilitySettings> getReviveAbility() {
        return Optional.ofNullable(this.reviveAbility);
    }

    public void setReviveAbility(@Nullable ReviveAbilitySettings ability) {
        this.reviveAbility = ability == null ? null : ability.copy();
    }

    public int getReviveStacks() {
        return this.reviveAbility == null ? 0 : this.reviveAbility.reviveCount();
    }

    public static class ShieldAbilitySettings {
        private final int cooldownTicks;
        private final int durationTicks;
        private final String bossBarColor;
        private final float particleRadius;
        private final double cooldownReductionPerHaste;

        public ShieldAbilitySettings(int cooldownTicks, int durationTicks, BossEvent.BossBarColor bossBarColor, float particleRadius, double cooldownReductionPerHaste) {
            this(cooldownTicks, durationTicks, bossBarColor.m_18886_(), particleRadius, cooldownReductionPerHaste);
        }

        public ShieldAbilitySettings(int cooldownTicks, int durationTicks, String bossBarColor, float particleRadius, double cooldownReductionPerHaste) {
            this.cooldownTicks = Math.max(1, cooldownTicks);
            this.durationTicks = Math.max(1, durationTicks);
            this.bossBarColor = bossBarColor;
            this.particleRadius = particleRadius;
            this.cooldownReductionPerHaste = cooldownReductionPerHaste;
        }

        public int cooldownTicks() {
            return this.cooldownTicks;
        }

        public int durationTicks() {
            return this.durationTicks;
        }

        public BossEvent.BossBarColor bossBarColor() {
            try {
                return BossEvent.BossBarColor.valueOf((String)this.bossBarColor.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return BossEvent.BossBarColor.WHITE;
            }
        }

        public float particleRadius() {
            return this.particleRadius;
        }

        public double cooldownReductionPerHaste() {
            return this.cooldownReductionPerHaste;
        }

        public ShieldAbilitySettings copy() {
            return new ShieldAbilitySettings(this.cooldownTicks, this.durationTicks, this.bossBarColor, this.particleRadius, this.cooldownReductionPerHaste);
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("cooldown", this.cooldownTicks);
            tag.m_128405_("duration", this.durationTicks);
            tag.m_128359_("color", this.bossBarColor);
            tag.m_128350_("particle_radius", this.particleRadius);
            tag.m_128347_("cooldown_reduction", this.cooldownReductionPerHaste);
            return tag;
        }

        public static ShieldAbilitySettings fromNbt(@Nullable Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                return null;
            }
            CompoundTag compoundTag = (CompoundTag)tag;
            int cooldown = compoundTag.m_128451_("cooldown");
            int duration = compoundTag.m_128451_("duration");
            String color = compoundTag.m_128461_("color");
            float radius = compoundTag.m_128441_("particle_radius") ? compoundTag.m_128457_("particle_radius") : 0.0f;
            double reduction = compoundTag.m_128441_("cooldown_reduction") ? compoundTag.m_128459_("cooldown_reduction") : 0.0;
            return new ShieldAbilitySettings(cooldown, duration, color, radius, reduction);
        }
    }

    public static class WaveBlastAbilitySettings {
        private final int cooldownTicks;
        private final float radius;
        private final float damageMultiplier;
        private final double cooldownReductionPerHaste;
        private final float knockbackStrength;

        public WaveBlastAbilitySettings(int cooldownTicks, float radius, float damageMultiplier, double cooldownReductionPerHaste, float knockbackStrength) {
            this.cooldownTicks = Math.max(1, cooldownTicks);
            this.radius = Math.max(0.0f, radius);
            this.damageMultiplier = Math.max(0.0f, damageMultiplier);
            this.cooldownReductionPerHaste = cooldownReductionPerHaste;
            this.knockbackStrength = Math.max(0.0f, knockbackStrength);
        }

        public int cooldownTicks() {
            return this.cooldownTicks;
        }

        public float radius() {
            return this.radius;
        }

        public float damageMultiplier() {
            return this.damageMultiplier;
        }

        public double cooldownReductionPerHaste() {
            return this.cooldownReductionPerHaste;
        }

        public float knockbackStrength() {
            return this.knockbackStrength;
        }

        public WaveBlastAbilitySettings copy() {
            return new WaveBlastAbilitySettings(this.cooldownTicks, this.radius, this.damageMultiplier, this.cooldownReductionPerHaste, this.knockbackStrength);
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("cooldown", this.cooldownTicks);
            tag.m_128350_("radius", this.radius);
            tag.m_128350_("damage_multiplier", this.damageMultiplier);
            tag.m_128347_("cooldown_reduction", this.cooldownReductionPerHaste);
            tag.m_128350_("knockback", this.knockbackStrength);
            return tag;
        }

        public static WaveBlastAbilitySettings fromNbt(@Nullable Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                return null;
            }
            CompoundTag compoundTag = (CompoundTag)tag;
            int cooldown = compoundTag.m_128451_("cooldown");
            float radius = compoundTag.m_128457_("radius");
            float multiplier = compoundTag.m_128457_("damage_multiplier");
            double reduction = compoundTag.m_128441_("cooldown_reduction") ? compoundTag.m_128459_("cooldown_reduction") : 0.0;
            float knockback = compoundTag.m_128441_("knockback") ? compoundTag.m_128457_("knockback") : 0.0f;
            return new WaveBlastAbilitySettings(cooldown, radius, multiplier, reduction, knockback);
        }
    }

    public static class ReviveAbilitySettings {
        private final int reviveCount;
        private final float healthPercent;
        private final int invulnerabilityTicks;

        public ReviveAbilitySettings(int reviveCount, float healthPercent, int invulnerabilityTicks) {
            this.reviveCount = Math.max(0, reviveCount);
            this.healthPercent = Math.max(0.0f, healthPercent);
            this.invulnerabilityTicks = Math.max(0, invulnerabilityTicks);
        }

        public int reviveCount() {
            return this.reviveCount;
        }

        public float healthPercent() {
            return this.healthPercent;
        }

        public int invulnerabilityTicks() {
            return this.invulnerabilityTicks;
        }

        public ReviveAbilitySettings copy() {
            return new ReviveAbilitySettings(this.reviveCount, this.healthPercent, this.invulnerabilityTicks);
        }

        public ReviveAbilitySettings merge(ReviveAbilitySettings other) {
            int totalRevives = this.reviveCount + other.reviveCount;
            float health = Math.max(this.healthPercent, other.healthPercent);
            int invulnerability = Math.max(this.invulnerabilityTicks, other.invulnerabilityTicks);
            return new ReviveAbilitySettings(totalRevives, health, invulnerability);
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("revives", this.reviveCount);
            tag.m_128350_("health", this.healthPercent);
            tag.m_128405_("invulnerability", this.invulnerabilityTicks);
            return tag;
        }

        public static ReviveAbilitySettings fromNbt(@Nullable Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                return null;
            }
            CompoundTag compoundTag = (CompoundTag)tag;
            int revives = compoundTag.m_128451_("revives");
            float health = compoundTag.m_128441_("health") ? compoundTag.m_128457_("health") : 1.0f;
            int invulnerability = compoundTag.m_128441_("invulnerability") ? compoundTag.m_128451_("invulnerability") : 0;
            return new ReviveAbilitySettings(revives, health, invulnerability);
        }
    }
}

