/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import com.google.common.base.Preconditions;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.AnimationSpeedWrapper;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.attack.BasicMeleeAttack;
import iskallia.vault.entity.boss.attack.IMeleeAttack;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class GolemBossEntity
extends VaultBossEntity
implements IAnimatable {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(GolemBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final AnimationSpeedWrapper LEFT_PUNCH_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("LeftPunch", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
    private static final AnimationSpeedWrapper RIGHT_PUNCH_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("RightPunch", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
    private static final AnimationSpeedWrapper DOUBLE_ATTACK_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("DoubleAttack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE), e -> 1.7);
    private static final AnimationSpeedWrapper WALK_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("Walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
    private static final AnimationSpeedWrapper THROW_RIGHT_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("ThrowRight", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
    private static final AnimationSpeedWrapper THROW_LEFT_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("ThrowLeft", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
    private static final AnimationSpeedWrapper GROUND_SLAM_ANIM = new AnimationSpeedWrapper(new AnimationBuilder().addAnimation("GroundSlam", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
    private static final WeightedList<AnimationSpeedWrapper> PUNCH_ANIMATIONS = new WeightedList<AnimationSpeedWrapper>().add(LEFT_PUNCH_ANIM, 2).add(RIGHT_PUNCH_ANIM, 2);
    public static final String PUNCH_ATTACK_NAME = "punch";
    public static final String DOUBLE_PUNCH_ATTACK_NAME = "double_punch";
    public static final String GROUND_SLAM_ATTACK_NAME = "ground_slam";
    public static final BasicMeleeAttack.BasicMeleeAttackAttributes PUNCH_ATTACK = new BasicMeleeAttack.BasicMeleeAttackAttributes(new BasicMeleeAttack.BasicMeleeAttackAttributes.Slice(0.0f, 0.6f), 20, 8, "punch", 1.5f, 0.0f);
    public static final BasicMeleeAttack.BasicMeleeAttackAttributes DOUBLE_PUNCH_ATTACK = new BasicMeleeAttack.BasicMeleeAttackAttributes(new BasicMeleeAttack.BasicMeleeAttackAttributes.Slice(0.0f, 0.6f), 40, 10, "double_punch", 1.5f, 0.0f);
    public static final Map<String, BiFunction<VaultBossBaseEntity, Double, IMeleeAttack>> MELEE_ATTACK_FACTORIES = Map.of("punch", (boss, multiplier) -> new BasicMeleeAttack((VaultBossBaseEntity)boss, (double)multiplier, PUNCH_ATTACK), "double_punch", (boss, multiplier) -> new BasicMeleeAttack((VaultBossBaseEntity)boss, (double)multiplier, DOUBLE_PUNCH_ATTACK));
    private boolean wasLaunchingLastTick = false;
    private int launchAnimationGraceTime = 0;
    @Nullable
    private AnimationSpeedWrapper currentAttackAnimation = null;

    public GolemBossEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return VaultBossEntity.createAttributes().m_22268_(Attributes.f_22282_, 2.5);
    }

    private void setFlag(int bitIndex, boolean value) {
        Preconditions.checkArgument((bitIndex >= 0 && bitIndex <= 7 ? 1 : 0) != 0, (Object)"Bit index must be between 0 and 7.");
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flags = value ? (byte)(flags | 1 << bitIndex) : (byte)(flags & ~(1 << bitIndex));
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flags);
    }

    private boolean getFlag(int bitIndex) {
        Preconditions.checkArgument((bitIndex >= 0 && bitIndex <= 7 ? 1 : 0) != 0, (Object)"Bit index must be between 0 and 7.");
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1 << bitIndex) != 0;
    }

    public void setLaunchingRightHand(boolean launchingHand) {
        this.setFlag(0, launchingHand);
    }

    public void setLaunchingLeftHand(boolean launchingHand) {
        this.setFlag(2, launchingHand);
    }

    public void setShowRightHand(boolean showRightHand) {
        this.setFlag(1, showRightHand);
    }

    public void setShowLeftHand(boolean showLeftHand) {
        this.setFlag(3, showLeftHand);
    }

    public boolean isLaunchingRightHand() {
        return this.getFlag(0);
    }

    private boolean isLaunchingLeftHand() {
        return this.getFlag(2);
    }

    public boolean showsRightHand() {
        return this.getFlag(1);
    }

    public boolean showsLeftHand() {
        return this.getFlag(3);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)10);
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "AttackAnimation", 5.0f, this::attackMoveAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Walking", 5.0f, this::walkAnimController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Launching", 5.0f, this::launchAnimController));
    }

    private PlayState launchAnimController(AnimationEvent<GolemBossEntity> event) {
        AnimationController controller = event.getController();
        if (this.isLaunchingRightHand() || this.isLaunchingLeftHand() || this.wasLaunchingLastTick || --this.launchAnimationGraceTime > 0) {
            this.wasLaunchingLastTick = this.isLaunchingRightHand();
            if (!this.isLaunchingRightHand() && !this.isLaunchingLeftHand() && this.launchAnimationGraceTime <= 0) {
                this.launchAnimationGraceTime = 10;
            }
            if (this.isLaunchingRightHand()) {
                THROW_RIGHT_ANIM.applyTo(controller, this);
            } else if (this.isLaunchingLeftHand()) {
                THROW_LEFT_ANIM.applyTo(controller, this);
            }
            return PlayState.CONTINUE;
        }
        controller.markNeedsReload();
        controller.tickOffset = 1000.0;
        return PlayState.STOP;
    }

    @Override
    public Map<String, BiFunction<VaultBossBaseEntity, Double, IMeleeAttack>> getMeleeAttackFactories() {
        return MELEE_ATTACK_FACTORIES;
    }

    @Override
    public double getAttackReach() {
        return 3.0;
    }

    private PlayState attackMoveAnimController(AnimationEvent<GolemBossEntity> event) {
        AnimationController controller = event.getController();
        return this.getActiveAttackMove().map(attackMove -> {
            if (attackMove.equals(PUNCH_ATTACK_NAME)) {
                if (this.currentAttackAnimation == null) {
                    this.currentAttackAnimation = PUNCH_ANIMATIONS.getRandom(this.f_19853_.f_46441_).orElse(null);
                    return PlayState.STOP;
                }
                this.currentAttackAnimation.applyTo(controller, this);
                return PlayState.CONTINUE;
            }
            if (attackMove.equals(DOUBLE_PUNCH_ATTACK_NAME)) {
                if (this.currentAttackAnimation == null) {
                    this.currentAttackAnimation = DOUBLE_ATTACK_ANIM;
                    return PlayState.STOP;
                }
                this.currentAttackAnimation.applyTo(controller, this);
                return PlayState.CONTINUE;
            }
            if (!attackMove.equals(GROUND_SLAM_ATTACK_NAME)) return PlayState.STOP;
            if (this.currentAttackAnimation == null) {
                this.currentAttackAnimation = GROUND_SLAM_ANIM;
                return PlayState.STOP;
            }
            this.currentAttackAnimation.applyTo(controller, this);
            return PlayState.CONTINUE;
        }).orElseGet(() -> {
            this.currentAttackAnimation = null;
            controller.markNeedsReload();
            return PlayState.STOP;
        });
    }

    private PlayState walkAnimController(AnimationEvent<GolemBossEntity> event) {
        if (event.isMoving()) {
            WALK_ANIM.applyTo(event.getController(), this);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }
}

