/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.entity.boss.GolemBossEntity;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.StonefallParticleMessage;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;

public class GolemHandProjectileEntity
extends AbstractHurtingProjectile {
    private float damage;
    @Nullable
    private LivingEntity target;
    private boolean rightHand;
    private boolean hasBeenShot;

    public GolemHandProjectileEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public GolemHandProjectileEntity(Level level, VaultBossBaseEntity boss, double x, double y, double z, LivingEntity target, float damage, boolean rightHand) {
        this(ModEntities.GOLEM_HAND_PROJECTILE, level, boss, x, y, z, target, damage, rightHand);
    }

    protected GolemHandProjectileEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level, VaultBossBaseEntity boss, double x, double y, double z, LivingEntity target, float damage, boolean rightHand) {
        super(entityType, (LivingEntity)boss, x, y, z, level);
        this.target = target;
        this.damage = damage;
        this.rightHand = rightHand;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123762_;
    }

    private void particleTrail() {
        ParticleEngine pm = Minecraft.m_91087_().f_91061_;
        Vec3 offset = new Vec3(this.f_19796_.nextDouble() / 8.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1), this.f_19796_.nextDouble() / 8.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1), this.f_19796_.nextDouble() / 8.0 * (double)(this.f_19796_.nextBoolean() ? 1 : -1));
        Vec3 direction = this.m_20184_().m_82541_().m_82490_((double)0.05f);
        Vec3 center = this.m_142469_().m_82399_();
        pm.m_107370_((ParticleOptions)ParticleTypes.f_123755_, center.f_82479_ + offset.f_82479_ + direction.f_82479_ * (double)this.f_19796_.nextFloat() * (double)0.2f, center.f_82480_ + offset.f_82480_ + direction.f_82480_ * (double)this.f_19796_.nextFloat() * (double)0.2f, center.f_82481_ + offset.f_82481_ + direction.f_82481_ * (double)this.f_19796_.nextFloat() * (double)0.2f, direction.f_82479_, direction.f_82480_, direction.f_82481_);
    }

    protected boolean m_5931_() {
        return false;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.f_19853_.f_46443_) {
            hitResult.m_82443_().m_6469_(DamageSource.f_19319_, this.damage);
        }
    }

    private boolean checkLeftOwner() {
        Entity entity = this.m_37282_();
        if (entity != null) {
            for (Entity entity1 : this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), p_37272_ -> !p_37272_.m_5833_() && p_37272_.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    public void m_8119_() {
        Entity entity = this.m_37282_();
        if (this.f_19853_.f_46443_ || (entity == null || !entity.m_146910_()) && this.f_19853_.m_46805_(this.m_142538_())) {
            HitResult hitresult;
            super.m_6075_();
            if (!this.hasBeenShot) {
                this.m_146855_(GameEvent.f_157778_, this.m_37282_(), this.m_142538_());
                this.hasBeenShot = true;
            }
            if (!this.f_37246_) {
                this.f_37246_ = this.checkLeftOwner();
            }
            if (this.m_5931_()) {
                this.m_20254_(1);
            }
            if ((hitresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0))).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d1 = this.m_20186_() + vec3.f_82480_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            float f = this.m_6884_();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d0 - vec3.f_82479_ * 0.25, d1 - vec3.f_82480_ * 0.25, d2 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                f = 0.8f;
            }
            this.m_20256_(vec3.m_82520_(this.f_36813_, this.f_36814_, this.f_36815_).m_82490_((double)f));
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_146870_();
        }
        if (this.f_19853_.f_46443_ && this.m_183503_().m_46467_() % 2L == 0L) {
            this.particleTrail();
        }
        if (this.target == null && !this.f_19853_.m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.f_46443_) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StonefallParticleMessage(new Vec3(this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_()), 2.0f));
            this.f_19853_.m_6263_(null, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), ModSounds.ARTIFACT_BOSS_MAGIC_ATTACK_HIT, SoundSource.BLOCKS, 1.0f, 0.75f + new Random().nextFloat() * 0.35f);
            Entity entity = this.m_37282_();
            if (entity instanceof GolemBossEntity) {
                GolemBossEntity golem = (GolemBossEntity)entity;
                if (this.isRightHand()) {
                    golem.setShowRightHand(true);
                } else {
                    golem.setShowLeftHand(true);
                }
            }
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean isRightHand() {
        return this.rightHand;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Damage", this.damage);
        if (this.target != null) {
            tag.m_128362_("Target", this.target.m_142081_());
        }
        tag.m_128379_("RightHand", this.rightHand);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.damage = tag.m_128457_("Damage");
        this.target = tag.m_128441_("Target") ? this.f_19853_.m_46003_(tag.m_128342_("Target")) : null;
        this.rightHand = tag.m_128471_("RightHand");
    }
}

